/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.job.memory;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.pdf.job.Job;
import org.kuali.research.pdf.job.JobDao;
import org.kuali.research.pdf.job.memory.JobDaoMemoryImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(name={"mongo.enabled"}, havingValue="false", matchIfMissing=true)
@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/kuali/research/pdf/job/memory/JobDaoMemoryImpl;", "Lorg/kuali/research/pdf/job/JobDao;", "<init>", "()V", "findById", "Lorg/kuali/research/pdf/job/Job;", "id", "", "findAll", "", "save", "", "job", "Companion", "pdf"})
public class JobDaoMemoryImpl
implements JobDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ConcurrentHashMap<String, Job> jobs = new ConcurrentHashMap();

    @Nullable
    public Job findById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (Job)jobs.get(id);
    }

    @NotNull
    public List<Job> findAll() {
        Collection collection = jobs.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    public void save(@NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Map map = jobs;
        String string = job.getJobId();
        Intrinsics.checkNotNull((Object)string);
        map.put(string, job);
    }
}

