/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.link;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.pdf.link.ActionLink;
import org.kuali.research.pdf.link.ActionLinkService;
import org.kuali.research.pdf.link.HttpLink;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkService;
import org.kuali.research.pdf.sys.model.PdfException;
import org.kuali.research.pdf.sys.model.Props;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ConditionalOnProperty(name={"allow.file.links"}, havingValue="false", matchIfMissing=true)
@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0010H\u0012J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\"\u0010\u0017\u001a\u00020\u00182\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u000f0\u001aH\u0012J*\u0010\u001c\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bH\u0016J \u0010 \u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/kuali/research/pdf/link/LinkServiceImpl;", "Lorg/kuali/research/pdf/link/LinkService;", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "actionLinkService", "Lorg/kuali/research/pdf/link/ActionLinkService;", "<init>", "(Lorg/springframework/web/client/RestTemplate;Lorg/kuali/research/pdf/link/ActionLinkService;)V", "getRestTemplate", "()Lorg/springframework/web/client/RestTemplate;", "getActionLinkService", "()Lorg/kuali/research/pdf/link/ActionLinkService;", "needsExpanding", "", "links", "", "Lorg/kuali/research/pdf/link/Link;", "link", "expand", "input", "Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "toHeaders", "Lorg/springframework/http/HttpHeaders;", "headersMap", "", "", "newIfNull", "jobId", "actionId", "fileNumberPattern", "new", "pdf"})
@SourceDebugExtension(value={"SMAP\nLinkServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkServiceImpl.kt\norg/kuali/research/pdf/link/LinkServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LinkModel.kt\norg/kuali/research/pdf/link/ActionLink\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1755#2,3:107\n1368#2:113\n1454#2,5:114\n194#3:110\n189#3,2:111\n1#4:119\n*S KotlinDebug\n*F\n+ 1 LinkServiceImpl.kt\norg/kuali/research/pdf/link/LinkServiceImpl\n*L\n40#1:107,3\n44#1:113\n44#1:114,5\n42#1:110\n42#1:111,2\n*E\n"})
public class LinkServiceImpl
implements LinkService {
    @NotNull
    private final RestTemplate restTemplate;
    @NotNull
    private final ActionLinkService actionLinkService;

    public LinkServiceImpl(@Autowired @NotNull RestTemplate restTemplate, @Autowired @NotNull ActionLinkService actionLinkService) {
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        Intrinsics.checkNotNullParameter((Object)actionLinkService, (String)"actionLinkService");
        this.restTemplate = restTemplate;
        this.actionLinkService = actionLinkService;
    }

    @NotNull
    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @NotNull
    public ActionLinkService getActionLinkService() {
        return this.actionLinkService;
    }

    public boolean needsExpanding(@NotNull List<? extends Link> links) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(links, (String)"links");
            Iterable $this$any$iv = links;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Link it = (Link)element$iv;
                    boolean bl2 = false;
                    if (!this.needsExpanding(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean needsExpanding(Link link) {
        if (!(link instanceof ActionLink)) return false;
        ActionLink this_$iv = (ActionLink)link;
        boolean $i$f$getNeedsExpanding = false;
        ActionLink this_$iv$iv = this_$iv;
        boolean $i$f$getFileNumberPattern = false;
        String path$iv$iv = StringsKt.removePrefix((String)this_$iv$iv.getUrl(), (CharSequence)(this_$iv$iv.protocol() + "://"));
        if (!Intrinsics.areEqual((Object)StringsKt.substringAfterLast$default((String)path$iv$iv, (String)"/", null, (int)2, null), (Object)"*")) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Link> expand(@NotNull List<? extends Link> links) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(links, (String)"links");
        Iterable $this$flatMap$iv = links;
        boolean $i$f$flatMap = false;
        Iterable iterable2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Link it = (Link)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.expand(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private List<Link> expand(Link link) {
        return link instanceof ActionLink ? this.getActionLinkService().expand((ActionLink)link) : CollectionsKt.listOf((Object)link);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public InputStream input(@NotNull Link link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Link link2 = link;
        if (link2 instanceof HttpLink) {
            InputStream inputStream;
            Resource resource = (Resource)this.getRestTemplate().exchange(new RequestEntity((MultiValueMap)this.toHeaders(((HttpLink)link).getHeaders()), HttpMethod.valueOf((String)((HttpLink)link).getMethod().toString()), new URI(((HttpLink)link).getUrl())), Resource.class).getBody();
            if (resource == null || (inputStream = resource.getInputStream()) == null) throw new PdfException("cannot.fetch.link.resource", MapsKt.mapOf((Pair)Props.URL.pair((Object)((HttpLink)link).getUrl())), "Cannot fetch link resource " + ((HttpLink)link).getUrl(), null, 8, null);
            v0 = inputStream;
            return v0;
        } else if (link2 instanceof ActionLink) {
            v0 = this.getActionLinkService().input((ActionLink)link);
            return v0;
        } else {
            String string = link.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            throw new PdfException("unsupported.link.type", MapsKt.mapOf((Pair)Props.LINK_TYPE.pair((Object)string)), "Unsupported link type " + link, null, 8, null);
        }
    }

    @NotNull
    public OutputStream output(@NotNull Link link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        if (!(link instanceof ActionLink)) {
            String string = link.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            throw new PdfException("unsupported.link.type", MapsKt.mapOf((Pair)Props.LINK_TYPE.pair((Object)string)), "Unsupported link type " + link, null, 8, null);
        }
        return this.getActionLinkService().output((ActionLink)link);
    }

    private HttpHeaders toHeaders(Map<String, ? extends List<String>> headersMap) {
        HttpHeaders httpHeaders;
        HttpHeaders $this$toHeaders_u24lambda_u242 = httpHeaders = new HttpHeaders();
        boolean bl = false;
        $this$toHeaders_u24lambda_u242.putAll(headersMap);
        return httpHeaders;
    }

    @NotNull
    public Link newIfNull(@Nullable Link link, @NotNull String jobId, @NotNull String actionId, @NotNull String fileNumberPattern) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)fileNumberPattern, (String)"fileNumberPattern");
        return link == null ? this.new(jobId, actionId, fileNumberPattern) : link;
    }

    @NotNull
    public Link new(@NotNull String jobId, @NotNull String actionId, @NotNull String fileNumberPattern) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)fileNumberPattern, (String)"fileNumberPattern");
        return (Link)new ActionLink("action://" + jobId + "/" + actionId + "/" + fileNumberPattern);
    }
}

