/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.mapper.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.mapper.MapperFunctionProvider;
import org.kuali.research.pdf.mapper.MappingDefinition;
import org.kuali.research.pdf.mapper.internal.MapOutput;
import org.kuali.research.pdf.mapper.internal.MapRequest;
import org.kuali.research.pdf.mapper.internal.MapResponse;
import org.kuali.research.pdf.mapper.internal.MapperContext;
import org.kuali.research.pdf.mapper.internal.MapperService;
import org.kuali.research.pdf.mapper.internal.MapperServiceImpl;
import org.kuali.research.pdf.mapper.internal.MapperServiceImplKt;
import org.kuali.research.pdf.mapper.internal.SecureTypeLocator;
import org.kuali.research.pdf.sys.model.Message;
import org.kuali.research.pdf.sys.model.Status;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0017\u0012\u000e\b\u0001\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0012J\u001a\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0012J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u00042\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0012R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"Lorg/kuali/research/pdf/mapper/internal/MapperServiceImpl;", "Lorg/kuali/research/pdf/mapper/internal/MapperService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "mapperProviders", "", "Lorg/kuali/research/pdf/mapper/MapperFunctionProvider;", "<init>", "(Ljava/util/List;)V", "getMapperProviders", "()Ljava/util/List;", "map", "Lorg/kuali/research/pdf/mapper/internal/MapResponse;", "mapRequest", "Lorg/kuali/research/pdf/mapper/internal/MapRequest;", "handleErrorOrWarning", "Lorg/kuali/research/pdf/mapper/internal/MapOutput;", "pe", "Ljava/lang/Exception;", "Lkotlin/Exception;", "def", "Lorg/kuali/research/pdf/mapper/MappingDefinition;", "isWarning", "", "toMapOutput", "definition", "response", "", "expandMapping", "mappingDefinition", "parser", "Lorg/springframework/expression/spel/standard/SpelExpressionParser;", "context", "Lorg/springframework/expression/EvaluationContext;", "Companion", "pdf"})
@SourceDebugExtension(value={"SMAP\nMapperServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapperServiceImpl.kt\norg/kuali/research/pdf/mapper/internal/MapperServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,173:1\n1368#2:174\n1454#2,5:175\n1863#2,2:180\n1368#2:182\n1454#2,5:183\n1498#2:188\n1528#2,3:189\n1531#2,3:199\n1368#2:202\n1454#2,5:203\n381#3,7:192\n*S KotlinDebug\n*F\n+ 1 MapperServiceImpl.kt\norg/kuali/research/pdf/mapper/internal/MapperServiceImpl\n*L\n49#1:174\n49#1:175,5\n50#1:180,2\n55#1:182\n55#1:183,5\n56#1:188\n56#1:189,3\n56#1:199,3\n142#1:202\n142#1:203,5\n56#1:192,7\n*E\n"})
public class MapperServiceImpl
implements MapperService,
Logging {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<MapperFunctionProvider> mapperProviders;
    @NotNull
    private static final String ARRAY_INDICATOR = "[]";

    public MapperServiceImpl(@Autowired @NotNull List<? extends MapperFunctionProvider> mapperProviders) {
        Intrinsics.checkNotNullParameter(mapperProviders, (String)"mapperProviders");
        this.mapperProviders = mapperProviders;
    }

    @NotNull
    public List<MapperFunctionProvider> getMapperProviders() {
        return this.mapperProviders;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MapResponse map(@NotNull MapRequest mapRequest) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)mapRequest, (String)"mapRequest");
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext $this$map_u24lambda_u242 = object = new StandardEvaluationContext((Object)new MapperContext());
        boolean $i$a$-apply-MapperServiceImpl$map$context$22 = false;
        $this$map_u24lambda_u242.setTypeLocator((TypeLocator)new SecureTypeLocator((TypeLocator)new StandardTypeLocator()));
        $this$map_u24lambda_u242.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        $this$map_u24lambda_u242.setVariables(mapRequest.getInput());
        Iterable iterable2 = this.getMapperProviders();
        boolean $i$f$flatMap = false;
        Iterator iterator2 = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            MapperFunctionProvider it = (MapperFunctionProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.mapperFunctionsWithName();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            $this$map_u24lambda_u242.registerFunction((String)it.getFirst(), (Method)it.getSecond());
        }
        StandardEvaluationContext context = object;
        object = mapRequest.getMappings();
        boolean $i$f$flatMap2 = false;
        void $i$a$-apply-MapperServiceImpl$map$context$22 = $this$flatMap$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MappingDefinition it = (MappingDefinition)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.expandMapping(it, parser, (EvaluationContext)context);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            MapOutput mapOutput;
            Object object2;
            MappingDefinition it = (MappingDefinition)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getKey();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            it = (MappingDefinition)element$iv$iv;
            List list = list$iv$iv;
            boolean bl3 = false;
            try {
                mapOutput = this.toMapOutput(it, parser.parseExpression(it.getExpression()).getValue((EvaluationContext)context));
            }
            catch (SpelEvaluationException pe) {
                mapOutput = this.handleErrorOrWarning((Exception)((Object)pe), it, mapRequest.getLenient() || MapperServiceImplKt.getSPEL_EXPRESSION_WARNINGS().contains(pe.getMessageCode()));
            }
            catch (Exception pe) {
                mapOutput = this.handleErrorOrWarning(pe, it, false);
            }
            list.add(mapOutput);
        }
        Status status = Status.SUCCESS;
        Object object3 = destination$iv$iv2;
        return new MapResponse((Map)object3, status);
    }

    private MapOutput handleErrorOrWarning(Exception pe, MappingDefinition def, boolean isWarning) {
        String logMessage = "Expression failed for \"" + def.getKey() + "\": " + pe.getMessage();
        if (isWarning) {
            this.getLogger().warn((CharSequence)logMessage);
        } else {
            this.getLogger().error((CharSequence)logMessage);
        }
        Message message = isWarning ? Message.Companion.warn$default((Message.Companion)Message.Companion, (String)("Unable to evaluate expression from " + def + ": " + pe), (String)"expression.evaluation.failed", null, (int)4, null) : Message.Companion.error$default((Message.Companion)Message.Companion, (String)("Unable to evaluate expression from " + def + ": " + pe), (String)"expression.evaluation.failed", null, (int)4, null);
        return new MapOutput(null, false, def.getAction(), CollectionsKt.listOf((Object)message), 2, null);
    }

    private MapOutput toMapOutput(MappingDefinition definition, Object response) {
        MapOutput mapOutput;
        String string = definition.getAction();
        if (Intrinsics.areEqual((Object)string, (Object)"setMultivalues")) {
            mapOutput = new MapOutput((Object)(!(response instanceof Collection) ? (Collection)CollectionsKt.listOf((Object)response) : (Collection)response), false, definition.getAction(), null, 10, null);
        } else if (Intrinsics.areEqual((Object)string, (Object)"setVisibility")) {
            Intrinsics.checkNotNull((Object)response, (String)"null cannot be cast to non-null type kotlin.Boolean");
            boolean bl = (Boolean)response;
            String string2 = definition.getAction();
            boolean bl2 = (Boolean)response;
            mapOutput = new MapOutput((Object)bl2, bl, string2, null, 8, null);
        } else {
            mapOutput = new MapOutput(response, false, definition.getAction(), null, 10, null);
        }
        return mapOutput;
    }

    /*
     * WARNING - void declaration
     */
    private List<MappingDefinition> expandMapping(MappingDefinition mappingDefinition, SpelExpressionParser parser, EvaluationContext context) {
        List list;
        if (StringsKt.contains$default((CharSequence)mappingDefinition.getKey(), (CharSequence)ARRAY_INDICATOR, (boolean)false, (int)2, null)) {
            void $this$flatMapTo$iv$iv;
            int n;
            try {
                Object object = parser.parseExpression(StringsKt.replaceBeforeLast$default((String)StringsKt.substringBefore$default((String)mappingDefinition.getExpression(), (String)ARRAY_INDICATOR, null, (int)2, null), (String)"#", (String)"", null, (int)4, null)).getValue(context);
                Intrinsics.checkNotNull((Object)object);
                n = ((Collection)object).size();
            }
            catch (Exception pe) {
                this.getLogger().debug((Object)pe);
                n = 1;
            }
            int actualSize = n;
            Iterable $this$flatMap$iv = (Iterable)RangesKt.until((int)0, (int)actualSize);
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv$iv;
                int it = element$iv$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                Iterable list$iv$iv = this.expandMapping(new MappingDefinition(StringsKt.replaceFirst$default((String)mappingDefinition.getKey(), (String)ARRAY_INDICATOR, (String)("[" + it + "]"), (boolean)false, (int)4, null), mappingDefinition.getAction(), StringsKt.replaceFirst$default((String)mappingDefinition.getExpression(), (String)ARRAY_INDICATOR, (String)("[" + it + "]"), (boolean)false, (int)4, null)), parser, context);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.listOf((Object)mappingDefinition);
        }
        return list;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

