/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.attachment;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.filespec.PdfFileSpec;
import java.io.Closeable;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.pdf.action.Action;
import org.kuali.research.pdf.action.ActionHelperService;
import org.kuali.research.pdf.action.ActionService;
import org.kuali.research.pdf.attachment.Attachment;
import org.kuali.research.pdf.attachment.AttachmentPutAction;
import org.kuali.research.pdf.form.AttachmentAssociatedAction;
import org.kuali.research.pdf.form.AttachmentDescriptionAction;
import org.kuali.research.pdf.form.AttachmentEmbeddedAction;
import org.kuali.research.pdf.form.AttachmentFileDisplayAction;
import org.kuali.research.pdf.form.AttachmentLocationAction;
import org.kuali.research.pdf.form.AttachmentMimeTypeAction;
import org.kuali.research.pdf.form.AttachmentSizeAction;
import org.kuali.research.pdf.form.AttachmentTokenAction;
import org.kuali.research.pdf.form.FieldAction;
import org.kuali.research.pdf.link.ActionLink;
import org.kuali.research.pdf.link.ActionLinkInitFinalizeService;
import org.kuali.research.pdf.link.HttpLink;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkService;
import org.kuali.research.pdf.sys.model.Message;
import org.kuali.research.pdf.sys.model.Props;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001!B/\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\u0017\u001a\u00020\u0002H\u0012J\u001e\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0012J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lorg/kuali/research/pdf/attachment/AttachmentPutActionServiceImpl;", "Lorg/kuali/research/pdf/action/ActionService;", "Lorg/kuali/research/pdf/attachment/AttachmentPutAction;", "Lorg/apache/logging/log4j/kotlin/Logging;", "actionHelperService", "Lorg/kuali/research/pdf/action/ActionHelperService;", "linkService", "Lorg/kuali/research/pdf/link/LinkService;", "actionLinkInitFinalizeService", "Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lorg/kuali/research/pdf/action/ActionHelperService;Lorg/kuali/research/pdf/link/LinkService;Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getActionHelperService", "()Lorg/kuali/research/pdf/action/ActionHelperService;", "getLinkService", "()Lorg/kuali/research/pdf/link/LinkService;", "getActionLinkInitFinalizeService", "()Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "init", "action", "exec", "fetchAttachments", "", "", "Lorg/kuali/research/pdf/attachment/Attachment;", "fetchAttachmentActions", "attachmentActionSource", "Lorg/kuali/research/pdf/link/Link;", "finalize", "TempAttachment", "pdf"})
@SourceDebugExtension(value={"SMAP\nAttachmentPutActionServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachmentPutActionServiceImpl.kt\norg/kuali/research/pdf/attachment/AttachmentPutActionServiceImpl\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,209:1\n60#2:210\n51#2:211\n538#3:212\n523#3,2:213\n525#3,4:218\n465#3:222\n415#3:223\n465#3:230\n415#3:231\n465#3:236\n415#3:237\n538#3:242\n523#3,6:243\n538#3:253\n523#3,6:254\n465#3:268\n415#3:269\n1761#4,3:215\n1252#4,2:224\n1803#4,3:226\n1255#4:229\n1252#4,4:232\n1252#4,4:238\n1252#4,4:270\n126#5:249\n153#5,3:250\n126#5:260\n153#5,3:261\n216#5,2:264\n216#5,2:266\n*S KotlinDebug\n*F\n+ 1 AttachmentPutActionServiceImpl.kt\norg/kuali/research/pdf/attachment/AttachmentPutActionServiceImpl\n*L\n129#1:210\n129#1:211\n132#1:212\n132#1:213,2\n132#1:218,4\n133#1:222\n133#1:223\n155#1:230\n155#1:231\n42#1:236\n42#1:237\n82#1:242\n82#1:243,6\n99#1:253\n99#1:254,6\n173#1:268\n173#1:269\n132#1:215,3\n133#1:224,2\n134#1:226,3\n133#1:229\n155#1:232,4\n42#1:238,4\n173#1:270,4\n83#1:249\n83#1:250,3\n100#1:260\n100#1:261,3\n110#1:264,2\n111#1:266,2\n*E\n"})
public class AttachmentPutActionServiceImpl
implements ActionService<AttachmentPutAction>,
Logging {
    @NotNull
    private final ActionHelperService actionHelperService;
    @NotNull
    private final LinkService linkService;
    @NotNull
    private final ActionLinkInitFinalizeService actionLinkInitFinalizeService;
    @NotNull
    private final ObjectMapper objectMapper;

    public AttachmentPutActionServiceImpl(@Autowired @NotNull ActionHelperService actionHelperService, @Autowired @NotNull LinkService linkService, @Autowired @NotNull ActionLinkInitFinalizeService actionLinkInitFinalizeService, @Autowired @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)actionHelperService, (String)"actionHelperService");
        Intrinsics.checkNotNullParameter((Object)linkService, (String)"linkService");
        Intrinsics.checkNotNullParameter((Object)actionLinkInitFinalizeService, (String)"actionLinkInitFinalizeService");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.actionHelperService = actionHelperService;
        this.linkService = linkService;
        this.actionLinkInitFinalizeService = actionLinkInitFinalizeService;
        this.objectMapper = objectMapper;
    }

    @NotNull
    public ActionHelperService getActionHelperService() {
        return this.actionHelperService;
    }

    @NotNull
    public LinkService getLinkService() {
        return this.linkService;
    }

    @NotNull
    public ActionLinkInitFinalizeService getActionLinkInitFinalizeService() {
        return this.actionLinkInitFinalizeService;
    }

    @NotNull
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    @NotNull
    public AttachmentPutAction init(@NotNull AttachmentPutAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (AttachmentPutAction)this.getActionHelperService().initOneToOne((Action)action, arg_0 -> AttachmentPutActionServiceImpl.init$lambda$1(this, arg_0));
    }

    @Override
    @NotNull
    public AttachmentPutAction exec(@NotNull AttachmentPutAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (AttachmentPutAction)this.getActionHelperService().execOneToOne((Action)action, (arg_0, arg_1) -> AttachmentPutActionServiceImpl.exec$lambda$8(this, action, arg_0, arg_1));
    }

    private Map<String, Attachment> fetchAttachments(AttachmentPutAction action) {
        return MapsKt.plus(action.getAttachments(), this.fetchAttachmentActions(action.getAttachmentActionSource()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Map<String, Attachment> fetchAttachmentActions(Link attachmentActionSource) {
        Map map;
        Link link = attachmentActionSource;
        if (link != null) {
            Link sourceLink = link;
            boolean bl = false;
            Closeable closeable = this.getLinkService().input(sourceLink);
            Throwable throwable = null;
            try {
                Object object;
                Map.Entry it;
                Map map2;
                Object k;
                Map.Entry it$iv$iv;
                Map $this$mapValuesTo$iv$iv;
                Map $this$mapValues$iv;
                Object element$iv;
                Object $this$any$iv;
                void $this$filterTo$iv$iv;
                Map $this$filter$iv;
                InputStream inputStream = (InputStream)closeable;
                boolean bl2 = false;
                Object $this$readValue$iv = this.getObjectMapper();
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef22 = false;
                Map actions = (Map)$this$readValue$iv.readValue(inputStream, (TypeReference)new TypeReference<Map<String, ? extends List<? extends FieldAction>>>(){});
                $this$readValue$iv = actions;
                boolean $i$f$filter = false;
                void $i$f$jacksonTypeRef22 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    boolean bl3;
                    Map.Entry element$iv$iv;
                    block21: {
                        Map.Entry mapEntry = element$iv$iv = iterator2.next();
                        boolean bl4 = false;
                        $this$any$iv = (Iterable)mapEntry.getValue();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            Iterator iterator3 = $this$any$iv.iterator();
                            while (iterator3.hasNext()) {
                                element$iv = iterator3.next();
                                FieldAction it2 = (FieldAction)element$iv;
                                boolean bl5 = false;
                                if (!Intrinsics.areEqual((Object)it2.getName(), (Object)"setAttachmentLocation")) continue;
                                bl3 = true;
                                break block21;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $this$filter$iv = destination$iv$iv;
                boolean $i$f$mapValues = false;
                $this$filterTo$iv$iv = $this$mapValues$iv;
                destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void $this$fold$iv;
                    $this$any$iv = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv;
                    boolean bl6 = false;
                    element$iv = (Map.Entry)element$iv$iv$iv;
                    k = it$iv$iv.getKey();
                    map2 = map3;
                    boolean bl7 = false;
                    Iterable bl5 = (Iterable)it.getValue();
                    TempAttachment initial$iv = new TempAttachment(false, false, null, null, null, null, null, null, 255, null);
                    boolean $i$f$fold = false;
                    TempAttachment accumulator$iv = initial$iv;
                    for (Object element$iv2 : $this$fold$iv) {
                        TempAttachment tempAttachment;
                        void action;
                        FieldAction fieldAction = (FieldAction)element$iv2;
                        TempAttachment acc = accumulator$iv;
                        boolean bl8 = false;
                        void var34_47 = action;
                        if (var34_47 instanceof AttachmentEmbeddedAction) {
                            tempAttachment = TempAttachment.copy$default(acc, ((AttachmentEmbeddedAction)action).getValue(), false, null, null, null, null, null, null, 254, null);
                        } else if (var34_47 instanceof AttachmentAssociatedAction) {
                            tempAttachment = TempAttachment.copy$default(acc, false, ((AttachmentAssociatedAction)action).getValue(), null, null, null, null, null, null, 253, null);
                        } else if (var34_47 instanceof AttachmentLocationAction) {
                            tempAttachment = TempAttachment.copy$default(acc, false, false, new HttpLink(((AttachmentLocationAction)action).getValue(), null, null, 6, null), null, null, null, null, null, 251, null);
                        } else if (var34_47 instanceof AttachmentTokenAction) {
                            Link link2 = acc.getLocation();
                            Intrinsics.checkNotNull((Object)link2, (String)"null cannot be cast to non-null type org.kuali.research.pdf.link.HttpLink");
                            tempAttachment = TempAttachment.copy$default(acc, false, false, HttpLink.copy$default((HttpLink)link2, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)CollectionsKt.listOf((Object)((AttachmentTokenAction)action).getValue()))), null, 5, null), null, null, null, null, null, 251, null);
                        } else {
                            tempAttachment = var34_47 instanceof AttachmentFileDisplayAction ? TempAttachment.copy$default(acc, false, false, null, ((AttachmentFileDisplayAction)action).getValue(), null, null, null, null, 247, null) : (var34_47 instanceof AttachmentDescriptionAction ? TempAttachment.copy$default(acc, false, false, null, null, ((AttachmentDescriptionAction)action).getValue(), null, null, null, 239, null) : (var34_47 instanceof AttachmentMimeTypeAction ? TempAttachment.copy$default(acc, false, false, null, null, null, null, ((AttachmentMimeTypeAction)action).getValue(), null, 191, null) : (var34_47 instanceof AttachmentSizeAction ? TempAttachment.copy$default(acc, false, false, null, null, null, null, null, ((AttachmentSizeAction)action).getValue(), 127, null) : acc)));
                        }
                        accumulator$iv = tempAttachment;
                    }
                    object = accumulator$iv;
                    map2.put(k, object);
                }
                $this$mapValues$iv = destination$iv$iv;
                $i$f$mapValues = false;
                $this$mapValuesTo$iv$iv = $this$mapValues$iv;
                destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                $i$f$mapValuesTo = false;
                $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    it$iv$iv = (Map.Entry)element$iv$iv$iv;
                    Map map4 = destination$iv$iv;
                    boolean bl9 = false;
                    it = (Map.Entry)element$iv$iv$iv;
                    k = it$iv$iv.getKey();
                    map2 = map4;
                    boolean bl10 = false;
                    boolean bl11 = ((TempAttachment)it.getValue()).getEmbedded();
                    boolean bl12 = ((TempAttachment)it.getValue()).getAssociated();
                    Link link3 = ((TempAttachment)it.getValue()).getLocation();
                    Intrinsics.checkNotNull((Object)link3);
                    object = new Attachment(bl11, bl12, link3, ((TempAttachment)it.getValue()).getFileDisplay(), ((TempAttachment)it.getValue()).getDescription(), ((TempAttachment)it.getValue()).getModDate(), ((TempAttachment)it.getValue()).getMimeType(), ((TempAttachment)it.getValue()).getSize());
                    map2.put(k, object);
                }
                Map map5 = destination$iv$iv;
                map = map5;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        map = MapsKt.emptyMap();
        return map;
    }

    @Override
    @NotNull
    public AttachmentPutAction finalize(@NotNull AttachmentPutAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (AttachmentPutAction)this.getActionHelperService().finalizeOneToOne((Action)action, arg_0 -> AttachmentPutActionServiceImpl.finalize$lambda$17(this, arg_0));
    }

    @Override
    @NotNull
    public AttachmentPutAction preValidate(@NotNull AttachmentPutAction action) {
        return (AttachmentPutAction)ActionService.DefaultImpls.preValidate(this, (Action)action);
    }

    @Override
    @NotNull
    public AttachmentPutAction postValidate(@NotNull AttachmentPutAction action) {
        return (AttachmentPutAction)ActionService.DefaultImpls.postValidate(this, (Action)action);
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }

    /*
     * WARNING - void declaration
     */
    private static final AttachmentPutAction init$lambda$1(AttachmentPutActionServiceImpl this$0, AttachmentPutAction executingAction) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Map<String, Attachment> $this$mapValues$iv = executingAction.getAttachments();
        boolean $i$f$mapValues = false;
        Map<String, Attachment> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Link location = ((Attachment)it.getValue()).getLocation();
            Attachment attachment = location instanceof ActionLink ? Attachment.copy$default((Attachment)it.getValue(), false, false, this$0.getActionLinkInitFinalizeService().init((ActionLink)location, executingAction), null, null, null, null, null, 251, null) : (Attachment)it.getValue();
            map3.put(k, attachment);
        }
        Map attachments = destination$iv$iv;
        Link attachmentActionSource = executingAction.getAttachmentActionSource() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().init((ActionLink)executingAction.getAttachmentActionSource(), executingAction) : executingAction.getAttachmentActionSource();
        return AttachmentPutAction.copy$default(executingAction, null, null, null, attachments, attachmentActionSource, null, false, null, null, null, 999, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final AttachmentPutAction exec$lambda$8(AttachmentPutActionServiceImpl this$0, AttachmentPutAction $action, AttachmentPutAction executingAction, PdfDocument document) {
        AttachmentPutAction attachmentPutAction;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Map<String, Attachment> attachments = this$0.fetchAttachments(executingAction);
        if (attachments.isEmpty()) {
            attachmentPutAction = AttachmentPutAction.copy$default(executingAction, null, null, null, null, null, null, false, null, null, CollectionsKt.plus((Collection)executingAction.getMessages(), (Object)Message.Companion.warn("The " + executingAction.getName() + " action does not have any attachments.", "attachments.missing", MapsKt.mapOf(Props.ACTION_NAME.pair(executingAction.getName())))), 511, null);
        } else {
            String key;
            Map.Entry element$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Map $this$filter$iv;
            Object object;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            boolean bl;
            Map.Entry it;
            void $this$filterTo$iv$iv2;
            Map $this$filter$iv2;
            Map<String, Attachment> map = attachments;
            boolean $i$f$filter = false;
            void var8_8 = $this$filter$iv2;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry;
                it = entry = iterator2.next();
                bl = false;
                if (!((Attachment)it.getValue()).getEmbedded()) continue;
                destination$iv$iv.put(entry.getKey(), entry.getValue());
            }
            $this$filter$iv2 = destination$iv$iv;
            boolean $i$f$map232 = false;
            $this$filterTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry entry : $this$mapTo$iv$iv2.entrySet()) {
                String string;
                it = entry;
                object = destination$iv$iv;
                bl = false;
                String key2 = (String)it.getKey();
                Attachment value = (Attachment)it.getValue();
                byte[] byArray = this$0.getLinkService().input(value.getLocation()).readAllBytes();
                String string2 = value.getDescription();
                if (string2 == null) {
                    string2 = value.getLocation().getUrl();
                }
                if ((string = value.getFileDisplay()) == null) {
                    string = value.getLocation().getUrl();
                }
                object.add(TuplesKt.to((Object)key2, (Object)PdfFileSpec.createEmbeddedFileSpec((PdfDocument)document, (byte[])byArray, (String)string2, (String)string, (PdfName)(value.getMimeType() != null ? new PdfName(value.getMimeType()) : null), null, (PdfName)(value.getAssociated() ? PdfName.AFRelationship : null))));
            }
            Map embedded = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            Map<String, Attachment> $i$f$map232 = attachments;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo2 = false;
            Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it2 = element$iv$iv = iterator3.next();
                boolean bl2 = false;
                if (!(!((Attachment)it2.getValue()).getEmbedded())) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo2 = false;
            Iterator iterator4 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator4.hasNext()) {
                Map.Entry item$iv$iv3;
                Map.Entry it2 = item$iv$iv3 = iterator4.next();
                object = destination$iv$iv3;
                boolean bl3 = false;
                String key3 = (String)it2.getKey();
                Attachment value = (Attachment)it2.getValue();
                object.add(TuplesKt.to((Object)key3, (Object)PdfFileSpec.createExternalFileSpec((PdfDocument)document, (String)value.getLocation().getUrl(), (PdfName)(value.getAssociated() ? PdfName.AFRelationship : null))));
            }
            Map external = MapsKt.toMap((Iterable)((List)destination$iv$iv3));
            Map $this$forEach$iv = embedded;
            boolean $i$f$forEach = false;
            Iterator iterator32 = $this$forEach$iv.entrySet().iterator();
            while (iterator32.hasNext()) {
                Map.Entry entry = element$iv = iterator32.next();
                boolean bl4 = false;
                key = (String)entry.getKey();
                PdfFileSpec value = (PdfFileSpec)entry.getValue();
                document.addFileAttachment(key, value);
            }
            $this$forEach$iv = external;
            $i$f$forEach = false;
            iterator32 = $this$forEach$iv.entrySet().iterator();
            while (iterator32.hasNext()) {
                Map.Entry entry = element$iv = iterator32.next();
                boolean bl5 = false;
                key = (String)entry.getKey();
                PdfFileSpec value = (PdfFileSpec)entry.getValue();
                document.addFileAttachment(key, value);
            }
            if ($action.getShowAttachments()) {
                document.getCatalog().setPageMode(PdfName.UseAttachments);
            }
            attachmentPutAction = executingAction;
        }
        return attachmentPutAction;
    }

    /*
     * WARNING - void declaration
     */
    private static final AttachmentPutAction finalize$lambda$17(AttachmentPutActionServiceImpl this$0, AttachmentPutAction executingAction) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Map<String, Attachment> $this$mapValues$iv = executingAction.getAttachments();
        boolean $i$f$mapValues = false;
        Map<String, Attachment> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Link location = ((Attachment)it.getValue()).getLocation();
            Attachment attachment = location instanceof ActionLink ? Attachment.copy$default((Attachment)it.getValue(), false, false, this$0.getActionLinkInitFinalizeService().finalize((ActionLink)location, executingAction), null, null, null, null, null, 251, null) : (Attachment)it.getValue();
            map3.put(k, attachment);
        }
        Map attachments = destination$iv$iv;
        Link attachmentActionSource = executingAction.getAttachmentActionSource() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().finalize((ActionLink)executingAction.getAttachmentActionSource(), executingAction) : executingAction.getAttachmentActionSource();
        return AttachmentPutAction.copy$default(executingAction, null, null, null, attachments, attachmentActionSource, null, false, null, null, null, 999, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001f\b\u0086\b\u0018\u00002\u00020\u0001Bc\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u0010\u0010&\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001dJj\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00c6\u0001\u00a2\u0006\u0002\u0010(J\u0013\u0010)\u001a\u00020\u00032\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020\u000eH\u00d6\u0001J\t\u0010,\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\f\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0015\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006-"}, d2={"Lorg/kuali/research/pdf/attachment/AttachmentPutActionServiceImpl$TempAttachment;", "", "embedded", "", "associated", "location", "Lorg/kuali/research/pdf/link/Link;", "fileDisplay", "", "description", "modDate", "Ljava/time/LocalDate;", "mimeType", "size", "", "<init>", "(ZZLorg/kuali/research/pdf/link/Link;Ljava/lang/String;Ljava/lang/String;Ljava/time/LocalDate;Ljava/lang/String;Ljava/lang/Integer;)V", "getEmbedded", "()Z", "getAssociated", "getLocation", "()Lorg/kuali/research/pdf/link/Link;", "getFileDisplay", "()Ljava/lang/String;", "getDescription", "getModDate", "()Ljava/time/LocalDate;", "getMimeType", "getSize", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(ZZLorg/kuali/research/pdf/link/Link;Ljava/lang/String;Ljava/lang/String;Ljava/time/LocalDate;Ljava/lang/String;Ljava/lang/Integer;)Lorg/kuali/research/pdf/attachment/AttachmentPutActionServiceImpl$TempAttachment;", "equals", "other", "hashCode", "toString", "pdf"})
    public static final class TempAttachment {
        private final boolean embedded;
        private final boolean associated;
        @Nullable
        private final Link location;
        @Nullable
        private final String fileDisplay;
        @Nullable
        private final String description;
        @Nullable
        private final LocalDate modDate;
        @Nullable
        private final String mimeType;
        @Nullable
        private final Integer size;

        public TempAttachment(boolean embedded, boolean associated, @Nullable Link location, @Nullable String fileDisplay, @Nullable String description, @Nullable LocalDate modDate, @Nullable String mimeType, @Nullable Integer size) {
            this.embedded = embedded;
            this.associated = associated;
            this.location = location;
            this.fileDisplay = fileDisplay;
            this.description = description;
            this.modDate = modDate;
            this.mimeType = mimeType;
            this.size = size;
        }

        public /* synthetic */ TempAttachment(boolean bl, boolean bl2, Link link, String string, String string2, LocalDate localDate, String string3, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = true;
            }
            if ((n2 & 2) != 0) {
                bl2 = true;
            }
            if ((n2 & 4) != 0) {
                link = null;
            }
            if ((n2 & 8) != 0) {
                string = null;
            }
            if ((n2 & 0x10) != 0) {
                string2 = null;
            }
            if ((n2 & 0x20) != 0) {
                localDate = null;
            }
            if ((n2 & 0x40) != 0) {
                string3 = null;
            }
            if ((n2 & 0x80) != 0) {
                n = null;
            }
            this(bl, bl2, link, string, string2, localDate, string3, n);
        }

        public final boolean getEmbedded() {
            return this.embedded;
        }

        public final boolean getAssociated() {
            return this.associated;
        }

        @Nullable
        public final Link getLocation() {
            return this.location;
        }

        @Nullable
        public final String getFileDisplay() {
            return this.fileDisplay;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        @Nullable
        public final LocalDate getModDate() {
            return this.modDate;
        }

        @Nullable
        public final String getMimeType() {
            return this.mimeType;
        }

        @Nullable
        public final Integer getSize() {
            return this.size;
        }

        public final boolean component1() {
            return this.embedded;
        }

        public final boolean component2() {
            return this.associated;
        }

        @Nullable
        public final Link component3() {
            return this.location;
        }

        @Nullable
        public final String component4() {
            return this.fileDisplay;
        }

        @Nullable
        public final String component5() {
            return this.description;
        }

        @Nullable
        public final LocalDate component6() {
            return this.modDate;
        }

        @Nullable
        public final String component7() {
            return this.mimeType;
        }

        @Nullable
        public final Integer component8() {
            return this.size;
        }

        @NotNull
        public final TempAttachment copy(boolean embedded, boolean associated, @Nullable Link location, @Nullable String fileDisplay, @Nullable String description, @Nullable LocalDate modDate, @Nullable String mimeType, @Nullable Integer size) {
            return new TempAttachment(embedded, associated, location, fileDisplay, description, modDate, mimeType, size);
        }

        public static /* synthetic */ TempAttachment copy$default(TempAttachment tempAttachment, boolean bl, boolean bl2, Link link, String string, String string2, LocalDate localDate, String string3, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = tempAttachment.embedded;
            }
            if ((n2 & 2) != 0) {
                bl2 = tempAttachment.associated;
            }
            if ((n2 & 4) != 0) {
                link = tempAttachment.location;
            }
            if ((n2 & 8) != 0) {
                string = tempAttachment.fileDisplay;
            }
            if ((n2 & 0x10) != 0) {
                string2 = tempAttachment.description;
            }
            if ((n2 & 0x20) != 0) {
                localDate = tempAttachment.modDate;
            }
            if ((n2 & 0x40) != 0) {
                string3 = tempAttachment.mimeType;
            }
            if ((n2 & 0x80) != 0) {
                n = tempAttachment.size;
            }
            return tempAttachment.copy(bl, bl2, link, string, string2, localDate, string3, n);
        }

        @NotNull
        public String toString() {
            return "TempAttachment(embedded=" + this.embedded + ", associated=" + this.associated + ", location=" + this.location + ", fileDisplay=" + this.fileDisplay + ", description=" + this.description + ", modDate=" + this.modDate + ", mimeType=" + this.mimeType + ", size=" + this.size + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.embedded);
            result = result * 31 + Boolean.hashCode(this.associated);
            result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
            result = result * 31 + (this.fileDisplay == null ? 0 : this.fileDisplay.hashCode());
            result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
            result = result * 31 + (this.modDate == null ? 0 : this.modDate.hashCode());
            result = result * 31 + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            result = result * 31 + (this.size == null ? 0 : ((Object)this.size).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TempAttachment)) {
                return false;
            }
            TempAttachment tempAttachment = (TempAttachment)other;
            if (this.embedded != tempAttachment.embedded) {
                return false;
            }
            if (this.associated != tempAttachment.associated) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.location, (Object)tempAttachment.location)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fileDisplay, (Object)tempAttachment.fileDisplay)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)tempAttachment.description)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.modDate, (Object)tempAttachment.modDate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mimeType, (Object)tempAttachment.mimeType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.size, (Object)tempAttachment.size);
        }

        public TempAttachment() {
            this(false, false, null, null, null, null, null, null, 255, null);
        }
    }
}

