/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.flatten;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.tool.xml.xtra.xfa.XFAFlattener;
import com.itextpdf.tool.xml.xtra.xfa.XFAFlattenerProperties;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.action.Action;
import org.kuali.research.pdf.action.ActionHelperService;
import org.kuali.research.pdf.action.ActionService;
import org.kuali.research.pdf.flatten.XfaFormFlattenAction;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkService;
import org.kuali.research.pdf.sys.model.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"xfa.flattening.supported"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001b\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/kuali/research/pdf/flatten/XfaFormFlattenActionServiceImpl;", "Lorg/kuali/research/pdf/action/ActionService;", "Lorg/kuali/research/pdf/flatten/XfaFormFlattenAction;", "Lorg/apache/logging/log4j/kotlin/Logging;", "actionHelperService", "Lorg/kuali/research/pdf/action/ActionHelperService;", "linkService", "Lorg/kuali/research/pdf/link/LinkService;", "<init>", "(Lorg/kuali/research/pdf/action/ActionHelperService;Lorg/kuali/research/pdf/link/LinkService;)V", "getActionHelperService", "()Lorg/kuali/research/pdf/action/ActionHelperService;", "getLinkService", "()Lorg/kuali/research/pdf/link/LinkService;", "init", "action", "exec", "finalize", "pdf"})
public class XfaFormFlattenActionServiceImpl
implements ActionService<XfaFormFlattenAction>,
Logging {
    @NotNull
    private final ActionHelperService actionHelperService;
    @NotNull
    private final LinkService linkService;

    public XfaFormFlattenActionServiceImpl(@Autowired @NotNull ActionHelperService actionHelperService, @Autowired @NotNull LinkService linkService) {
        Intrinsics.checkNotNullParameter((Object)actionHelperService, (String)"actionHelperService");
        Intrinsics.checkNotNullParameter((Object)linkService, (String)"linkService");
        this.actionHelperService = actionHelperService;
        this.linkService = linkService;
    }

    @NotNull
    public ActionHelperService getActionHelperService() {
        return this.actionHelperService;
    }

    @NotNull
    public LinkService getLinkService() {
        return this.linkService;
    }

    @Override
    @NotNull
    public XfaFormFlattenAction init(@NotNull XfaFormFlattenAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (XfaFormFlattenAction)this.getActionHelperService().initOneToOne((Action)action, XfaFormFlattenActionServiceImpl::init$lambda$0);
    }

    @Override
    @NotNull
    public XfaFormFlattenAction exec(@NotNull XfaFormFlattenAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (XfaFormFlattenAction)this.getActionHelperService().execOneToUnit((Action)action, (arg_0, arg_1) -> XfaFormFlattenActionServiceImpl.exec$lambda$1(this, arg_0, arg_1));
    }

    @Override
    @NotNull
    public XfaFormFlattenAction finalize(@NotNull XfaFormFlattenAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (XfaFormFlattenAction)this.getActionHelperService().finalizeOneToOne((Action)action, XfaFormFlattenActionServiceImpl::finalize$lambda$2);
    }

    @Override
    @NotNull
    public XfaFormFlattenAction preValidate(@NotNull XfaFormFlattenAction action) {
        return (XfaFormFlattenAction)ActionService.DefaultImpls.preValidate(this, (Action)action);
    }

    @Override
    @NotNull
    public XfaFormFlattenAction postValidate(@NotNull XfaFormFlattenAction action) {
        return (XfaFormFlattenAction)ActionService.DefaultImpls.postValidate(this, (Action)action);
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }

    private static final XfaFormFlattenAction init$lambda$0(XfaFormFlattenAction executingAction) {
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        return executingAction;
    }

    private static final XfaFormFlattenAction exec$lambda$1(XfaFormFlattenActionServiceImpl this$0, XfaFormFlattenAction executingAction, PdfDocument document) {
        XfaFormFlattenAction xfaFormFlattenAction;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        PdfAcroForm form = PdfAcroForm.getAcroForm((PdfDocument)document, (boolean)false);
        if (form == null) {
            xfaFormFlattenAction = XfaFormFlattenAction.copy$default(executingAction, null, null, null, null, null, null, CollectionsKt.plus((Collection)executingAction.getMessages(), (Object)Message.Companion.warn$default(Message.Companion, "The source pdf does not have an acroform.", "source.acroform.not.found", null, 4, null)), 63, null);
        } else if (!form.hasXfaForm()) {
            xfaFormFlattenAction = XfaFormFlattenAction.copy$default(executingAction, null, null, null, null, null, null, CollectionsKt.plus((Collection)executingAction.getMessages(), (Object)Message.Companion.warn$default(Message.Companion, "The source pdf does not have an xfaform.", "source.xfaform.not.found", null, 4, null)), 63, null);
        } else {
            LinkService linkService = this$0.getLinkService();
            Link link = executingAction.getTarget();
            String string = executingAction.getJobId();
            Intrinsics.checkNotNull((Object)string);
            String string2 = executingAction.getActionId();
            Intrinsics.checkNotNull((Object)string2);
            Link resolvedTarget = linkService.newIfNull(link, string, string2, "0");
            XFAFlattener flattener = new XFAFlattener();
            XFAFlattenerProperties flattenerProperties = new XFAFlattenerProperties();
            flattenerProperties.setSkipFormStateChecksumCheck(true);
            flattener.setFlattenerProperties(flattenerProperties);
            flattener.flatten(this$0.getLinkService().input(executingAction.getSource()), this$0.getLinkService().output(resolvedTarget));
            xfaFormFlattenAction = XfaFormFlattenAction.copy$default(executingAction, null, null, null, resolvedTarget, null, null, null, 119, null);
        }
        return xfaFormFlattenAction;
    }

    private static final XfaFormFlattenAction finalize$lambda$2(XfaFormFlattenAction executingAction) {
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        return executingAction;
    }
}

