/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.health.itext;

import com.itextpdf.licensing.base.LicenseKey;
import com.itextpdf.licensing.base.info.LicenseInfo;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.health.HealthService;
import org.kuali.research.pdf.health.Service;
import org.kuali.research.pdf.health.Status;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@org.springframework.stereotype.Service
@ConditionalOnProperty(value={"xfa.flattening.supported"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0012\u00a8\u0006\r"}, d2={"Lorg/kuali/research/pdf/health/itext/HealthServiceItextImpl;", "Lorg/kuali/research/pdf/health/HealthService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "<init>", "()V", "getStatus", "Lkotlin/Pair;", "", "Lorg/kuali/research/pdf/health/Service;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "isConnected", "", "pdf"})
public class HealthServiceItextImpl
implements HealthService,
Logging {
    @Override
    @NotNull
    public Pair<String, Service> getStatus(@NotNull HttpServletRequest request) {
        Service service;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.isConnected()) {
            List list = LicenseKey.getLoadedLicensesInfo();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLoadedLicensesInfo(...)");
            service = new Service(Status.OK, CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, HealthServiceItextImpl::getStatus$lambda$0, (int)31, null));
        } else {
            service = new Service(Status.ERROR, "itext Licenses are not valid.");
        }
        Service service2 = service;
        return new Pair((Object)"itext License", (Object)service2);
    }

    private boolean isConnected() {
        boolean bl;
        try {
            Collection collection = LicenseKey.getLoadedLicensesInfo();
            bl = !(collection == null || collection.isEmpty());
        }
        catch (Throwable e) {
            KotlinLogger kotlinLogger = this.getLogger();
            String string = e.getMessage();
            if (string == null) {
                string = "unknown";
            }
            kotlinLogger.error((CharSequence)string, e);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }

    private static final CharSequence getStatus$lambda$0(LicenseInfo it) {
        return "License for " + it.getProduct() + " is valid";
    }
}

