/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.job.mongo;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.pdf.job.Job;
import org.kuali.research.pdf.job.JobDao;
import org.kuali.research.pdf.job.mongo.JobRepositoryMongo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(name={"mongo.enabled"})
@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/kuali/research/pdf/job/mongo/JobDaoMongoImpl;", "Lorg/kuali/research/pdf/job/JobDao;", "jobRepositoryMongo", "Lorg/kuali/research/pdf/job/mongo/JobRepositoryMongo;", "<init>", "(Lorg/kuali/research/pdf/job/mongo/JobRepositoryMongo;)V", "getJobRepositoryMongo", "()Lorg/kuali/research/pdf/job/mongo/JobRepositoryMongo;", "findById", "Lorg/kuali/research/pdf/job/Job;", "id", "", "findAll", "", "save", "", "job", "pdf"})
public class JobDaoMongoImpl
implements JobDao {
    @NotNull
    private final JobRepositoryMongo jobRepositoryMongo;

    public JobDaoMongoImpl(@Autowired @NotNull JobRepositoryMongo jobRepositoryMongo) {
        Intrinsics.checkNotNullParameter((Object)jobRepositoryMongo, (String)"jobRepositoryMongo");
        this.jobRepositoryMongo = jobRepositoryMongo;
    }

    @NotNull
    public JobRepositoryMongo getJobRepositoryMongo() {
        return this.jobRepositoryMongo;
    }

    @Override
    @Nullable
    public Job findById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getJobRepositoryMongo().findById(id).orElse(null);
    }

    @Override
    @NotNull
    public List<Job> findAll() {
        List list = this.getJobRepositoryMongo().findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAll(...)");
        return CollectionsKt.toList((Iterable)list);
    }

    @Override
    public void save(@NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        this.getJobRepositoryMongo().save(job);
    }
}

