/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.link;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.link.ActionLink;
import org.kuali.research.pdf.link.ActionLinkService;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.sys.model.PdfException;
import org.owasp.fileio.SafeFile;
import org.owasp.fileio.ValidationException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0012J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/kuali/research/pdf/link/ActionLinkServiceImpl;", "Lorg/kuali/research/pdf/link/ActionLinkService;", "tempDirectory", "Lorg/owasp/fileio/SafeFile;", "<init>", "(Lorg/owasp/fileio/SafeFile;)V", "getTempDirectory", "()Lorg/owasp/fileio/SafeFile;", "input", "Ljava/io/InputStream;", "link", "Lorg/kuali/research/pdf/link/ActionLink;", "output", "Ljava/io/OutputStream;", "toFile", "toParentFile", "expand", "", "Lorg/kuali/research/pdf/link/Link;", "makeSafe", "", "fileOrFolder", "pdf"})
@SourceDebugExtension(value={"SMAP\nActionLinkServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionLinkServiceImpl.kt\norg/kuali/research/pdf/link/ActionLinkServiceImpl\n+ 2 LinkModel.kt\norg/kuali/research/pdf/link/ActionLink\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n189#2,2:100\n183#2,2:102\n194#2:104\n189#2,2:105\n183#2,2:110\n11228#3:107\n11563#3,2:108\n11565#3:112\n1#4:113\n*S KotlinDebug\n*F\n+ 1 ActionLinkServiceImpl.kt\norg/kuali/research/pdf/link/ActionLinkServiceImpl\n*L\n34#1:100,2\n47#1:102,2\n63#1:104\n63#1:105,2\n67#1:110,2\n67#1:107\n67#1:108,2\n67#1:112\n*E\n"})
public class ActionLinkServiceImpl
implements ActionLinkService {
    @NotNull
    private final SafeFile tempDirectory;

    public ActionLinkServiceImpl(@Value(value="${temp.storage.dir}") @NotNull SafeFile tempDirectory) {
        Intrinsics.checkNotNullParameter((Object)tempDirectory, (String)"tempDirectory");
        this.tempDirectory = tempDirectory;
    }

    @NotNull
    public SafeFile getTempDirectory() {
        return this.tempDirectory;
    }

    @Override
    @NotNull
    public InputStream input(@NotNull ActionLink link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        return new FileInputStream((File)this.toFile(link));
    }

    @Override
    @NotNull
    public OutputStream output(@NotNull ActionLink link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        return new FileOutputStream((File)this.toFile(link));
    }

    @Override
    @NotNull
    public SafeFile toFile(@NotNull ActionLink link) {
        SafeFile safeFile;
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        try {
            ActionLink this_$iv = link;
            boolean $i$f$getFileNumberPattern = false;
            String path$iv = StringsKt.removePrefix((String)this_$iv.getUrl(), (CharSequence)(this_$iv.protocol() + "://"));
            safeFile = new SafeFile((File)this.toParentFile(link), this.makeSafe(StringsKt.substringAfterLast$default((String)path$iv, (String)"/", null, (int)2, null)));
        }
        catch (ValidationException e) {
            throw new PdfException("invalid.action.link", MapsKt.emptyMap(), "Invalid action link with url: " + link.getUrl(), e);
        }
        return safeFile;
    }

    /*
     * WARNING - void declaration
     */
    private SafeFile toParentFile(ActionLink link) {
        void var2_6;
        try {
            ActionLink this_$iv = link;
            boolean $i$f$getActionId = false;
            String path$iv = StringsKt.removePrefix((String)this_$iv.getUrl(), (CharSequence)(this_$iv.protocol() + "://"));
            SafeFile targetFolder = new SafeFile((File)new SafeFile((File)this.getTempDirectory(), this.makeSafe(link.getJobId())), this.makeSafe(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)path$iv, (String)"/", null, (int)2, null), (String)"/", null, (int)2, null)));
            if (!targetFolder.exists()) {
                targetFolder.mkdirs();
            }
        }
        catch (ValidationException e) {
            throw new PdfException("invalid.action.link", MapsKt.emptyMap(), "Invalid action link with url: " + link.getUrl(), e);
        }
        return var2_6;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Link> expand(@NotNull ActionLink link) {
        List list;
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Object[] this_$iv = link;
        boolean $i$f$getNeedsExpanding = false;
        Object[] this_$iv$iv = this_$iv;
        boolean $i$f$getFileNumberPattern = false;
        String path$iv$iv = StringsKt.removePrefix((String)this_$iv$iv.getUrl(), (CharSequence)(this_$iv$iv.protocol() + "://"));
        if (Intrinsics.areEqual((Object)StringsKt.substringAfterLast$default((String)path$iv$iv, (String)"/", null, (int)2, null), (Object)"*")) {
            void $this$mapTo$iv$iv;
            File[] fileArray = this.toParentFile((ActionLink)link).listFiles(ActionLinkServiceImpl::expand$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
            Object[] $this$map$iv = fileArray;
            boolean $i$f$map = false;
            this_$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object[] this_$iv2 = link;
                boolean $i$f$getActionId = false;
                String path$iv = StringsKt.removePrefix((String)this_$iv2.getUrl(), (CharSequence)(this_$iv2.protocol() + "://"));
                collection.add(new ActionLink("action://" + link.getJobId() + "/" + StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)path$iv, (String)"/", null, (int)2, null), (String)"/", null, (int)2, null) + "/" + it.getName()));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.listOf((Object)link);
        }
        return list;
    }

    private String makeSafe(String fileOrFolder) {
        int pos;
        if (!(!StringsKt.isBlank((CharSequence)fileOrFolder))) {
            boolean $i$a$-require-ActionLinkServiceImpl$makeSafe$22 = false;
            String $i$a$-require-ActionLinkServiceImpl$makeSafe$22 = "fileOrFolder cannot be blank";
            throw new IllegalArgumentException($i$a$-require-ActionLinkServiceImpl$makeSafe$22.toString());
        }
        int unixSep = StringsKt.lastIndexOf$default((CharSequence)fileOrFolder, (char)'/', (int)0, (boolean)false, (int)6, null);
        int winSep = StringsKt.lastIndexOf$default((CharSequence)fileOrFolder, (char)'\\', (int)0, (boolean)false, (int)6, null);
        int n = pos = winSep > unixSep ? winSep : unixSep;
        if (pos != -1) {
            String string = fileOrFolder.substring(pos + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String safeFileOrFolder = string;
            CharSequence charSequence = safeFileOrFolder;
            if (StringsKt.isBlank((CharSequence)charSequence)) {
                boolean bl = false;
                throw new IllegalArgumentException("fileOrFolder: " + fileOrFolder + " is invalid");
            }
            return (String)charSequence;
        }
        return fileOrFolder;
    }

    private static final boolean expand$lambda$0(File f) {
        return f.isFile();
    }
}

