/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.link;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.link.LinkTypeIdResolver;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="url", visible=true)
@JsonTypeIdResolver(value=LinkTypeIdResolver.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH&J\b\u0010\t\u001a\u00020\nH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000b"}, d2={"Lorg/kuali/research/pdf/link/Link;", "", "url", "", "getUrl", "()Ljava/lang/String;", "protocol", "acceptableProtocols", "", "validate", "", "pdf"})
public interface Link {
    @NotNull
    public String getUrl();

    @NotNull
    public String protocol();

    @NotNull
    public List<String> acceptableProtocols();

    public void validate();

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static String protocol(@NotNull Link $this) {
            String string;
            if (StringsKt.startsWith$default((String)$this.getUrl(), (String)"action:", (boolean)false, (int)2, null)) {
                string = "action";
            } else if (StringsKt.startsWith$default((String)$this.getUrl(), (String)"classpath:", (boolean)false, (int)2, null)) {
                string = "classpath";
            } else {
                String string2 = new URI($this.getUrl()).toURL().getProtocol();
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
            }
            return string;
        }

        public static void validate(@NotNull Link $this) {
            String protocol = $this.protocol();
            if (!$this.acceptableProtocols().contains(protocol)) {
                boolean bl = false;
                String string = "Invalid protocol " + protocol + " for link type " + Reflection.getOrCreateKotlinClass($this.getClass()).getSimpleName();
                throw new IllegalStateException(string.toString());
            }
        }
    }
}

