/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.pdf.mapper.FunctionProviderBase;
import org.kuali.research.pdf.mapper.MapperFunction;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/kuali/research/pdf/mapper/AddressFunctions;", "Lorg/kuali/research/pdf/mapper/FunctionProviderBase;", "<init>", "()V", "Companion", "pdf"})
public class AddressFunctions
extends FunctionProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public AddressFunctions() {
        super("Addresses");
    }

    @JvmStatic
    @MapperFunction(registeredName="formatState", description="ex: #formatState(\"#stateField\") = \"AZ: Arizona\"  Format a state according to the StateCodeDataType format in the global library V2.  The state value is expected to be a map with code and description as follows: state[\"code\"] = 'AZ', state[\"description\"] = 'ARIZONA'.")
    @NotNull
    public static final String formatState(@NotNull Map<String, String> state) {
        return Companion.formatState(state);
    }

    @JvmStatic
    @MapperFunction(registeredName="formatCountry", description="ex: #formatCountry(\"#countryField\") = \"USA: UNITED STATES\"  Format a country according to the CountryCodeDataType format in the global library V2.  The country value is expected to be a map with code and description as follows: country[\"code\"] = 'USA', country[\"description\"] = 'UNITED STATES'.")
    @NotNull
    public static final String formatCountry(@NotNull Map<String, String> country) {
        return Companion.formatCountry(country);
    }

    @JvmStatic
    @MapperFunction(registeredName="formatAddress", description="ex: #formatAddress(#addressable.object, false) = \"1234 Street, city state postalCode\"  Format an object that contains the following fields: addressLine1, addressLine2, addressLine3, city, state, postalCode.  The second argument determines whether the address will span multiple lines.")
    @NotNull
    public static final String formatAddress(@Nullable Map<String, ?> addressObject, boolean multiline) {
        return Companion.formatAddress(addressObject, multiline);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007H\u0007J\u001c\u0010\b\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007H\u0007J$\u0010\n\u001a\u00020\u00052\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/kuali/research/pdf/mapper/AddressFunctions$Companion;", "", "<init>", "()V", "formatState", "", "state", "", "formatCountry", "country", "formatAddress", "addressObject", "multiline", "", "pdf"})
    @SourceDebugExtension(value={"SMAP\nAddressFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddressFunctions.kt\norg/kuali/research/pdf/mapper/AddressFunctions$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1#2:79\n774#3:80\n865#3,2:81\n*S KotlinDebug\n*F\n+ 1 AddressFunctions.kt\norg/kuali/research/pdf/mapper/AddressFunctions$Companion\n*L\n68#1:80\n68#1:81,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @MapperFunction(registeredName="formatState", description="ex: #formatState(\"#stateField\") = \"AZ: Arizona\"  Format a state according to the StateCodeDataType format in the global library V2.  The state value is expected to be a map with code and description as follows: state[\"code\"] = 'AZ', state[\"description\"] = 'ARIZONA'.")
        @NotNull
        public final String formatState(@NotNull Map<String, String> state) {
            String string;
            String string2;
            Intrinsics.checkNotNullParameter(state, (String)"state");
            String string3 = state.get("code");
            if (string3 == null) return "";
            String code = string3;
            boolean bl = false;
            String string4 = state.get("description");
            if (string4 == null) return "";
            String description = string4;
            boolean bl2 = false;
            Pair pair = TuplesKt.to((Object)code, (Object)description);
            Pair pair2 = pair;
            if (pair2 == null) return "";
            Pair pair3 = pair2;
            boolean bl3 = false;
            String code2 = (String)pair3.component1();
            String description2 = (String)pair3.component2();
            String string5 = code2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string6 = string5.toUpperCase(locale);
            String string7 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUpperCase(...)");
            string5 = description2;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string8 = string5.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
            string5 = string8;
            if (((CharSequence)string5).length() > 0) {
                String string9;
                void it;
                char c = string5.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                String string10 = string7;
                boolean bl4 = false;
                if (Character.isLowerCase((char)it)) {
                    Locale locale3 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"getDefault(...)");
                    string9 = CharsKt.titlecase((char)it, (Locale)locale3);
                } else {
                    string9 = String.valueOf((char)it);
                }
                CharSequence charSequence = string9;
                string7 = string10;
                StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
                String string11 = string5;
                int n = 1;
                String string12 = string11.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"substring(...)");
                string2 = stringBuilder2.append(string12).toString();
            } else {
                string2 = string5;
            }
            if ((string = string7 + ": " + string2) == null) return "";
            String string13 = string;
            return string13;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @MapperFunction(registeredName="formatCountry", description="ex: #formatCountry(\"#countryField\") = \"USA: UNITED STATES\"  Format a country according to the CountryCodeDataType format in the global library V2.  The country value is expected to be a map with code and description as follows: country[\"code\"] = 'USA', country[\"description\"] = 'UNITED STATES'.")
        @NotNull
        public final String formatCountry(@NotNull Map<String, String> country) {
            Intrinsics.checkNotNullParameter(country, (String)"country");
            String string = country.get("code");
            if (string == null) return "";
            String code = string;
            boolean bl = false;
            String string2 = country.get("description");
            if (string2 == null) return "";
            String description = string2;
            boolean bl2 = false;
            Pair pair = TuplesKt.to((Object)code, (Object)description);
            Pair pair2 = pair;
            if (pair2 == null) return "";
            Pair pair3 = pair2;
            boolean bl3 = false;
            String code2 = (String)pair3.component1();
            String description2 = (String)pair3.component2();
            String string3 = code2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
            string3 = description2;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string5 = string3.toUpperCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            String string6 = string4 + ": " + string5;
            if (string6 == null) return "";
            String string7 = string6;
            return string7;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @MapperFunction(registeredName="formatAddress", description="ex: #formatAddress(#addressable.object, false) = \"1234 Street, city state postalCode\"  Format an object that contains the following fields: addressLine1, addressLine2, addressLine3, city, state, postalCode.  The second argument determines whether the address will span multiple lines.")
        @NotNull
        public final String formatAddress(@Nullable Map<String, ?> addressObject, boolean multiline) {
            Map<String, ?> map;
            block5: {
                block4: {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    map = addressObject;
                    if (map == null) break block4;
                    Map<String, ?> it = map;
                    boolean bl = false;
                    String separator = multiline ? "\n" : ", ";
                    Object[] objectArray = new Object[]{it.get("addressLine1"), it.get("addressLine2"), it.get("addressLine3")};
                    objectArray = CollectionsKt.listOfNotNull((Object[])objectArray);
                    boolean $i$f$filter = false;
                    void var8_8 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    Iterator iterator2 = $this$filterTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv$iv;
                        Object s = element$iv$iv = iterator2.next();
                        boolean bl2 = false;
                        Intrinsics.checkNotNull(s, (String)"null cannot be cast to non-null type kotlin.String");
                        boolean bl3 = !StringsKt.isBlank((CharSequence)((String)s));
                        if (!bl3) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    objectArray = new Object[]{it.get("city"), it.get("state"), it.get("postalCode")};
                    String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)separator, null, (CharSequence)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)" ", (CharSequence)separator, null, (int)0, null, null, (int)60, null), (int)0, null, null, (int)58, null);
                    map = string;
                    if (string != null) break block5;
                }
                map = "";
            }
            return map;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

