/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.mapper;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.pdf.mapper.FunctionProviderBase;
import org.kuali.research.pdf.mapper.MapperFunction;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/kuali/research/pdf/mapper/DateFunctions;", "Lorg/kuali/research/pdf/mapper/FunctionProviderBase;", "<init>", "()V", "Companion", "pdf"})
public class DateFunctions
extends FunctionProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Function1<String, LocalDateTime>> parsableFormats;

    public DateFunctions() {
        super("Dates");
    }

    @JvmStatic
    @MapperFunction(registeredName="parseDate", description="ex: #parseDate(\"2019-01-01\", \"yyyy-MM-dd\") = [LocalDateTime for 1/1/19]  Parse a date string based on a supplied pattern.  Patterns are those used by the DateTimeFormatter class in Java 11: https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/time/format/DateTimeFormatter.html.  Use this method when #formatDate cannot parse the supplied date format.")
    @NotNull
    public static final LocalDateTime parseDate(@NotNull String date, @NotNull String pattern) {
        return Companion.parseDate(date, pattern);
    }

    @JvmStatic
    @MapperFunction(registeredName="parseAndFormatDate", description="ex: #parseAndFormatDate(1563071415000, \"yyyy-MM-dd\") = \"2019-07-13\"  Format a date with a given DateTimeFormatter pattern.  Allowed inputs include Long timestamps (millis from epoch), date strings in ISO_LOCAL_DATE_TIME format, and previously parsed LocalDateTime objects returned from the #parseDate function.  For pattern information, see https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/time/format/DateTimeFormatter.html")
    @NotNull
    public static final String parseAndFormatDate(@Nullable Object date, @NotNull String pattern) {
        return Companion.parseAndFormatDate(date, pattern);
    }

    @JvmStatic
    @MapperFunction(registeredName="formatDate", description="ex: #formatDate(#parseDate(\"2019-01-01\", \"yyyy-MM-dd\"), \"m/d/yy\") = \"7/13/19\"  Format a previously parsed date using #parseDate with a given DateTimeFormatter pattern.  For pattern information, see https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/time/format/DateTimeFormatter.html")
    @NotNull
    public static final String formatDate(@NotNull LocalDateTime date, @NotNull String pattern) {
        return Companion.formatDate(date, pattern);
    }

    @JvmStatic
    @MapperFunction(registeredName="date", description="ex: #date(1563071415000) = \"2019-07-13\"  Return the date of a given value in \"yyyy-MM-dd\" format.  Allowed inputs include Long timestamps (millis from epoch), date strings in ISO_LOCAL_DATE_TIME format (), and previously parsed LocalDateTime objects returned from the #parseDate function.")
    @NotNull
    public static final String date(@NotNull Object date) {
        return Companion.date(date);
    }

    @JvmStatic
    @MapperFunction(registeredName="month", description="ex: #month(\"2019-07-13T20:30:15\") = \"7\"  Return the month of a given date (M).  Allowed inputs include Long timestamps (millis from epoch), date strings in ISO_LOCAL_DATE_TIME format (), and previously parsed LocalDateTime objects returned from the #parseDate function.")
    @NotNull
    public static final String month(@NotNull Object date) {
        return Companion.month(date);
    }

    @JvmStatic
    @MapperFunction(registeredName="day", description="ex: #day(\"2019-07-13T20:30:15\") = \"13\"  Return the day of the month of a given date (d).  Allowed inputs include Long timestamps (millis from epoch), date strings in ISO_LOCAL_DATE_TIME format (), and previously parsed LocalDateTime objects returned from the #parseDate function.")
    @NotNull
    public static final String day(@NotNull Object date) {
        return Companion.day(date);
    }

    @JvmStatic
    @MapperFunction(registeredName="year", description="ex: #year(\"2019-07-13T20:30:15\") = \"2019\"  Return the 4 digit year of a given date (yyyy).  Allowed inputs include Long timestamps (millis from epoch), date strings in ISO_LOCAL_DATE_TIME format (), and previously parsed LocalDateTime objects returned from the #parseDate function.")
    @NotNull
    public static final String year(@NotNull Object date) {
        return Companion.year(date);
    }

    @JvmStatic
    @MapperFunction(registeredName="year2", description="ex: #year2(\"2019-07-13T20:30:15\") = \"19\"  Return the two-digit year of a given date (yy).  Allowed inputs include Long timestamps (millis from epoch), date strings in ISO_LOCAL_DATE_TIME format (), and previously parsed LocalDateTime objects returned from the #parseDate function.")
    @NotNull
    public static final String year2(@NotNull Object date) {
        return Companion.year2(date);
    }

    static {
        Object[] objectArray = new Function1[6];
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_ZONED_DATE_TIME;
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ISO_ZONED_DATE_TIME");
        objectArray[0] = DateFunctions.Companion.safeParserGenerator(dateTimeFormatter);
        DateTimeFormatter dateTimeFormatter2 = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter2, (String)"ISO_LOCAL_DATE_TIME");
        objectArray[1] = DateFunctions.Companion.safeParserGenerator(dateTimeFormatter2);
        DateTimeFormatter dateTimeFormatter3 = DateTimeFormatter.ISO_LOCAL_DATE;
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter3, (String)"ISO_LOCAL_DATE");
        objectArray[2] = DateFunctions.Companion.safeParserGenerator(dateTimeFormatter3);
        DateTimeFormatter dateTimeFormatter4 = DateTimeFormatter.ISO_DATE_TIME;
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter4, (String)"ISO_DATE_TIME");
        objectArray[3] = DateFunctions.Companion.safeParserGenerator(dateTimeFormatter4);
        DateTimeFormatter dateTimeFormatter5 = DateTimeFormatter.ISO_DATE;
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter5, (String)"ISO_DATE");
        objectArray[4] = DateFunctions.Companion.safeParserGenerator(dateTimeFormatter5);
        DateTimeFormatter dateTimeFormatter6 = DateTimeFormatter.RFC_1123_DATE_TIME;
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter6, (String)"RFC_1123_DATE_TIME");
        objectArray[5] = DateFunctions.Companion.safeParserGenerator(dateTimeFormatter6);
        parsableFormats = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0001H\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u001e\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0007J\u001a\u0010\u0011\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0007H\u0007J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0001H\u0007J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0001H\u0007J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0001H\u0007J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0001H\u0007J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0001H\u0007R\"\u0010\u0004\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/kuali/research/pdf/mapper/DateFunctions$Companion;", "", "<init>", "()V", "parsableFormats", "", "Lkotlin/Function1;", "", "Ljava/time/LocalDateTime;", "parseDate", "date", "parseDateString", "dateString", "safeParserGenerator", "formatter", "Ljava/time/format/DateTimeFormatter;", "pattern", "parseAndFormatDate", "formatDate", "month", "day", "year", "year2", "pdf"})
    @SourceDebugExtension(value={"SMAP\nDateFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateFunctions.kt\norg/kuali/research/pdf/mapper/DateFunctions$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n295#2,2:162\n1#3:164\n*S KotlinDebug\n*F\n+ 1 DateFunctions.kt\norg/kuali/research/pdf/mapper/DateFunctions$Companion\n*L\n53#1:162,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final LocalDateTime parseDate(Object date) {
            LocalDateTime localDateTime;
            Object object = date;
            if (object instanceof Long) {
                LocalDateTime localDateTime2 = LocalDateTime.ofEpochSecond(((Number)date).longValue() / (long)1000, 0, ZoneOffset.UTC);
                localDateTime = localDateTime2;
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"ofEpochSecond(...)");
            } else if (object instanceof String) {
                localDateTime = this.parseDateString((String)date);
            } else if (object instanceof LocalDateTime) {
                localDateTime = (LocalDateTime)date;
            } else {
                throw new IllegalArgumentException("Unable to parse " + date);
            }
            return localDateTime;
        }

        private final LocalDateTime parseDateString(String dateString) {
            Object object;
            block5: {
                block6: {
                    Object v3;
                    block3: {
                        block4: {
                            Object object2 = dateString;
                            Locale locale = Locale.getDefault();
                            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                            String string = ((String)object2).toLowerCase(locale);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                            if (!Intrinsics.areEqual((Object)string, (Object)"now")) break block4;
                            object2 = LocalDateTime.now();
                            Intrinsics.checkNotNull((Object)object2);
                            object = object2;
                            break block5;
                        }
                        Iterable $this$firstOrNull$iv = parsableFormats;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Function1 it = (Function1)element$iv;
                            boolean bl = false;
                            if (!(it.invoke((Object)dateString) != null)) continue;
                            v3 = element$iv;
                            break block3;
                        }
                        v3 = null;
                    }
                    if ((object = (Function1)v3) == null) break block6;
                    Object it = object;
                    boolean bl = false;
                    Object object3 = it.invoke((Object)dateString);
                    Intrinsics.checkNotNull((Object)object3);
                    LocalDateTime localDateTime = (LocalDateTime)object3;
                    object = localDateTime;
                    if (localDateTime != null) break block5;
                }
                throw new DateTimeParseException("Unrecognized date format", dateString, 0);
            }
            return object;
        }

        private final Function1<String, LocalDateTime> safeParserGenerator(DateTimeFormatter formatter) {
            return arg_0 -> Companion.safeParserGenerator$lambda$2(formatter, arg_0);
        }

        @JvmStatic
        @MapperFunction(registeredName="parseDate", description="ex: #parseDate(\"2019-01-01\", \"yyyy-MM-dd\") = [LocalDateTime for 1/1/19]  Parse a date string based on a supplied pattern.  Patterns are those used by the DateTimeFormatter class in Java 11: https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/time/format/DateTimeFormatter.html.  Use this method when #formatDate cannot parse the supplied date format.")
        @NotNull
        public final LocalDateTime parseDate(@NotNull String date, @NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            LocalDateTime localDateTime = LocalDateTime.parse(date, DateTimeFormatter.ofPattern(pattern));
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"parse(...)");
            return localDateTime;
        }

        @JvmStatic
        @MapperFunction(registeredName="parseAndFormatDate", description="ex: #parseAndFormatDate(1563071415000, \"yyyy-MM-dd\") = \"2019-07-13\"  Format a date with a given DateTimeFormatter pattern.  Allowed inputs include Long timestamps (millis from epoch), date strings in ISO_LOCAL_DATE_TIME format, and previously parsed LocalDateTime objects returned from the #parseDate function.  For pattern information, see https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/time/format/DateTimeFormatter.html")
        @NotNull
        public final String parseAndFormatDate(@Nullable Object date, @NotNull String pattern) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
                    object = date;
                    if (object == null) break block2;
                    Object it = object;
                    boolean bl = false;
                    String string = Companion.parseDate(it).format(DateTimeFormatter.ofPattern(pattern));
                    object = string;
                    if (string != null) break block3;
                }
                object = "";
            }
            return object;
        }

        @JvmStatic
        @MapperFunction(registeredName="formatDate", description="ex: #formatDate(#parseDate(\"2019-01-01\", \"yyyy-MM-dd\"), \"m/d/yy\") = \"7/13/19\"  Format a previously parsed date using #parseDate with a given DateTimeFormatter pattern.  For pattern information, see https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/time/format/DateTimeFormatter.html")
        @NotNull
        public final String formatDate(@NotNull LocalDateTime date, @NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            String string = date.format(DateTimeFormatter.ofPattern(pattern));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        @JvmStatic
        @MapperFunction(registeredName="date", description="ex: #date(1563071415000) = \"2019-07-13\"  Return the date of a given value in \"yyyy-MM-dd\" format.  Allowed inputs include Long timestamps (millis from epoch), date strings in ISO_LOCAL_DATE_TIME format (), and previously parsed LocalDateTime objects returned from the #parseDate function.")
        @NotNull
        public final String date(@NotNull Object date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            String string = this.parseDate(date).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        @JvmStatic
        @MapperFunction(registeredName="month", description="ex: #month(\"2019-07-13T20:30:15\") = \"7\"  Return the month of a given date (M).  Allowed inputs include Long timestamps (millis from epoch), date strings in ISO_LOCAL_DATE_TIME format (), and previously parsed LocalDateTime objects returned from the #parseDate function.")
        @NotNull
        public final String month(@NotNull Object date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            String string = this.parseDate(date).format(DateTimeFormatter.ofPattern("M"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        @JvmStatic
        @MapperFunction(registeredName="day", description="ex: #day(\"2019-07-13T20:30:15\") = \"13\"  Return the day of the month of a given date (d).  Allowed inputs include Long timestamps (millis from epoch), date strings in ISO_LOCAL_DATE_TIME format (), and previously parsed LocalDateTime objects returned from the #parseDate function.")
        @NotNull
        public final String day(@NotNull Object date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            String string = this.parseDate(date).format(DateTimeFormatter.ofPattern("d"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        @JvmStatic
        @MapperFunction(registeredName="year", description="ex: #year(\"2019-07-13T20:30:15\") = \"2019\"  Return the 4 digit year of a given date (yyyy).  Allowed inputs include Long timestamps (millis from epoch), date strings in ISO_LOCAL_DATE_TIME format (), and previously parsed LocalDateTime objects returned from the #parseDate function.")
        @NotNull
        public final String year(@NotNull Object date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            String string = this.parseDate(date).format(DateTimeFormatter.ofPattern("yyyy"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        @JvmStatic
        @MapperFunction(registeredName="year2", description="ex: #year2(\"2019-07-13T20:30:15\") = \"19\"  Return the two-digit year of a given date (yy).  Allowed inputs include Long timestamps (millis from epoch), date strings in ISO_LOCAL_DATE_TIME format (), and previously parsed LocalDateTime objects returned from the #parseDate function.")
        @NotNull
        public final String year2(@NotNull Object date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            String string = this.parseDate(date).format(DateTimeFormatter.ofPattern("yy"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        private static final LocalDateTime safeParserGenerator$lambda$2(DateTimeFormatter $formatter, String dateString) {
            LocalDateTime localDateTime;
            Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
            try {
                localDateTime = LocalDateTime.parse(dateString, $formatter);
            }
            catch (DateTimeParseException e) {
                localDateTime = null;
            }
            return localDateTime;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

