/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.mapper;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.action.Action;
import org.kuali.research.pdf.action.ActionHelperService;
import org.kuali.research.pdf.action.ActionService;
import org.kuali.research.pdf.link.ActionLink;
import org.kuali.research.pdf.link.ActionLinkInitFinalizeService;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkService;
import org.kuali.research.pdf.mapper.MapAction;
import org.kuali.research.pdf.mapper.MappingDefinition;
import org.kuali.research.pdf.mapper.internal.MapOutput;
import org.kuali.research.pdf.mapper.internal.MapRequest;
import org.kuali.research.pdf.mapper.internal.MapResponse;
import org.kuali.research.pdf.mapper.internal.MapperService;
import org.kuali.research.pdf.sys.model.Level;
import org.kuali.research.pdf.sys.model.Message;
import org.kuali.research.pdf.sys.model.Status;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B9\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0006\u0010\u001b\u001a\u00020\u0002H\u0012J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u001b\u001a\u00020\u0002H\u0012J\"\u0010%\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0#0&2\u0006\u0010)\u001a\u00020'H\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006*"}, d2={"Lorg/kuali/research/pdf/mapper/MapActionServiceImpl;", "Lorg/kuali/research/pdf/action/ActionService;", "Lorg/kuali/research/pdf/mapper/MapAction;", "Lorg/apache/logging/log4j/kotlin/Logging;", "actionHelperService", "Lorg/kuali/research/pdf/action/ActionHelperService;", "linkService", "Lorg/kuali/research/pdf/link/LinkService;", "mapperService", "Lorg/kuali/research/pdf/mapper/internal/MapperService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "actionLinkInitFinalizeService", "Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "<init>", "(Lorg/kuali/research/pdf/action/ActionHelperService;Lorg/kuali/research/pdf/link/LinkService;Lorg/kuali/research/pdf/mapper/internal/MapperService;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;)V", "getActionHelperService", "()Lorg/kuali/research/pdf/action/ActionHelperService;", "getLinkService", "()Lorg/kuali/research/pdf/link/LinkService;", "getMapperService", "()Lorg/kuali/research/pdf/mapper/internal/MapperService;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getActionLinkInitFinalizeService", "()Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "init", "action", "exec", "finalize", "fetchInput", "", "", "", "fetchMappings", "", "Lorg/kuali/research/pdf/mapper/MappingDefinition;", "stripErrors", "Lkotlin/Pair;", "Lorg/kuali/research/pdf/mapper/internal/MapResponse;", "Lorg/kuali/research/pdf/sys/model/Message;", "mapResponse", "pdf"})
@SourceDebugExtension(value={"SMAP\nMapActionServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapActionServiceImpl.kt\norg/kuali/research/pdf/mapper/MapActionServiceImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n126#2:156\n153#2,2:157\n155#2:161\n77#2:179\n97#2,2:180\n99#2,3:195\n126#2:198\n153#2,3:199\n126#2:202\n153#2,3:203\n60#3:159\n51#3:160\n60#3:162\n51#3:163\n465#4:164\n415#4:165\n563#4:172\n548#4,6:173\n1252#5,2:166\n774#5:168\n865#5,2:169\n1255#5:171\n827#5:182\n855#5,2:183\n1374#5:185\n1460#5,2:186\n1563#5:188\n1634#5,3:189\n1462#5,3:192\n*S KotlinDebug\n*F\n+ 1 MapActionServiceImpl.kt\norg/kuali/research/pdf/mapper/MapActionServiceImpl\n*L\n122#1:156\n122#1:157,2\n122#1:161\n149#1:179\n149#1:180,2\n149#1:195,3\n55#1:198\n55#1:199,3\n107#1:202\n107#1:203,3\n125#1:159\n125#1:160\n137#1:162\n137#1:163\n145#1:164\n145#1:165\n146#1:172\n146#1:173,6\n145#1:166,2\n145#1:168\n145#1:169,2\n145#1:171\n151#1:182\n151#1:183,2\n152#1:185\n152#1:186,2\n152#1:188\n152#1:189,3\n152#1:192,3\n*E\n"})
public class MapActionServiceImpl
implements ActionService<MapAction>,
Logging {
    @NotNull
    private final ActionHelperService actionHelperService;
    @NotNull
    private final LinkService linkService;
    @NotNull
    private final MapperService mapperService;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ActionLinkInitFinalizeService actionLinkInitFinalizeService;

    public MapActionServiceImpl(@Autowired @NotNull ActionHelperService actionHelperService, @Autowired @NotNull LinkService linkService, @Autowired @NotNull MapperService mapperService, @Autowired @NotNull ObjectMapper objectMapper, @Autowired @NotNull ActionLinkInitFinalizeService actionLinkInitFinalizeService) {
        Intrinsics.checkNotNullParameter((Object)actionHelperService, (String)"actionHelperService");
        Intrinsics.checkNotNullParameter((Object)linkService, (String)"linkService");
        Intrinsics.checkNotNullParameter((Object)mapperService, (String)"mapperService");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)actionLinkInitFinalizeService, (String)"actionLinkInitFinalizeService");
        this.actionHelperService = actionHelperService;
        this.linkService = linkService;
        this.mapperService = mapperService;
        this.objectMapper = objectMapper;
        this.actionLinkInitFinalizeService = actionLinkInitFinalizeService;
    }

    @NotNull
    public ActionHelperService getActionHelperService() {
        return this.actionHelperService;
    }

    @NotNull
    public LinkService getLinkService() {
        return this.linkService;
    }

    @NotNull
    public MapperService getMapperService() {
        return this.mapperService;
    }

    @NotNull
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NotNull
    public ActionLinkInitFinalizeService getActionLinkInitFinalizeService() {
        return this.actionLinkInitFinalizeService;
    }

    @Override
    @NotNull
    public MapAction init(@NotNull MapAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (MapAction)this.getActionHelperService().initManual((Action)action, arg_0 -> MapActionServiceImpl.init$lambda$1(this, arg_0));
    }

    @Override
    @NotNull
    public MapAction exec(@NotNull MapAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (MapAction)this.getActionHelperService().execManual((Action)action, arg_0 -> MapActionServiceImpl.exec$lambda$3(this, arg_0));
    }

    @Override
    @NotNull
    public MapAction finalize(@NotNull MapAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (MapAction)this.getActionHelperService().finalizeManual((Action)action, arg_0 -> MapActionServiceImpl.finalize$lambda$5(this, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Map<String, Object> fetchInput(MapAction action) {
        Map map;
        if (!action.getInputSources().isEmpty()) {
            void $this$mapTo$iv$iv;
            Map<String, Link> $this$map$iv = action.getInputSources();
            boolean $i$f$map = false;
            Map<String, Link> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object;
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Closeable closeable = this.getLinkService().input((Link)it.getValue());
                Object k = it.getKey();
                Throwable throwable = null;
                try {
                    Object input;
                    InputStream stream = (InputStream)closeable;
                    boolean bl2 = false;
                    ObjectMapper $this$readValue$iv = this.getObjectMapper();
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    object = input = $this$readValue$iv.readValue(stream, (TypeReference)new TypeReference<Object>(){});
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                collection.add(TuplesKt.to(k, (Object)object));
            }
            map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        } else {
            map = action.getInput();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MappingDefinition> fetchMappings(MapAction action) {
        Object object;
        block9: {
            block8: {
                List list;
                object = action.getMappingSource();
                if (object == null) break block8;
                Link it = object;
                boolean bl = false;
                Closeable closeable = this.getLinkService().input(action.getMappingSource());
                Throwable throwable = null;
                try {
                    List mappings;
                    InputStream it2 = (InputStream)closeable;
                    boolean bl2 = false;
                    ObjectMapper $this$readValue$iv = this.getObjectMapper();
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    List list2 = mappings = (List)$this$readValue$iv.readValue(it2, (TypeReference)new TypeReference<List<? extends MappingDefinition>>(){});
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = list;
                if (list != null) break block9;
            }
            object = action.getMappings();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private Pair<MapResponse, List<Message>> stripErrors(MapResponse mapResponse) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        List outputs;
        Map.Entry entry;
        void $this$filterNotTo$iv$iv;
        Map.Entry entry2;
        Object object;
        Map<String, List<MapOutput>> $this$mapValuesTo$iv$iv;
        Map<String, List<MapOutput>> $this$mapValues$iv = mapResponse.getOutput();
        boolean $i$f$mapValues = false;
        Map<String, List<MapOutput>> map = $this$mapValues$iv;
        Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$filterTo$iv$iv;
            void it$iv$iv;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map<String, List<MapOutput>> map2 = object;
            boolean bl2 = false;
            List outputs2 = (List)entry2.getValue();
            Iterable $this$filter$iv = outputs2;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                MapOutput it = (MapOutput)element$iv$iv3;
                boolean bl3 = false;
                if (!(it.getMessages().isEmpty() && it.getValue() != null)) continue;
                destination$iv$iv2.add(element$iv$iv3);
            }
            List list = (List)destination$iv$iv2;
            map2.put((String)k, list);
        }
        Map<String, List<MapOutput>> $this$filterNot$iv = destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapValuesTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        for (Map.Entry element$iv$iv : $this$filterNotTo$iv$iv.entrySet()) {
            entry = element$iv$iv;
            boolean bl = false;
            outputs = (List)entry.getValue();
            if (outputs.isEmpty()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Status status = mapResponse.getStatus();
        Map<String, List<MapOutput>> map3 = destination$iv$iv;
        $this$filterNot$iv = mapResponse.getOutput();
        MapResponse mapResponse2 = new MapResponse((Map<String, ? extends List<MapOutput>>)map3, status);
        boolean $i$f$flatMap = false;
        $this$filterNotTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$flatMapTo$iv$iv2;
            void $this$flatMap$iv2;
            void $this$filterNotTo$iv$iv2;
            Iterable $this$filterNot$iv2;
            Map.Entry element$iv$iv;
            entry = element$iv$iv = iterator2.next();
            boolean bl = false;
            outputs = (List)entry.getValue();
            object = outputs;
            boolean $i$f$filterNot2 = false;
            entry2 = $this$filterNot$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterNotTo2 = false;
            for (Object element$iv$iv2 : $this$filterNotTo$iv$iv2) {
                MapOutput it = (MapOutput)element$iv$iv2;
                boolean bl4 = false;
                if (it.getMessages().isEmpty()) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            $this$filterNot$iv2 = (List)destination$iv$iv3;
            boolean $i$f$flatMap2 = false;
            $this$filterNotTo$iv$iv2 = $this$flatMap$iv2;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                void $this$mapTo$iv$iv;
                Object element$iv$iv3;
                MapOutput output = (MapOutput)element$iv$iv2;
                boolean bl5 = false;
                Iterable $this$map$iv = output.getMessages();
                boolean $i$f$map = false;
                element$iv$iv3 = $this$map$iv;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Message message = (Message)item$iv$iv;
                    Collection collection = destination$iv$iv4;
                    boolean bl6 = false;
                    collection.add(Message.copy$default((Message)it, null, Level.WARN, null, null, null, 29, null));
                }
                Iterable list$iv$iv = (List)destination$iv$iv4;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return TuplesKt.to((Object)mapResponse2, (Object)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public MapAction preValidate(@NotNull MapAction action) {
        return (MapAction)ActionService.DefaultImpls.preValidate(this, (Action)action);
    }

    @Override
    @NotNull
    public MapAction postValidate(@NotNull MapAction action) {
        return (MapAction)ActionService.DefaultImpls.postValidate(this, (Action)action);
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }

    /*
     * WARNING - void declaration
     */
    private static final MapAction init$lambda$1(MapActionServiceImpl this$0, MapAction executingAction) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Link source = executingAction.getMappingSource() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().init((ActionLink)executingAction.getMappingSource(), executingAction) : executingAction.getMappingSource();
        Link target = executingAction.getTarget() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().init((ActionLink)executingAction.getTarget(), executingAction) : executingAction.getTarget();
        Map<String, Link> map = executingAction.getInputSources();
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Link link;
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            if (it.getValue() instanceof ActionLink) {
                ActionLinkInitFinalizeService actionLinkInitFinalizeService = this$0.getActionLinkInitFinalizeService();
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type org.kuali.research.pdf.link.ActionLink");
                link = actionLinkInitFinalizeService.init((ActionLink)v, executingAction);
            } else {
                link = (Link)it.getValue();
            }
            collection.add(TuplesKt.to(k, (Object)link));
        }
        Map inputSources = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        return MapAction.copy$default(executingAction, null, null, source, null, inputSources, null, target, null, null, null, 939, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MapAction exec$lambda$3(MapActionServiceImpl this$0, MapAction executingAction) {
        MapAction mapAction;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        List executedMessages = CollectionsKt.toMutableList((Collection)executingAction.getMessages());
        MapRequest mapRequest = new MapRequest(this$0.fetchMappings(executingAction), this$0.fetchInput(executingAction), false, 4, null);
        if (mapRequest.getMappings().isEmpty() || mapRequest.getInput().isEmpty()) {
            ((Collection)executedMessages).add(Message.Companion.warn$default(Message.Companion, "Nothing to map", "mapping.or.data.empty", null, 4, null));
            mapAction = MapAction.copy$default(executingAction, null, null, null, null, null, null, null, null, null, executedMessages, 511, null);
        } else {
            Pair<MapResponse, List<Message>> pair = this$0.stripErrors(this$0.getMapperService().map(mapRequest));
            MapResponse response = (MapResponse)pair.component1();
            List errors = (List)pair.component2();
            CollectionsKt.addAll((Collection)executedMessages, (Iterable)errors);
            LinkService linkService = this$0.getLinkService();
            Link link = executingAction.getTarget();
            String string = executingAction.getJobId();
            Intrinsics.checkNotNull((Object)string);
            String string2 = executingAction.getActionId();
            Intrinsics.checkNotNull((Object)string2);
            Link resolvedTarget = linkService.newIfNull(link, string, string2, "0");
            Closeable closeable = this$0.getLinkService().output(resolvedTarget);
            Throwable throwable = null;
            try {
                OutputStream outputStream = (OutputStream)closeable;
                boolean bl = false;
                this$0.getObjectMapper().writeValue(outputStream, response.getOutput());
                MapAction mapAction2 = MapAction.copy$default(executingAction, null, null, null, null, null, null, resolvedTarget, null, null, executedMessages, 447, null);
                mapAction = mapAction2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return mapAction;
    }

    /*
     * WARNING - void declaration
     */
    private static final MapAction finalize$lambda$5(MapActionServiceImpl this$0, MapAction executingAction) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Link source = executingAction.getMappingSource() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().finalize((ActionLink)executingAction.getMappingSource(), executingAction) : executingAction.getMappingSource();
        Link target = executingAction.getTarget() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().finalize((ActionLink)executingAction.getTarget(), executingAction) : executingAction.getTarget();
        Map<String, Link> map = executingAction.getInputSources();
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Link link;
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            if (it.getValue() instanceof ActionLink) {
                ActionLinkInitFinalizeService actionLinkInitFinalizeService = this$0.getActionLinkInitFinalizeService();
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type org.kuali.research.pdf.link.ActionLink");
                link = actionLinkInitFinalizeService.finalize((ActionLink)v, executingAction);
            } else {
                link = (Link)it.getValue();
            }
            collection.add(TuplesKt.to(k, (Object)link));
        }
        Map inputSources = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        return MapAction.copy$default(executingAction, null, null, source, null, inputSources, null, target, null, null, null, 939, null);
    }
}

