/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.mapper;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.pdf.mapper.FunctionProviderBase;
import org.kuali.research.pdf.mapper.MapperFunction;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/kuali/research/pdf/mapper/PhoneFunctions;", "Lorg/kuali/research/pdf/mapper/FunctionProviderBase;", "<init>", "()V", "Companion", "pdf"})
public class PhoneFunctions
extends FunctionProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public PhoneFunctions() {
        super("Phone");
    }

    @JvmStatic
    @MapperFunction(registeredName="areaCode", description="ex: #areaCode(\"555-666-7777\") = \"555\"  Return the area code from a phone number.  Phone formats understood include local, domestic, and international numbers without extensions.")
    @NotNull
    public static final String areaCode(@Nullable String rawPhone) {
        return Companion.areaCode(rawPhone);
    }

    @JvmStatic
    @MapperFunction(registeredName="localPhone", description="ex: #localPhone(\"555-666-7777\") = \"666-7777\"  Return the local number from a phone number.  Phone formats understood include local, domestic, and international numbers without extensions.")
    @NotNull
    public static final String localPhone(@Nullable String rawPhone) {
        return Companion.localPhone(rawPhone);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\u0007\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0007\u00a8\u0006\t"}, d2={"Lorg/kuali/research/pdf/mapper/PhoneFunctions$Companion;", "", "<init>", "()V", "stripPhone", "", "rawPhone", "areaCode", "localPhone", "pdf"})
    public static final class Companion {
        private Companion() {
        }

        private final String stripPhone(String rawPhone) {
            String string;
            String string2;
            String string3 = rawPhone;
            if (string3 != null) {
                CharSequence charSequence = string3;
                Regex regex = new Regex("[^0-9]");
                String string4 = "";
                string2 = regex.replace(charSequence, string4);
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                string = "";
            }
            return string;
        }

        @JvmStatic
        @MapperFunction(registeredName="areaCode", description="ex: #areaCode(\"555-666-7777\") = \"555\"  Return the area code from a phone number.  Phone formats understood include local, domestic, and international numbers without extensions.")
        @NotNull
        public final String areaCode(@Nullable String rawPhone) {
            String it = this.stripPhone(rawPhone);
            boolean bl = false;
            int n = it.length();
            if (!(10 <= n ? n < 14 : false)) {
                throw new IllegalArgumentException("Unable to parse " + rawPhone + " or no area code provided");
            }
            return StringsKt.take((String)StringsKt.takeLast((String)it, (int)10), (int)3);
        }

        @JvmStatic
        @MapperFunction(registeredName="localPhone", description="ex: #localPhone(\"555-666-7777\") = \"666-7777\"  Return the local number from a phone number.  Phone formats understood include local, domestic, and international numbers without extensions.")
        @NotNull
        public final String localPhone(@Nullable String rawPhone) {
            String it = this.stripPhone(rawPhone);
            boolean bl = false;
            int n = it.length();
            if (!(7 <= n ? n < 14 : false)) {
                throw new IllegalArgumentException("Unable to parse " + rawPhone);
            }
            String string = new StringBuilder(StringsKt.takeLast((String)it, (int)7)).insert(3, "-").toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"let(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

