/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.sys.env;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.sys.env.Env;
import org.kuali.research.pdf.sys.env.EnvService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@ConditionalOnProperty(name={"env.aware.enabled"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001BE\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\u000e\b\u0003\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u0012\u000e\b\u0001\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J$\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00050\u00050\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010 \u001a\u00020\u0018H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/kuali/research/pdf/sys/env/HeaderBasedEnvFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "envService", "Lorg/kuali/research/pdf/sys/env/EnvService;", "tenantHeaderName", "", "laneHeaderName", "additionalHeaderNames", "", "excludedUrls", "<init>", "(Lorg/kuali/research/pdf/sys/env/EnvService;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;)V", "getEnvService", "()Lorg/kuali/research/pdf/sys/env/EnvService;", "getTenantHeaderName", "()Ljava/lang/String;", "getLaneHeaderName", "getAdditionalHeaderNames", "()Ljava/util/Set;", "shouldNotFilter", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "doFilterInternal", "", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "getAdditionalHeaders", "", "kotlin.jvm.PlatformType", "verifyHeaderName", "pdf"})
@SourceDebugExtension(value={"SMAP\nEnvAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvAware.kt\norg/kuali/research/pdf/sys/env/HeaderBasedEnvFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1761#2,3:92\n1285#2,2:95\n1299#2,4:97\n506#3,7:101\n1#4:108\n*S KotlinDebug\n*F\n+ 1 EnvAware.kt\norg/kuali/research/pdf/sys/env/HeaderBasedEnvFilter\n*L\n42#1:92,3\n67#1:95,2\n67#1:97,4\n67#1:101,7\n*E\n"})
public class HeaderBasedEnvFilter
extends OncePerRequestFilter {
    @NotNull
    private final EnvService envService;
    @NotNull
    private final String tenantHeaderName;
    @NotNull
    private final String laneHeaderName;
    @NotNull
    private final Set<String> additionalHeaderNames;
    @NotNull
    private final Set<String> excludedUrls;

    public HeaderBasedEnvFilter(@Autowired @NotNull EnvService envService, @Value(value="${env.aware.tenant.header.name:}") @NotNull String tenantHeaderName, @Value(value="${env.aware.lane.header.name:}") @NotNull String laneHeaderName, @Value(value="${env.aware.additional.header.names:}") @NotNull Set<String> additionalHeaderNames, @Value(value="${env.aware.excludedUrls:/pdf/health,/pdf/swagger/.*,/pdf/webjars/.*}") @NotNull Set<String> excludedUrls) {
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        Intrinsics.checkNotNullParameter((Object)tenantHeaderName, (String)"tenantHeaderName");
        Intrinsics.checkNotNullParameter((Object)laneHeaderName, (String)"laneHeaderName");
        Intrinsics.checkNotNullParameter(additionalHeaderNames, (String)"additionalHeaderNames");
        Intrinsics.checkNotNullParameter(excludedUrls, (String)"excludedUrls");
        this.envService = envService;
        this.tenantHeaderName = tenantHeaderName;
        this.laneHeaderName = laneHeaderName;
        this.additionalHeaderNames = additionalHeaderNames;
        this.excludedUrls = excludedUrls;
    }

    public /* synthetic */ HeaderBasedEnvFilter(EnvService envService, String string, String string2, Set set, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        this(envService, string, string2, set, set2);
    }

    @NotNull
    public EnvService getEnvService() {
        return this.envService;
    }

    @NotNull
    public String getTenantHeaderName() {
        return this.tenantHeaderName;
    }

    @NotNull
    public String getLaneHeaderName() {
        return this.laneHeaderName;
    }

    @NotNull
    public Set<String> getAdditionalHeaderNames() {
        return this.additionalHeaderNames;
    }

    protected boolean shouldNotFilter(@NotNull HttpServletRequest request) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Iterable $this$any$iv = this.excludedUrls;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = request.getRequestURI();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
                    CharSequence charSequence = string;
                    if (!new Regex(it).matches(charSequence)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
        String tenant = request.getHeader(this.getTenantHeaderName());
        String lane = request.getHeader(this.getLaneHeaderName());
        CharSequence charSequence = tenant;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)lane) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            response.sendError(HttpStatus.BAD_REQUEST.value(), "Request Headers are required [" + this.getTenantHeaderName() + ", " + this.getLaneHeaderName() + "]");
        } else {
            try {
                this.getEnvService().getEnv().set(new Env(tenant, lane, this.getAdditionalHeaders(request)));
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                this.getEnvService().getEnv().remove();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, String> getAdditionalHeaders(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Iterable $this$associateWith$iv = this.getAdditionalHeaderNames();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            String string2 = request.getHeader((String)it);
            map.put(t, string2);
        }
        Map $this$filterValues$iv = result$iv;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            String it = (String)entry$iv.getValue();
            boolean bl = false;
            if (!(it != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    @PostConstruct
    public void verifyHeaderName() {
        if (!(!StringsKt.isBlank((CharSequence)this.getTenantHeaderName()))) {
            boolean $i$a$-check-HeaderBasedEnvFilter$verifyHeaderName$32 = false;
            String $i$a$-check-HeaderBasedEnvFilter$verifyHeaderName$32 = "tenantHeaderName is blank";
            throw new IllegalStateException($i$a$-check-HeaderBasedEnvFilter$verifyHeaderName$32.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)this.getLaneHeaderName()))) {
            boolean bl = false;
            String string = "laneHeaderName is blank";
            throw new IllegalStateException(string.toString());
        }
    }
}

