/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.sys.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import jakarta.annotation.PreDestroy;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.sys.env.EnvService;
import org.kuali.research.pdf.sys.mongo.EnvAwareMongoClientDatabaseFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoClientFactory;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.boot.autoconfigure.mongo.MongoConnectionDetails;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.autoconfigure.mongo.StandardMongoClientSettingsBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoDatabaseFactorySupport;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

@Configuration
@EnableConfigurationProperties(value={MongoProperties.class})
@ConditionalOnProperty(name={"mongo.enabled"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0010\u001a\u00020\u0011H\u0017J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0092.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/kuali/research/pdf/sys/mongo/ConditionalMongoDataAutoConfiguration;", "", "properties", "Lorg/springframework/boot/autoconfigure/mongo/MongoProperties;", "<init>", "(Lorg/springframework/boot/autoconfigure/mongo/MongoProperties;)V", "getProperties", "()Lorg/springframework/boot/autoconfigure/mongo/MongoProperties;", "mongoClient", "Lcom/mongodb/client/MongoClient;", "mongo", "builderCustomizers", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/springframework/boot/autoconfigure/mongo/MongoClientSettingsBuilderCustomizer;", "settings", "Lcom/mongodb/MongoClientSettings;", "close", "", "envAwareMongoDbFactory", "Lorg/springframework/data/mongodb/core/MongoDatabaseFactorySupport;", "envService", "Lorg/kuali/research/pdf/sys/env/EnvService;", "dotReplacementMappingMongoConverter", "Lorg/springframework/data/mongodb/core/convert/MappingMongoConverter;", "factory", "Lorg/springframework/data/mongodb/MongoDatabaseFactory;", "context", "Lorg/springframework/data/mongodb/core/mapping/MongoMappingContext;", "conversions", "Lorg/springframework/data/mongodb/core/convert/MongoCustomConversions;", "MongoClientSettingsConfiguration", "pdf"})
public class ConditionalMongoDataAutoConfiguration {
    @NotNull
    private final MongoProperties properties;
    private MongoClient mongoClient;

    public ConditionalMongoDataAutoConfiguration(@NotNull MongoProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
    }

    @NotNull
    public MongoProperties getProperties() {
        return this.properties;
    }

    @Bean
    @NotNull
    public MongoClient mongo(@NotNull ObjectProvider<MongoClientSettingsBuilderCustomizer> builderCustomizers, @NotNull MongoClientSettings settings) {
        Intrinsics.checkNotNullParameter(builderCustomizers, (String)"builderCustomizers");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.mongoClient = (MongoClient)new MongoClientFactory(builderCustomizers.orderedStream().collect(Collectors.toList())).createMongoClient(settings);
        MongoClient mongoClient = this.mongoClient;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mongoClient");
            mongoClient = null;
        }
        return mongoClient;
    }

    @PreDestroy
    public void close() {
        MongoClient mongoClient = this.mongoClient;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mongoClient");
            mongoClient = null;
        }
        mongoClient.close();
    }

    @ConditionalOnProperty(name={"env.aware.enabled"})
    @Bean
    @NotNull
    public MongoDatabaseFactorySupport<MongoClient> envAwareMongoDbFactory(@NotNull ObjectProvider<MongoClient> mongoClient, @NotNull EnvService envService) {
        Intrinsics.checkNotNullParameter(mongoClient, (String)"mongoClient");
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        MongoClient client = (MongoClient)mongoClient.getIfAvailable();
        if (client != null) {
            String string = this.getProperties().getMongoClientDatabase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMongoClientDatabase(...)");
            return (MongoDatabaseFactorySupport)new EnvAwareMongoClientDatabaseFactory(envService, client, string);
        }
        throw new IllegalStateException("Expected to find at least one MongoDB client.");
    }

    @Bean
    @NotNull
    public MappingMongoConverter dotReplacementMappingMongoConverter(@NotNull MongoDatabaseFactory factory, @NotNull MongoMappingContext context, @NotNull MongoCustomConversions conversions) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)conversions, (String)"conversions");
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(factory);
        MappingMongoConverter mappingConverter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)context);
        mappingConverter.setCustomConversions((CustomConversions)conversions);
        mappingConverter.setMapKeyDotReplacement("-_dot_-");
        return mappingConverter;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(name={"mongo.enabled"})
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0011\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0017\u00a8\u0006\u000f"}, d2={"Lorg/kuali/research/pdf/sys/mongo/ConditionalMongoDataAutoConfiguration$MongoClientSettingsConfiguration;", "", "<init>", "()V", "mongoClientSettings", "Lcom/mongodb/MongoClientSettings;", "standardMongoSettingsCustomizer", "Lorg/springframework/boot/autoconfigure/mongo/StandardMongoClientSettingsBuilderCustomizer;", "properties", "Lorg/springframework/boot/autoconfigure/mongo/MongoProperties;", "connectionDetails", "Lorg/springframework/boot/autoconfigure/mongo/MongoConnectionDetails;", "sslBundles", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/springframework/boot/ssl/SslBundles;", "pdf"})
    public static class MongoClientSettingsConfiguration {
        @Bean
        @NotNull
        public MongoClientSettings mongoClientSettings() {
            MongoClientSettings mongoClientSettings = MongoClientSettings.builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)mongoClientSettings, (String)"build(...)");
            return mongoClientSettings;
        }

        @Bean
        @NotNull
        public StandardMongoClientSettingsBuilderCustomizer standardMongoSettingsCustomizer(@NotNull MongoProperties properties, @NotNull MongoConnectionDetails connectionDetails, @NotNull ObjectProvider<SslBundles> sslBundles) {
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            Intrinsics.checkNotNullParameter((Object)connectionDetails, (String)"connectionDetails");
            Intrinsics.checkNotNullParameter(sslBundles, (String)"sslBundles");
            return new StandardMongoClientSettingsBuilderCustomizer(connectionDetails.getConnectionString(), properties.getUuidRepresentation(), properties.getSsl(), (SslBundles)sslBundles.getIfAvailable());
        }
    }
}

