/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.job;

import com.google.common.graph.Graph;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.ThreadContextElementKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.pdf.action.Action;
import org.kuali.research.pdf.action.ActionServiceRegistry;
import org.kuali.research.pdf.job.Job;
import org.kuali.research.pdf.job.JobDao;
import org.kuali.research.pdf.job.JobService;
import org.kuali.research.pdf.job.JobServiceImpl;
import org.kuali.research.pdf.sys.env.Env;
import org.kuali.research.pdf.sys.env.EnvService;
import org.kuali.research.pdf.sys.model.Level;
import org.kuali.research.pdf.sys.model.Message;
import org.kuali.research.pdf.sys.model.Status;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0012H\u0017J\u001e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0092@\u00a2\u0006\u0002\u0010\u001aJ#\u0010\u001b\u001a\u00020\u0014\"\f\b\u0000\u0010\u001c*\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001e\u001a\u0002H\u001cH\u0012\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0012J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0012J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u0012H\u0012J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0006\u0010\u0018\u001a\u00020\u0012H\u0012J\u0016\u0010%\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0092@\u00a2\u0006\u0002\u0010&J&\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0(2\u0006\u0010\u0018\u001a\u00020\u0012H\u0092@\u00a2\u0006\u0002\u0010&J\\\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0(2\u0016\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0(2\u0016\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0(2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00140,H\u0092@\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0012J\u0016\u0010/\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0092@\u00a2\u0006\u0002\u0010&J\u0018\u00100\u001a\u0002012\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u00102\u001a\u000201H\u0016JN\u00103\u001a\b\u0012\u0004\u0012\u0002H40\u0016\"\u0004\b\u0000\u00105\"\u0004\b\u0001\u00104*\b\u0012\u0004\u0012\u0002H5062\"\u00107\u001a\u001e\b\u0001\u0012\u0004\u0012\u0002H5\u0012\n\u0012\b\u0012\u0004\u0012\u0002H409\u0012\u0006\u0012\u0004\u0018\u00010:08H\u0096@\u00a2\u0006\u0002\u0010;R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006<"}, d2={"Lorg/kuali/research/pdf/job/JobServiceImpl;", "Lorg/kuali/research/pdf/job/JobService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "envService", "Lorg/kuali/research/pdf/sys/env/EnvService;", "actionServiceRegistry", "Lorg/kuali/research/pdf/action/ActionServiceRegistry;", "jobDao", "Lorg/kuali/research/pdf/job/JobDao;", "<init>", "(Lorg/kuali/research/pdf/sys/env/EnvService;Lorg/kuali/research/pdf/action/ActionServiceRegistry;Lorg/kuali/research/pdf/job/JobDao;)V", "getEnvService", "()Lorg/kuali/research/pdf/sys/env/EnvService;", "getActionServiceRegistry", "()Lorg/kuali/research/pdf/action/ActionServiceRegistry;", "getJobDao", "()Lorg/kuali/research/pdf/job/JobDao;", "fetch", "Lorg/kuali/research/pdf/job/Job;", "jobId", "", "fetchAll", "", "submit", "job", "receive", "(Lorg/kuali/research/pdf/job/Job;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchActionId", "T", "Lorg/kuali/research/pdf/action/Action;", "action", "(Lorg/kuali/research/pdf/action/Action;)Ljava/lang/String;", "process", "preValidate", "containsActions", "", "nonUniqueActionIds", "executeActions", "(Lorg/kuali/research/pdf/job/Job;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeActionsInParallel", "", "unprocessed", "processed", "actionGraph", "Lcom/google/common/graph/Graph;", "(Ljava/util/Map;Ljava/util/Map;Lcom/google/common/graph/Graph;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "postValidate", "finalize", "determineJobStatus", "Lorg/kuali/research/pdf/sys/model/Status;", "proposedStatus", "pmap", "B", "A", "", "f", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "(Ljava/lang/Iterable;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pdf"})
@SourceDebugExtension(value={"SMAP\nJobServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JobServiceImpl.kt\norg/kuali/research/pdf/job/JobServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,276:1\n1563#2:277\n1634#2,3:278\n1563#2:282\n1634#2,3:283\n1491#2:286\n1516#2,3:287\n1519#2,3:297\n1563#2:307\n1634#2,3:308\n1208#2,2:311\n1236#2,4:313\n3301#2,10:317\n1193#2,2:327\n1267#2,4:329\n1563#2:333\n1634#2,3:334\n774#2:337\n865#2,2:338\n1761#2,3:340\n1#3:281\n382#4,7:290\n536#4:300\n521#4,6:301\n*S KotlinDebug\n*F\n+ 1 JobServiceImpl.kt\norg/kuali/research/pdf/job/JobServiceImpl\n*L\n63#1:277\n63#1:278,3\n124#1:282\n124#1:283,3\n145#1:286\n145#1:287,3\n145#1:297,3\n149#1:307\n149#1:308,3\n163#1:311,2\n163#1:313,4\n176#1:317,10\n189#1:327,2\n189#1:329,4\n204#1:333\n204#1:334,3\n226#1:337\n226#1:338,2\n260#1:340,3\n145#1:290,7\n145#1:300\n145#1:301,6\n*E\n"})
public class JobServiceImpl
implements JobService,
Logging {
    @NotNull
    private final EnvService envService;
    @NotNull
    private final ActionServiceRegistry actionServiceRegistry;
    @NotNull
    private final JobDao jobDao;

    public JobServiceImpl(@Autowired @NotNull EnvService envService, @Autowired @NotNull ActionServiceRegistry actionServiceRegistry, @Autowired @NotNull JobDao jobDao) {
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        Intrinsics.checkNotNullParameter((Object)actionServiceRegistry, (String)"actionServiceRegistry");
        Intrinsics.checkNotNullParameter((Object)jobDao, (String)"jobDao");
        this.envService = envService;
        this.actionServiceRegistry = actionServiceRegistry;
        this.jobDao = jobDao;
    }

    @NotNull
    public EnvService getEnvService() {
        return this.envService;
    }

    @NotNull
    public ActionServiceRegistry getActionServiceRegistry() {
        return this.actionServiceRegistry;
    }

    @NotNull
    public JobDao getJobDao() {
        return this.jobDao;
    }

    @Nullable
    public Job fetch(@NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        return this.getJobDao().findById(jobId);
    }

    @NotNull
    public List<Job> fetchAll() {
        return this.getJobDao().findAll();
    }

    @Cacheable(cacheNames={"jobs"}, key="#job.cacheKey()")
    @NotNull
    public String submit(@NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String jobId = string;
        Env currentEnv = (Env)this.getEnvService().getEnv().get();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)ThreadContextElementKt.asContextElement((ThreadLocal)this.getEnvService().getEnv(), (Object)currentEnv)), null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)2, null);
        return jobId;
    }

    /*
     * Unable to fully structure code
     */
    private Object receive(Job job, String jobId, Continuation<? super Job> $completion) {
        if (!($completion instanceof receive.1)) ** GOTO lbl-1000
        var23_4 = $completion;
        if ((var23_4.label & -2147483648) != 0) {
            var23_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new /* Unavailable Anonymous Inner Class!! */;
        }
        $result = $continuation.result;
        var24_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = this.determineJobStatus(job, Status.PENDING);
                v0 = LocalDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"now(...)");
                var6_9 = v0;
                var7_11 = CollectionsKt.plus((Collection)job.getMessages(), (Object)Message.Companion.info$default((Message.Companion)Message.Companion, (String)("Job " + job.getJobId() + " received"), (String)"job.received", null, (int)4, null));
                $this$map$iv = job.getActions();
                $i$f$map = false;
                var11_15 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var16_20 = (Action)item$iv$iv;
                    var18_22 = destination$iv$iv;
                    $i$a$-map-JobServiceImpl$receive$receivedJob$1 = false;
                    var18_22.add(a.copyWith(jobId, this.fetchActionId((Action)a)));
                }
                var8_23 = (List)destination$iv$iv;
                it = var5_7 = Job.copy$default((Job)job, (String)jobId, (boolean)false, (List)var8_23, (Status)var5_7, (LocalDateTime)var6_9, (List)var7_11, (int)2, null);
                $i$a$-also-JobServiceImpl$receive$receivedJob$2 = false;
                this.getJobDao().save((Job)it);
                receivedJob = var5_7;
                var20_25 = 0;
                var19_26 = null;
                var18_22 = receivedJob;
                $continuation.L$0 = job;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)jobId);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)receivedJob);
                $continuation.L$3 = var18_22;
                $continuation.I$0 = var20_25;
                $continuation.label = 1;
                v1 = this.pmap((Iterable)receivedJob.getActions(), (Function2)new /* Unavailable Anonymous Inner Class!! */, (Continuation)$continuation);
                ** if (v1 != var24_6) goto lbl48
lbl47:
                // 1 sources

                return var24_6;
lbl48:
                // 1 sources

                ** GOTO lbl60
            }
            case 1: {
                var20_25 = $continuation.I$0;
                var19_26 = null;
                var18_22 = (Job)$continuation.L$3;
                receivedJob = (Job)$continuation.L$2;
                jobId = (String)$continuation.L$1;
                job = (Job)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl60:
                    // 2 sources

                    var21_27 = v1;
                    it = var5_7 = Job.copy$default((Job)var18_22, var19_26, (boolean)(var20_25 != 0), (List)((List)var21_27), null, null, null, (int)59, null);
                    $i$a$-also-JobServiceImpl$receive$3 = false;
                    this.getJobDao().save((Job)it);
                    var4_24 = var5_7;
                }
                catch (Exception e) {
                    this.getLogger().error((CharSequence)("Job " + job.getJobId() + " failed"), (Throwable)e);
                    v2 = this.determineJobStatus(job, Status.FAIL);
                    v3 = LocalDateTime.now();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"now(...)");
                    v4 = job.getMessages();
                    v5 = e.getMessage();
                    if (v5 == null) {
                        v5 = "unknown";
                    }
                    var4_24 = Job.copy$default((Job)job, null, (boolean)false, null, (Status)v2, (LocalDateTime)v3, (List)CollectionsKt.plus((Collection)v4, (Object)Message.Companion.error$default((Message.Companion)Message.Companion, (String)v5, (String)"unknown.error", null, (int)4, null)), (int)7, null);
                }
                it = var4_24;
                $i$a$-also-JobServiceImpl$receive$4 = false;
                this.getJobDao().save(it);
                return var4_24;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private <T extends Action<?>> String fetchActionId(T action) {
        String string;
        CharSequence charSequence = action.getActionId();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            String string2 = UUID.randomUUID().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        } else {
            String string3 = action.getActionId();
            string = string3;
            Intrinsics.checkNotNull((Object)string3);
        }
        return string;
    }

    private Job process(Job job) {
        Job job2;
        Status status = this.determineJobStatus(job, Status.PROCESSING);
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        Job it = job2 = Job.copy$default((Job)job, null, (boolean)false, null, (Status)status, (LocalDateTime)localDateTime, (List)CollectionsKt.plus((Collection)job.getMessages(), (Object)Message.Companion.info$default((Message.Companion)Message.Companion, (String)("Job " + job.getJobId() + " processing"), (String)"job.processing", null, (int)4, null)), (int)7, null);
        boolean bl = false;
        this.getJobDao().save(it);
        return job2;
    }

    /*
     * WARNING - void declaration
     */
    private Job preValidate(Job job) {
        void $this$mapTo$iv$iv;
        Message jobValidateMessage = Message.Companion.info$default((Message.Companion)Message.Companion, (String)("Job " + job.getJobId() + " validating before execution"), (String)"job.pre.validating", null, (int)4, null);
        Message jobNoActionsMessage = this.containsActions(job) ? null : Message.Companion.warn$default((Message.Companion)Message.Companion, (String)("Job " + job.getJobId() + " does not have any actions"), (String)"job.actions.missing", null, (int)4, null);
        List it = this.nonUniqueActionIds(job);
        boolean $i$a$-let-JobServiceImpl$preValidate$jobActionsNotUnique$22 = false;
        Message jobActionsNotUnique = it.isEmpty() ? null : Message.Companion.error$default((Message.Companion)Message.Companion, (String)("Job " + job.getJobId() + " contains actions with duplicate actionIds: " + it), (String)"job.actions.not.unique", null, (int)4, null);
        Message[] messageArray = new Message[]{jobValidateMessage, jobNoActionsMessage, jobActionsNotUnique};
        List jobMessages = CollectionsKt.plus((Collection)job.getMessages(), (Iterable)CollectionsKt.listOfNotNull((Object[])messageArray));
        messageArray = this.determineJobStatus(job, Status.PROCESSING);
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        LocalDateTime $i$a$-let-JobServiceImpl$preValidate$jobActionsNotUnique$22 = localDateTime;
        Iterable $this$map$iv = job.getActions();
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Action action = (Action)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Action preValidate = it2.copyUpdatingProgress(Status.PROCESSING, Message.Companion.info$default((Message.Companion)Message.Companion, (String)("Action " + it2.getName() + " " + it2.getActionId() + " validating before execution"), (String)"action.pre.validating", null, (int)4, null));
            collection.add(this.getActionServiceRegistry().find(Reflection.getOrCreateKotlinClass(it2.getClass())).preValidate(preValidate));
        }
        List list = (List)destination$iv$iv;
        Message[] it3 = messageArray = Job.copy$default((Job)job, null, (boolean)false, (List)list, (Status)messageArray, (LocalDateTime)$i$a$-let-JobServiceImpl$preValidate$jobActionsNotUnique$22, (List)jobMessages, (int)3, null);
        boolean bl = false;
        this.getJobDao().save((Job)it3);
        return messageArray;
    }

    private boolean containsActions(Job job) {
        return !((Collection)job.getActions()).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private List<String> nonUniqueActionIds(Job job) {
        void $this$filterTo$iv$iv;
        Object element$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = job.getActions();
        boolean $i$f$groupBy = false;
        Iterable iterable2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            element$iv$iv = iterator2.next();
            Action it = (Action)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getActionId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object = element$iv$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            List v = (List)object.getValue();
            if (!(v.size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.filterNotNull((Iterable)destination$iv$iv.keySet());
    }

    /*
     * Unable to fully structure code
     */
    private Object executeActions(Job job, Continuation<? super Job> $completion) {
        if (!($completion instanceof executeActions.1)) ** GOTO lbl-1000
        var16_3 = $completion;
        if ((var16_3.label & -2147483648) != 0) {
            var16_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new /* Unavailable Anonymous Inner Class!! */;
        }
        $result = $continuation.result;
        var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = job;
                $continuation.label = 1;
                v0 = this.executeActionsInParallel(job, (Continuation)$continuation);
                if (v0 == var17_5) {
                    return var17_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                job = (Job)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                executedActionsMap = (Map)v0;
                $this$map$iv = job.getActions();
                $i$f$map = false;
                var7_10 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var12_16 = (Action)item$iv$iv;
                    var14_18 = destination$iv$iv;
                    $i$a$-map-JobServiceImpl$executeActions$executedActions$1 = false;
                    v1 = it.getActionId();
                    Intrinsics.checkNotNull((Object)v1);
                    var14_18.add((Action)MapsKt.getValue((Map)executedActionsMap, (Object)v1));
                }
                executedActions = (List)destination$iv$iv;
                var5_7 = this.determineJobStatus(job, job.getStatus());
                v2 = LocalDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"now(...)");
                $i$f$map = v2;
                $this$mapTo$iv$iv = CollectionsKt.plus((Collection)job.getMessages(), (Object)Message.Companion.info$default((Message.Companion)Message.Companion, (String)("Job " + job.getJobId() + " Actions processing"), (String)"job.actions.processing", null, (int)4, null));
                it = var5_7 = Job.copy$default((Job)job, null, (boolean)false, (List)executedActions, (Status)var5_7, (LocalDateTime)$i$f$map, (List)$this$mapTo$iv$iv, (int)3, null);
                $i$a$-also-JobServiceImpl$executeActions$2 = false;
                this.getJobDao().save((Job)it);
                return var5_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private Object executeActionsInParallel(Job job, Continuation<? super Map<String, ? extends Action<?>>> $completion) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Iterable iterable2 = job.getActions();
        JobServiceImpl jobServiceImpl = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var6_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Action action = (Action)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = it.getActionId();
            Intrinsics.checkNotNull((Object)string);
            map.put(string, element$iv$iv);
        }
        return jobServiceImpl.executeActionsInParallel(destination$iv$iv, MapsKt.emptyMap(), job.getActionGraph(), $completion);
    }

    /*
     * Unable to fully structure code
     */
    private Object executeActionsInParallel(Map<String, ? extends Action<?>> unprocessed, Map<String, ? extends Action<?>> processed, Graph<String> actionGraph, Continuation<? super Map<String, ? extends Action<?>>> $completion) {
        if (!($completion instanceof executeActionsInParallel.3)) ** GOTO lbl-1000
        var23_5 = $completion;
        if ((var23_5.label & -2147483648) != 0) {
            var23_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new /* Unavailable Anonymous Inner Class!! */;
        }
        $result = $continuation.result;
        var24_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (unprocessed.isEmpty()) {
                    return processed;
                }
                processedActionIds = processed.keySet();
                $this$partition$iv = unprocessed.entrySet();
                $i$f$partition = false;
                first$iv = new ArrayList<T>();
                second$iv = new ArrayList<E>();
                for (T element$iv : $this$partition$iv) {
                    it = (Map.Entry)element$iv;
                    $i$a$-partition-JobServiceImpl$executeActionsInParallel$4 = false;
                    if (actionGraph.predecessors(it.getKey()).isEmpty()) ** GOTO lbl-1000
                    v0 = actionGraph.predecessors(it.getKey());
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"predecessors(...)");
                    if (processedActionIds.containsAll(v0)) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
                    v2 = v1 != false ? first$iv.add(element$iv) : second$iv.add(element$iv);
                }
                var6_25 = new Pair(first$iv, second$iv);
                toProcess = (List)var6_25.component1();
                remaining = (List)var6_25.component2();
                if (unprocessed.size() == remaining.size()) {
                    throw new IllegalStateException("Actions cannot be processed");
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)unprocessed);
                $continuation.L$1 = processed;
                $continuation.L$2 = actionGraph;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)processedActionIds);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)toProcess);
                $continuation.L$5 = remaining;
                $continuation.label = 1;
                v3 = this.pmap((Iterable)toProcess, (Function2)new /* Unavailable Anonymous Inner Class!! */, (Continuation)$continuation);
                if (v3 == var24_7) {
                    return var24_7;
                }
                ** GOTO lbl56
            }
            case 1: {
                remaining = (List)$continuation.L$5;
                toProcess = (List)$continuation.L$4;
                processedActionIds = (Set)$continuation.L$3;
                actionGraph = (Graph)$continuation.L$2;
                processed = (Map)$continuation.L$1;
                unprocessed = (Map)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl56:
                // 2 sources

                newlyProcessed = MapsKt.toMap((Iterable)((Iterable)v3));
                second$iv = remaining;
                var21_26 = this;
                $i$f$associate = false;
                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                it = $this$associate$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    var18_30 = destination$iv$iv;
                    it = (Map.Entry)element$iv$iv;
                    $i$a$-associate-JobServiceImpl$executeActionsInParallel$5 = false;
                    var19_31 = TuplesKt.to(it.getKey(), it.getValue());
                    var18_30.put(var19_31.getFirst(), var19_31.getSecond());
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)unprocessed);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)processed);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)actionGraph);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)processedActionIds);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)toProcess);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)remaining);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)newlyProcessed);
                $continuation.label = 2;
                v4 = var21_26.executeActionsInParallel(destination$iv$iv, MapsKt.plus((Map)processed, (Map)newlyProcessed), actionGraph, (Continuation)$continuation);
                if (v4 == var24_7) {
                    return var24_7;
                }
                ** GOTO lbl94
            }
            case 2: {
                newlyProcessed = (Map)$continuation.L$6;
                remaining = (List)$continuation.L$5;
                toProcess = (List)$continuation.L$4;
                processedActionIds = (Set)$continuation.L$3;
                actionGraph = (Graph)$continuation.L$2;
                processed = (Map)$continuation.L$1;
                unprocessed = (Map)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl94:
                // 2 sources

                return v4;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private Job postValidate(Job job) {
        void $this$mapTo$iv$iv;
        Status status = this.determineJobStatus(job, job.getStatus());
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        LocalDateTime localDateTime2 = localDateTime;
        List list = CollectionsKt.plus((Collection)job.getMessages(), (Object)Message.Companion.info$default((Message.Companion)Message.Companion, (String)("Job " + job.getJobId() + " validating after execution"), (String)"job.post.validating", null, (int)4, null));
        Iterable $this$map$iv = job.getActions();
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Action action = (Action)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Action postValidate = it.copyUpdatingProgress(it.getStatus(), Message.Companion.info$default((Message.Companion)Message.Companion, (String)("Action " + it.getName() + " " + it.getActionId() + " validating after execution"), (String)"action.post.validating", null, (int)4, null));
            collection.add(this.getActionServiceRegistry().find(Reflection.getOrCreateKotlinClass(it.getClass())).postValidate(postValidate));
        }
        List list2 = (List)destination$iv$iv;
        Status it = status = Job.copy$default((Job)job, null, (boolean)false, (List)list2, (Status)status, (LocalDateTime)localDateTime2, (List)list, (int)3, null);
        boolean bl = false;
        this.getJobDao().save((Job)it);
        return status;
    }

    /*
     * Unable to fully structure code
     */
    private Object finalize(Job job, Continuation<? super Job> $completion) {
        if (!($completion instanceof finalize.1)) ** GOTO lbl-1000
        var19_3 = $completion;
        if ((var19_3.label & -2147483648) != 0) {
            var19_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new /* Unavailable Anonymous Inner Class!! */;
        }
        $result = $continuation.result;
        var20_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var16_6 = 0;
                var15_7 = null;
                var14_8 = job;
                $continuation.L$0 = job;
                $continuation.L$1 = var14_8;
                $continuation.I$0 = var16_6;
                $continuation.label = 1;
                v0 = this.pmap((Iterable)job.getActions(), (Function2)new /* Unavailable Anonymous Inner Class!! */, (Continuation)$continuation);
                ** if (v0 != var20_5) goto lbl24
lbl23:
                // 1 sources

                return var20_5;
lbl24:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                var16_6 = $continuation.I$0;
                var15_7 = null;
                var14_8 = (Job)$continuation.L$1;
                job = (Job)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl34:
                    // 2 sources

                    var17_9 = v0;
                    finalized = Job.copy$default((Job)var14_8, var15_7, (boolean)(var16_6 != 0), (List)((List)var17_9), null, null, null, (int)59, null);
                    $this$filter$iv = finalized.getActions();
                    $i$f$filter = false;
                    var7_14 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Action)element$iv$iv;
                        $i$a$-filter-JobServiceImpl$finalize$failedActions$1 = false;
                        if (!(it.getStatus() == Status.FAIL)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    failedActions = (List)destination$iv$iv;
                    if (((Collection)failedActions).isEmpty() == false) {
                        v1 = this.determineJobStatus(finalized, Status.FAIL);
                        v2 = LocalDateTime.now();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"now(...)");
                        v3 = Job.copy$default((Job)finalized, null, (boolean)false, null, (Status)v1, (LocalDateTime)v2, (List)CollectionsKt.plus((Collection)finalized.getMessages(), (Object)Message.Companion.error$default((Message.Companion)Message.Companion, (String)("Job " + finalized.getJobId() + " failed as a result of one or more failed actions " + failedActions), (String)"job.failed", null, (int)4, null)), (int)7, null);
                    } else {
                        v4 = this.determineJobStatus(job, Status.SUCCESS);
                        v5 = LocalDateTime.now();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"now(...)");
                        v3 = Job.copy$default((Job)finalized, null, (boolean)false, null, (Status)v4, (LocalDateTime)v5, (List)CollectionsKt.plus((Collection)finalized.getMessages(), (Object)Message.Companion.info$default((Message.Companion)Message.Companion, (String)("Job " + finalized.getJobId() + " completed"), (String)"job.completed", null, (int)4, null)), (int)7, null);
                    }
                    var3_10 = v3;
                }
                catch (Exception e) {
                    this.getLogger().error((CharSequence)("Job " + job.getJobId() + " failed"), (Throwable)e);
                    v6 = this.determineJobStatus(job, Status.FAIL);
                    v7 = LocalDateTime.now();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"now(...)");
                    v8 = job.getMessages();
                    v9 = e.getMessage();
                    if (v9 == null) {
                        v9 = "unknown";
                    }
                    var3_10 = Job.copy$default((Job)job, null, (boolean)false, null, (Status)v6, (LocalDateTime)v7, (List)CollectionsKt.plus((Collection)v8, (Object)Message.Companion.error$default((Message.Companion)Message.Companion, (String)v9, (String)"unknown.error", null, (int)4, null)), (int)7, null);
                }
                it = var3_10;
                $i$a$-also-JobServiceImpl$finalize$2 = false;
                this.getJobDao().save(it);
                return var3_10;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Status determineJobStatus(@NotNull Job job, @NotNull Status proposedStatus) {
        Status status;
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)proposedStatus, (String)"proposedStatus");
        if (proposedStatus != Status.FAIL) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = job.getMessages();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Message it = (Message)element$iv;
                        boolean bl2 = false;
                        if (!(it.getLevel() == Level.ERROR || it.getLevel() == Level.FATAL)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl && job.getStatus() != Status.FAIL) {
                status = proposedStatus;
                return status;
            }
        }
        status = Status.FAIL;
        return status;
    }

    @Nullable
    public <A, B> Object pmap(@NotNull Iterable<? extends A> $this$pmap, @NotNull Function2<? super A, ? super Continuation<? super B>, ? extends Object> f, @NotNull Continuation<? super List<? extends B>> $completion) {
        return JobServiceImpl.pmap$suspendImpl((JobServiceImpl)this, $this$pmap, f, $completion);
    }

    static /* synthetic */ <A, B> Object pmap$suspendImpl(JobServiceImpl $this, Iterable<? extends A> $receiver, Function2<? super A, ? super Continuation<? super B>, ? extends Object> f, Continuation<? super List<? extends B>> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), $completion);
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }

    public static final /* synthetic */ Object access$receive(JobServiceImpl $this, Job job, String jobId, Continuation $completion) {
        return $this.receive(job, jobId, $completion);
    }

    public static final /* synthetic */ Object access$finalize(JobServiceImpl $this, Job job, Continuation $completion) {
        return $this.finalize(job, $completion);
    }

    public static final /* synthetic */ Job access$postValidate(JobServiceImpl $this, Job job) {
        return $this.postValidate(job);
    }

    public static final /* synthetic */ Object access$executeActions(JobServiceImpl $this, Job job, Continuation $completion) {
        return $this.executeActions(job, $completion);
    }

    public static final /* synthetic */ Job access$preValidate(JobServiceImpl $this, Job job) {
        return $this.preValidate(job);
    }

    public static final /* synthetic */ Job access$process(JobServiceImpl $this, Job job) {
        return $this.process(job);
    }

    public static final /* synthetic */ Object access$executeActionsInParallel(JobServiceImpl $this, Job job, Continuation $completion) {
        return $this.executeActionsInParallel(job, $completion);
    }

    public static final /* synthetic */ Object access$executeActionsInParallel(JobServiceImpl $this, Map unprocessed, Map processed, Graph actionGraph, Continuation $completion) {
        return $this.executeActionsInParallel(unprocessed, processed, actionGraph, $completion);
    }
}

