/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.sys.request;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.sys.request.RequestAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@EnableConfigurationProperties(value={RequestAppender.class})
@ConditionalOnProperty(name={"request-attribute-appender.enabled"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/kuali/research/pdf/sys/request/RequestAttributeInjector;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "requestAttributes", "Lorg/kuali/research/pdf/sys/request/RequestAppender;", "<init>", "(Lorg/kuali/research/pdf/sys/request/RequestAppender;)V", "shouldNotFilter", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "doFilterInternal", "", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "pdf"})
@SourceDebugExtension(value={"SMAP\nRequestAttributeInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestAttributeInjector.kt\norg/kuali/research/pdf/sys/request/RequestAttributeInjector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1761#2,3:74\n774#2:77\n865#2,2:78\n1869#2,2:80\n*S KotlinDebug\n*F\n+ 1 RequestAttributeInjector.kt\norg/kuali/research/pdf/sys/request/RequestAttributeInjector\n*L\n32#1:74,3\n41#1:77\n41#1:78,2\n42#1:80,2\n*E\n"})
public class RequestAttributeInjector
extends OncePerRequestFilter {
    @NotNull
    private final RequestAppender requestAttributes;

    public RequestAttributeInjector(@Autowired @NotNull RequestAppender requestAttributes) {
        Intrinsics.checkNotNullParameter((Object)requestAttributes, (String)"requestAttributes");
        this.requestAttributes = requestAttributes;
    }

    protected boolean shouldNotFilter(@NotNull HttpServletRequest request) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Iterable $this$any$iv = this.requestAttributes.getRules();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RequestAppender.AppenderRule it = (RequestAppender.AppenderRule)element$iv;
                    boolean bl2 = false;
                    String string = request.getRequestURI();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
                    if (!it.applies(string)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * WARNING - void declaration
     */
    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
        Iterable iterable2 = this.requestAttributes.getRules();
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RequestAppender.AppenderRule it = (RequestAppender.AppenderRule)element$iv$iv;
            boolean bl = false;
            String string = request.getRequestURI();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
            if (!it.applies(string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RequestAppender.AppenderRule it = (RequestAppender.AppenderRule)element$iv;
            boolean bl = false;
            request.setAttribute(it.getKey(), it.nativeValue());
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

