/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.job;

import com.google.common.graph.Graph;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.pdf.action.Action;
import org.kuali.research.pdf.action.ActionServiceRegistry;
import org.kuali.research.pdf.job.Job;
import org.kuali.research.pdf.job.JobService;
import org.kuali.research.pdf.job.JobServiceImpl;
import org.kuali.research.pdf.job.repository.JobRepository;
import org.kuali.research.pdf.sys.model.Level;
import org.kuali.research.pdf.sys.model.Message;
import org.kuali.research.pdf.sys.model.Status;
import org.kuali.research.pdf.sys.tenancy.TenancyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0014H\u0017J\u001e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0092@\u00a2\u0006\u0002\u0010\u001cJ#\u0010\u001d\u001a\u00020\u0016\"\f\b\u0000\u0010\u001e*\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u0002H\u001eH\u0012\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0012J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0012J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\u0014H\u0012J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\u001a\u001a\u00020\u0014H\u0012J\u0016\u0010'\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0092@\u00a2\u0006\u0002\u0010(J&\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0*2\u0006\u0010\u001a\u001a\u00020\u0014H\u0092@\u00a2\u0006\u0002\u0010(J\\\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0*2\u0016\u0010+\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0*2\u0016\u0010,\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0*2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00160.H\u0092@\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0012J\u0016\u00101\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0092@\u00a2\u0006\u0002\u0010(J\u0018\u00102\u001a\u0002032\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u00104\u001a\u000203H\u0016JN\u00105\u001a\b\u0012\u0004\u0012\u0002H60\u0018\"\u0004\b\u0000\u00107\"\u0004\b\u0001\u00106*\b\u0012\u0004\u0012\u0002H7082\"\u00109\u001a\u001e\b\u0001\u0012\u0004\u0012\u0002H7\u0012\n\u0012\b\u0012\u0004\u0012\u0002H60;\u0012\u0006\u0012\u0004\u0018\u00010<0:H\u0096@\u00a2\u0006\u0002\u0010=R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/kuali/research/pdf/job/JobServiceImpl;", "Lorg/kuali/research/pdf/job/JobService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "tenancyService", "Lorg/kuali/research/pdf/sys/tenancy/TenancyService;", "actionServiceRegistry", "Lorg/kuali/research/pdf/action/ActionServiceRegistry;", "jobRepository", "Lorg/kuali/research/pdf/job/repository/JobRepository;", "<init>", "(Lorg/kuali/research/pdf/sys/tenancy/TenancyService;Lorg/kuali/research/pdf/action/ActionServiceRegistry;Lorg/kuali/research/pdf/job/repository/JobRepository;)V", "getTenancyService", "()Lorg/kuali/research/pdf/sys/tenancy/TenancyService;", "getActionServiceRegistry", "()Lorg/kuali/research/pdf/action/ActionServiceRegistry;", "getJobRepository", "()Lorg/kuali/research/pdf/job/repository/JobRepository;", "jobScope", "Lkotlinx/coroutines/CoroutineScope;", "fetch", "Lorg/kuali/research/pdf/job/Job;", "jobId", "", "fetchAll", "", "submit", "job", "receive", "(Lorg/kuali/research/pdf/job/Job;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchActionId", "T", "Lorg/kuali/research/pdf/action/Action;", "action", "(Lorg/kuali/research/pdf/action/Action;)Ljava/lang/String;", "process", "preValidate", "containsActions", "", "nonUniqueActionIds", "executeActions", "(Lorg/kuali/research/pdf/job/Job;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeActionsInParallel", "", "unprocessed", "processed", "actionGraph", "Lcom/google/common/graph/Graph;", "(Ljava/util/Map;Ljava/util/Map;Lcom/google/common/graph/Graph;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "postValidate", "finalize", "determineJobStatus", "Lorg/kuali/research/pdf/sys/model/Status;", "proposedStatus", "pmap", "B", "A", "", "f", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "(Ljava/lang/Iterable;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pdf"})
@SourceDebugExtension(value={"SMAP\nJobServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JobServiceImpl.kt\norg/kuali/research/pdf/job/JobServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,283:1\n1563#2:284\n1634#2,3:285\n1563#2:289\n1634#2,3:290\n1491#2:293\n1516#2,3:294\n1519#2,3:304\n1563#2:314\n1634#2,3:315\n1208#2,2:318\n1236#2,4:320\n3301#2,10:324\n1193#2,2:334\n1267#2,4:336\n1563#2:340\n1634#2,3:341\n774#2:344\n865#2,2:345\n1761#2,3:347\n1#3:288\n382#4,7:297\n536#4:307\n521#4,6:308\n*S KotlinDebug\n*F\n+ 1 JobServiceImpl.kt\norg/kuali/research/pdf/job/JobServiceImpl\n*L\n70#1:284\n70#1:285,3\n131#1:289\n131#1:290,3\n152#1:293\n152#1:294,3\n152#1:304,3\n156#1:314\n156#1:315,3\n170#1:318,2\n170#1:320,4\n183#1:324,10\n196#1:334,2\n196#1:336,4\n211#1:340\n211#1:341,3\n233#1:344\n233#1:345,2\n267#1:347,3\n152#1:297,7\n152#1:307\n152#1:308,6\n*E\n"})
public class JobServiceImpl
implements JobService,
Logging {
    @NotNull
    private final TenancyService tenancyService;
    @NotNull
    private final ActionServiceRegistry actionServiceRegistry;
    @NotNull
    private final JobRepository jobRepository;
    @NotNull
    private final CoroutineScope jobScope;

    public JobServiceImpl(@Autowired @NotNull TenancyService tenancyService, @Autowired @NotNull ActionServiceRegistry actionServiceRegistry, @Autowired @NotNull JobRepository jobRepository) {
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        Intrinsics.checkNotNullParameter((Object)actionServiceRegistry, (String)"actionServiceRegistry");
        Intrinsics.checkNotNullParameter((Object)jobRepository, (String)"jobRepository");
        this.tenancyService = tenancyService;
        this.actionServiceRegistry = actionServiceRegistry;
        this.jobRepository = jobRepository;
        this.jobScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getDefault().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
    }

    @NotNull
    public TenancyService getTenancyService() {
        return this.tenancyService;
    }

    @NotNull
    public ActionServiceRegistry getActionServiceRegistry() {
        return this.actionServiceRegistry;
    }

    @NotNull
    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    @Override
    @Nullable
    public Job fetch(@NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        return this.getJobRepository().findById(jobId).orElse(null);
    }

    @Override
    @NotNull
    public List<Job> fetchAll() {
        List list = this.getJobRepository().findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAll(...)");
        return list;
    }

    @Override
    @Cacheable(cacheNames={"jobs"}, key="#job.cacheKey()")
    @NotNull
    public String submit(@NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String jobId = string;
        String sigil = this.getTenancyService().getTenantSigil();
        BuildersKt.launch$default((CoroutineScope)this.jobScope, (CoroutineContext)((CoroutineContext)this.getTenancyService().asContextElement(sigil)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, job, jobId, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ JobServiceImpl this$0;
            final /* synthetic */ Job $job;
            final /* synthetic */ String $jobId;
            {
                this.this$0 = $receiver;
                this.$job = $job;
                this.$jobId = $jobId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = JobServiceImpl.access$receive(this.this$0, this.$job, this.$jobId, (Continuation)this);
                        ** if (v0 != var7_2) goto lbl11
lbl10:
                        // 1 sources

                        return var7_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        received = (Job)v0;
                        var5_5 = this.this$0;
                        var4_6 = this.this$0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)received);
                        this.L$1 = var4_6;
                        this.L$2 = var5_5;
                        this.label = 2;
                        v1 = JobServiceImpl.access$executeActions(this.this$0, JobServiceImpl.access$preValidate(this.this$0, JobServiceImpl.access$process(this.this$0, received)), (Continuation)this);
                        ** if (v1 != var7_2) goto lbl27
lbl26:
                        // 1 sources

                        return var7_2;
lbl27:
                        // 1 sources

                        ** GOTO lbl36
                    }
                    case 2: {
                        var5_5 = (JobServiceImpl)this.L$2;
                        var4_6 = (JobServiceImpl)this.L$1;
                        received = (Job)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl36:
                        // 2 sources

                        var6_7 = v1;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)received);
                        this.L$1 = null;
                        this.L$2 = null;
                        this.label = 3;
                        v2 = JobServiceImpl.access$finalize(var4_6, JobServiceImpl.access$postValidate(var5_5, (Job)var6_7), (Continuation)this);
                        ** if (v2 != var7_2) goto lbl44
lbl43:
                        // 1 sources

                        return var7_2;
lbl44:
                        // 1 sources

                        ** GOTO lbl54
                    }
                    case 3: {
                        received = (Job)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                        }
                        catch (Exception e) {
                            this.this$0.getLogger().error((CharSequence)("Job processing failed for jobId: " + this.$jobId), (Throwable)e);
                        }
lbl54:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return jobId;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Object receive(Job job, String jobId, Continuation<? super Job> $completion) {
        if (!($completion instanceof receive.1)) ** GOTO lbl-1000
        var23_4 = $completion;
        if ((var23_4.label & -2147483648) != 0) {
            var23_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ JobServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JobServiceImpl.access$receive(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var24_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 /* !! */  = this.determineJobStatus(job, Status.PENDING);
                v0 = LocalDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"now(...)");
                var6_9 = v0;
                var7_11 = CollectionsKt.plus((Collection)job.getMessages(), (Object)Message.Companion.info$default(Message.Companion, "Job " + job.getJobId() + " received", "job.received", null, 4, null));
                $this$map$iv = job.getActions();
                $i$f$map = false;
                var11_15 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var16_20 = (Action)item$iv$iv;
                    var18_22 = destination$iv$iv;
                    $i$a$-map-JobServiceImpl$receive$receivedJob$1 = false;
                    var18_22.add(a.copyWith(jobId, this.fetchActionId(a)));
                }
                var8_23 = (List)destination$iv$iv;
                it /* !! */  = var5_7 /* !! */  = Job.copy$default(job, jobId, false, var8_23, var5_7 /* !! */ , var6_9, var7_11, 2, null);
                $i$a$-also-JobServiceImpl$receive$receivedJob$2 = false;
                this.getJobRepository().save((Object)it /* !! */ );
                receivedJob = var5_7 /* !! */ ;
                var20_25 = 0;
                var19_26 = null;
                var18_22 = receivedJob;
                $continuation.L$0 = job;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)jobId);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)receivedJob);
                $continuation.L$3 = var18_22;
                $continuation.I$0 = var20_25;
                $continuation.label = 1;
                v1 = this.pmap((Iterable)receivedJob.getActions(), (Function2<? super A, ? super Continuation<? super B>, ? extends Object>)((Function2)new Function2<Action<?>, Continuation<? super Action<?>>, Object>(this, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ JobServiceImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        Action action = (Action)this.L$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void it;
                                ResultKt.throwOnFailure((Object)$result);
                                return this.this$0.getActionServiceRegistry().find(Reflection.getOrCreateKotlinClass(it.getClass())).init(it);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(Action<?> p1, Continuation<? super Action<?>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super List<? extends B>>)$continuation);
                ** if (v1 != var24_6) goto lbl49
lbl48:
                // 1 sources

                return var24_6;
lbl49:
                // 1 sources

                ** GOTO lbl61
            }
            case 1: {
                var20_25 = $continuation.I$0;
                var19_26 = null;
                var18_22 = (Job)$continuation.L$3;
                receivedJob = (Job)$continuation.L$2;
                jobId = (String)$continuation.L$1;
                job = (Job)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl61:
                    // 2 sources

                    var21_27 = v1;
                    it /* !! */  = var5_7 /* !! */  = Job.copy$default((Job)var18_22, var19_26, var20_25 != 0, (List)var21_27, null, null, null, 59, null);
                    $i$a$-also-JobServiceImpl$receive$3 = false;
                    this.getJobRepository().save((Object)it /* !! */ );
                    var4_24 /* !! */  = var5_7 /* !! */ ;
                }
                catch (Exception e) {
                    this.getLogger().error((CharSequence)("Job " + job.getJobId() + " failed"), (Throwable)e);
                    v2 = this.determineJobStatus(job, Status.FAIL);
                    v3 = LocalDateTime.now();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"now(...)");
                    v4 = job.getMessages();
                    v5 = e.getMessage();
                    if (v5 == null) {
                        v5 = "unknown";
                    }
                    var4_24 /* !! */  = Job.copy$default(job, null, false, null, v2, v3, CollectionsKt.plus((Collection)v4, (Object)Message.Companion.error$default(Message.Companion, v5, "unknown.error", null, 4, null)), 7, null);
                }
                it = var4_24 /* !! */ ;
                $i$a$-also-JobServiceImpl$receive$4 = false;
                this.getJobRepository().save(it);
                return var4_24 /* !! */ ;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private <T extends Action<?>> String fetchActionId(T action) {
        String string;
        CharSequence charSequence = action.getActionId();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            String string2 = UUID.randomUUID().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        } else {
            String string3 = action.getActionId();
            string = string3;
            Intrinsics.checkNotNull((Object)string3);
        }
        return string;
    }

    private Job process(Job job) {
        Job job2;
        Status status = this.determineJobStatus(job, Status.PROCESSING);
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        Job it = job2 = Job.copy$default(job, null, false, null, status, localDateTime, CollectionsKt.plus((Collection)job.getMessages(), (Object)Message.Companion.info$default(Message.Companion, "Job " + job.getJobId() + " processing", "job.processing", null, 4, null)), 7, null);
        boolean bl = false;
        this.getJobRepository().save(it);
        return job2;
    }

    /*
     * WARNING - void declaration
     */
    private Job preValidate(Job job) {
        void $this$mapTo$iv$iv;
        Message jobValidateMessage = Message.Companion.info$default(Message.Companion, "Job " + job.getJobId() + " validating before execution", "job.pre.validating", null, 4, null);
        Message jobNoActionsMessage = this.containsActions(job) ? null : Message.Companion.warn$default(Message.Companion, "Job " + job.getJobId() + " does not have any actions", "job.actions.missing", null, 4, null);
        List<String> it = this.nonUniqueActionIds(job);
        boolean $i$a$-let-JobServiceImpl$preValidate$jobActionsNotUnique$22 = false;
        Message jobActionsNotUnique = it.isEmpty() ? null : Message.Companion.error$default(Message.Companion, "Job " + job.getJobId() + " contains actions with duplicate actionIds: " + it, "job.actions.not.unique", null, 4, null);
        Object object = new Message[]{jobValidateMessage, jobNoActionsMessage, jobActionsNotUnique};
        List jobMessages = CollectionsKt.plus((Collection)job.getMessages(), (Iterable)CollectionsKt.listOfNotNull((Object[])object));
        object = this.determineJobStatus(job, Status.PROCESSING);
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        LocalDateTime $i$a$-let-JobServiceImpl$preValidate$jobActionsNotUnique$22 = localDateTime;
        Iterable $this$map$iv = job.getActions();
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Action action = (Action)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object preValidate = it2.copyUpdatingProgress(Status.PROCESSING, Message.Companion.info$default(Message.Companion, "Action " + it2.getName() + " " + it2.getActionId() + " validating before execution", "action.pre.validating", null, 4, null));
            collection.add(this.getActionServiceRegistry().find(Reflection.getOrCreateKotlinClass(it2.getClass())).preValidate(preValidate));
        }
        List list = (List)destination$iv$iv;
        Object it3 = object = Job.copy$default(job, null, false, list, (Status)((Object)object), $i$a$-let-JobServiceImpl$preValidate$jobActionsNotUnique$22, jobMessages, 3, null);
        boolean bl = false;
        this.getJobRepository().save(it3);
        return object;
    }

    private boolean containsActions(Job job) {
        return !((Collection)job.getActions()).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private List<String> nonUniqueActionIds(Job job) {
        void $this$filterTo$iv$iv;
        Object element$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = job.getActions();
        boolean $i$f$groupBy = false;
        Iterable iterable2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            element$iv$iv = iterator2.next();
            Action it = (Action)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getActionId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object = element$iv$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            List v = (List)object.getValue();
            if (!(v.size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.filterNotNull((Iterable)destination$iv$iv.keySet());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Object executeActions(Job job, Continuation<? super Job> $completion) {
        if (!($completion instanceof executeActions.1)) ** GOTO lbl-1000
        var16_3 = $completion;
        if ((var16_3.label & -2147483648) != 0) {
            var16_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ JobServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JobServiceImpl.access$executeActions(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = job;
                $continuation.label = 1;
                v0 = this.executeActionsInParallel(job, (Continuation<? super Map<String, ? extends Action<?>>>)$continuation);
                if (v0 == var17_5) {
                    return var17_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                job = (Job)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                executedActionsMap = (Map)v0;
                $this$map$iv = job.getActions();
                $i$f$map = false;
                var7_10 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var12_16 = (Action)item$iv$iv;
                    var14_18 = destination$iv$iv;
                    $i$a$-map-JobServiceImpl$executeActions$executedActions$1 = false;
                    v1 = it.getActionId();
                    Intrinsics.checkNotNull((Object)v1);
                    var14_18.add((Action)MapsKt.getValue((Map)executedActionsMap, (Object)v1));
                }
                executedActions = (List)destination$iv$iv;
                var5_7 /* !! */  = this.determineJobStatus(job, job.getStatus());
                v2 = LocalDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"now(...)");
                $i$f$map = v2;
                $this$mapTo$iv$iv = CollectionsKt.plus((Collection)job.getMessages(), (Object)Message.Companion.info$default(Message.Companion, "Job " + job.getJobId() + " Actions processing", "job.actions.processing", null, 4, null));
                it /* !! */  = var5_7 /* !! */  = Job.copy$default(job, null, false, executedActions, var5_7 /* !! */ , $i$f$map, $this$mapTo$iv$iv, 3, null);
                $i$a$-also-JobServiceImpl$executeActions$2 = false;
                this.getJobRepository().save((Object)it /* !! */ );
                return var5_7 /* !! */ ;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private Object executeActionsInParallel(Job job, Continuation<? super Map<String, ? extends Action<?>>> $completion) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Iterable iterable2 = job.getActions();
        JobServiceImpl jobServiceImpl = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var6_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Action action = (Action)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = it.getActionId();
            Intrinsics.checkNotNull((Object)string);
            map.put(string, element$iv$iv);
        }
        return jobServiceImpl.executeActionsInParallel(destination$iv$iv, MapsKt.emptyMap(), job.getActionGraph(), $completion);
    }

    /*
     * Unable to fully structure code
     */
    private Object executeActionsInParallel(Map<String, ? extends Action<?>> unprocessed, Map<String, ? extends Action<?>> processed, Graph<String> actionGraph, Continuation<? super Map<String, ? extends Action<?>>> $completion) {
        if (!($completion instanceof executeActionsInParallel.3)) ** GOTO lbl-1000
        var23_5 = $completion;
        if ((var23_5.label & -2147483648) != 0) {
            var23_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                /* synthetic */ Object result;
                final /* synthetic */ JobServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JobServiceImpl.access$executeActionsInParallel(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var24_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (unprocessed.isEmpty()) {
                    return processed;
                }
                processedActionIds = processed.keySet();
                $this$partition$iv = unprocessed.entrySet();
                $i$f$partition = false;
                first$iv = new ArrayList<T>();
                second$iv = new ArrayList<E>();
                for (T element$iv : $this$partition$iv) {
                    it = (Map.Entry)element$iv;
                    $i$a$-partition-JobServiceImpl$executeActionsInParallel$4 = false;
                    if (actionGraph.predecessors(it.getKey()).isEmpty()) ** GOTO lbl-1000
                    v0 = actionGraph.predecessors(it.getKey());
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"predecessors(...)");
                    if (processedActionIds.containsAll(v0)) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
                    v2 = v1 != false ? first$iv.add(element$iv) : second$iv.add(element$iv);
                }
                var6_25 = new Pair(first$iv, second$iv);
                toProcess = (List)var6_25.component1();
                remaining = (List)var6_25.component2();
                if (unprocessed.size() == remaining.size()) {
                    throw new IllegalStateException("Actions cannot be processed");
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)unprocessed);
                $continuation.L$1 = processed;
                $continuation.L$2 = actionGraph;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)processedActionIds);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)toProcess);
                $continuation.L$5 = remaining;
                $continuation.label = 1;
                v3 = this.pmap(toProcess, (Function2<? super A, ? super Continuation<? super B>, ? extends Object>)((Function2)new Function2<Map.Entry<? extends String, ? extends Action<?>>, Continuation<? super Pair<? extends String, ? extends Action<?>>>, Object>(this, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ JobServiceImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        Map.Entry entry = (Map.Entry)this.L$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void it;
                                ResultKt.throwOnFailure((Object)$result);
                                return TuplesKt.to(it.getKey(), (Object)this.this$0.getActionServiceRegistry().find(Reflection.getOrCreateKotlinClass(it.getValue().getClass())).exec((Action)it.getValue()));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(Map.Entry<String, ? extends Action<?>> p1, Continuation<? super Pair<String, ? extends Action<?>>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super List<? extends B>>)$continuation);
                if (v3 == var24_7) {
                    return var24_7;
                }
                ** GOTO lbl56
            }
            case 1: {
                remaining = (List)$continuation.L$5;
                toProcess = (List)$continuation.L$4;
                processedActionIds = (Set)$continuation.L$3;
                actionGraph = (Graph)$continuation.L$2;
                processed = (Map)$continuation.L$1;
                unprocessed = (Map)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl56:
                // 2 sources

                newlyProcessed = MapsKt.toMap((Iterable)((Iterable)v3));
                second$iv = remaining;
                var21_26 = this;
                $i$f$associate = false;
                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                it = $this$associate$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    var18_30 = destination$iv$iv;
                    it = (Map.Entry)element$iv$iv;
                    $i$a$-associate-JobServiceImpl$executeActionsInParallel$5 = false;
                    var19_31 = TuplesKt.to(it.getKey(), it.getValue());
                    var18_30.put(var19_31.getFirst(), var19_31.getSecond());
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)unprocessed);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)processed);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)actionGraph);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)processedActionIds);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)toProcess);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)remaining);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)newlyProcessed);
                $continuation.label = 2;
                v4 = var21_26.executeActionsInParallel(destination$iv$iv, MapsKt.plus((Map)processed, (Map)newlyProcessed), (Graph<String>)actionGraph, (Continuation<? super Map<String, ? extends Action<?>>>)$continuation);
                if (v4 == var24_7) {
                    return var24_7;
                }
                ** GOTO lbl94
            }
            case 2: {
                newlyProcessed = (Map)$continuation.L$6;
                remaining = (List)$continuation.L$5;
                toProcess = (List)$continuation.L$4;
                processedActionIds = (Set)$continuation.L$3;
                actionGraph = (Graph)$continuation.L$2;
                processed = (Map)$continuation.L$1;
                unprocessed = (Map)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl94:
                // 2 sources

                return v4;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private Job postValidate(Job job) {
        void $this$mapTo$iv$iv;
        Object object = this.determineJobStatus(job, job.getStatus());
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        LocalDateTime localDateTime2 = localDateTime;
        List list = CollectionsKt.plus((Collection)job.getMessages(), (Object)Message.Companion.info$default(Message.Companion, "Job " + job.getJobId() + " validating after execution", "job.post.validating", null, 4, null));
        Iterable $this$map$iv = job.getActions();
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Action action = (Action)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object postValidate = it.copyUpdatingProgress(it.getStatus(), Message.Companion.info$default(Message.Companion, "Action " + it.getName() + " " + it.getActionId() + " validating after execution", "action.post.validating", null, 4, null));
            collection.add(this.getActionServiceRegistry().find(Reflection.getOrCreateKotlinClass(it.getClass())).postValidate(postValidate));
        }
        List list2 = (List)destination$iv$iv;
        Object it = object = Job.copy$default(job, null, false, list2, object, localDateTime2, list, 3, null);
        boolean bl = false;
        this.getJobRepository().save(it);
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private Object finalize(Job job, Continuation<? super Job> $completion) {
        if (!($completion instanceof finalize.1)) ** GOTO lbl-1000
        var19_3 = $completion;
        if ((var19_3.label & -2147483648) != 0) {
            var19_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ JobServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JobServiceImpl.access$finalize(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var20_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var16_6 = 0;
                var15_7 = null;
                var14_8 = job;
                $continuation.L$0 = job;
                $continuation.L$1 = var14_8;
                $continuation.I$0 = var16_6;
                $continuation.label = 1;
                v0 = this.pmap((Iterable)job.getActions(), (Function2<? super A, ? super Continuation<? super B>, ? extends Object>)((Function2)new Function2<Action<?>, Continuation<? super Action<?>>, Object>(this, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ JobServiceImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        Action action = (Action)this.L$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void it;
                                ResultKt.throwOnFailure((Object)$result);
                                return this.this$0.getActionServiceRegistry().find(Reflection.getOrCreateKotlinClass(it.getClass())).finalize(it);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(Action<?> p1, Continuation<? super Action<?>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super List<? extends B>>)$continuation);
                ** if (v0 != var20_5) goto lbl24
lbl23:
                // 1 sources

                return var20_5;
lbl24:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                var16_6 = $continuation.I$0;
                var15_7 = null;
                var14_8 = (Job)$continuation.L$1;
                job = (Job)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl34:
                    // 2 sources

                    var17_9 = v0;
                    finalized = Job.copy$default(var14_8, var15_7, var16_6 != 0, (List)var17_9, null, null, null, 59, null);
                    $this$filter$iv = finalized.getActions();
                    $i$f$filter = false;
                    var7_14 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Action)element$iv$iv;
                        $i$a$-filter-JobServiceImpl$finalize$failedActions$1 = false;
                        if (!(it.getStatus() == Status.FAIL)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    failedActions = (List)destination$iv$iv;
                    if (((Collection)failedActions).isEmpty() == false) {
                        v1 = this.determineJobStatus(finalized, Status.FAIL);
                        v2 = LocalDateTime.now();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"now(...)");
                        v3 = Job.copy$default(finalized, null, false, null, v1, v2, CollectionsKt.plus((Collection)finalized.getMessages(), (Object)Message.Companion.error$default(Message.Companion, "Job " + finalized.getJobId() + " failed as a result of one or more failed actions " + failedActions, "job.failed", null, 4, null)), 7, null);
                    } else {
                        v4 = this.determineJobStatus(job, Status.SUCCESS);
                        v5 = LocalDateTime.now();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"now(...)");
                        v3 = Job.copy$default(finalized, null, false, null, v4, v5, CollectionsKt.plus((Collection)finalized.getMessages(), (Object)Message.Companion.info$default(Message.Companion, "Job " + finalized.getJobId() + " completed", "job.completed", null, 4, null)), 7, null);
                    }
                    var3_10 = v3;
                }
                catch (Exception e) {
                    this.getLogger().error((CharSequence)("Job " + job.getJobId() + " failed"), (Throwable)e);
                    v6 = this.determineJobStatus(job, Status.FAIL);
                    v7 = LocalDateTime.now();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"now(...)");
                    v8 = job.getMessages();
                    v9 = e.getMessage();
                    if (v9 == null) {
                        v9 = "unknown";
                    }
                    var3_10 = Job.copy$default(job, null, false, null, v6, v7, CollectionsKt.plus((Collection)v8, (Object)Message.Companion.error$default(Message.Companion, v9, "unknown.error", null, 4, null)), 7, null);
                }
                it = var3_10;
                $i$a$-also-JobServiceImpl$finalize$2 = false;
                this.getJobRepository().save(it);
                return var3_10;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Status determineJobStatus(@NotNull Job job, @NotNull Status proposedStatus) {
        Status status;
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)((Object)proposedStatus), (String)"proposedStatus");
        if (proposedStatus != Status.FAIL) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = job.getMessages();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Message it = (Message)element$iv;
                        boolean bl2 = false;
                        if (!(it.getLevel() == Level.ERROR || it.getLevel() == Level.FATAL)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl && job.getStatus() != Status.FAIL) {
                status = proposedStatus;
                return status;
            }
        }
        status = Status.FAIL;
        return status;
    }

    @Nullable
    public <A, B> Object pmap(@NotNull Iterable<? extends A> $this$pmap, @NotNull Function2<? super A, ? super Continuation<? super B>, ? extends Object> f, @NotNull Continuation<? super List<? extends B>> $completion) {
        return JobServiceImpl.pmap$suspendImpl(this, $this$pmap, f, $completion);
    }

    static /* synthetic */ <A, B> Object pmap$suspendImpl(JobServiceImpl $this, Iterable<? extends A> $receiver, Function2<? super A, ? super Continuation<? super B>, ? extends Object> f, Continuation<? super List<? extends B>> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends B>>, Object>($receiver, f, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Iterable<A> $this_pmap;
            final /* synthetic */ Function2<A, Continuation<? super B>, Object> $f;
            {
                this.$this_pmap = $receiver;
                this.$f = $f;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$coroutineScope;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        Iterable<A> iterable2 = this.$this_pmap;
                        Function2<A, Continuation<? super B>, Object> function2 = this.$f;
                        boolean $i$f$map = false;
                        void var6_7 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            void it;
                            T item$iv$iv;
                            T t = item$iv$iv = iterator2.next();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super B>, Object>(function2, it, null){
                                int label;
                                final /* synthetic */ Function2<A, Continuation<? super B>, Object> $f;
                                final /* synthetic */ A $it;
                                {
                                    this.$f = $f;
                                    this.$it = $it;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = this.$f.invoke(this.$it, (Object)((Object)this));
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super B> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null));
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                        this.label = 1;
                        Object object2 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends B>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }

    public static final /* synthetic */ Object access$receive(JobServiceImpl $this, Job job, String jobId, Continuation $completion) {
        return $this.receive(job, jobId, (Continuation<? super Job>)$completion);
    }

    public static final /* synthetic */ Object access$finalize(JobServiceImpl $this, Job job, Continuation $completion) {
        return $this.finalize(job, (Continuation<? super Job>)$completion);
    }

    public static final /* synthetic */ Job access$postValidate(JobServiceImpl $this, Job job) {
        return $this.postValidate(job);
    }

    public static final /* synthetic */ Object access$executeActions(JobServiceImpl $this, Job job, Continuation $completion) {
        return $this.executeActions(job, (Continuation<? super Job>)$completion);
    }

    public static final /* synthetic */ Job access$preValidate(JobServiceImpl $this, Job job) {
        return $this.preValidate(job);
    }

    public static final /* synthetic */ Job access$process(JobServiceImpl $this, Job job) {
        return $this.process(job);
    }

    public static final /* synthetic */ Object access$executeActionsInParallel(JobServiceImpl $this, Job job, Continuation $completion) {
        return $this.executeActionsInParallel(job, $completion);
    }

    public static final /* synthetic */ Object access$executeActionsInParallel(JobServiceImpl $this, Map unprocessed, Map processed, Graph actionGraph, Continuation $completion) {
        return $this.executeActionsInParallel(unprocessed, processed, (Graph<String>)actionGraph, $completion);
    }
}

