/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.sys.tenancy.internal.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.sys.tenancy.internal.service.MutableTenancyService;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=1)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kuali/research/pdf/sys/tenancy/internal/filter/TenancyAwareWebFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "mutableTenancyService", "Lorg/kuali/research/pdf/sys/tenancy/internal/service/MutableTenancyService;", "<init>", "(Lorg/kuali/research/pdf/sys/tenancy/internal/service/MutableTenancyService;)V", "doFilterInternal", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "pdf"})
@SourceDebugExtension(value={"SMAP\nTenancyAwareWebFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenancyAwareWebFilter.kt\norg/kuali/research/pdf/sys/tenancy/internal/filter/TenancyAwareWebFilter\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,57:1\n32#2,2:58\n*S KotlinDebug\n*F\n+ 1 TenancyAwareWebFilter.kt\norg/kuali/research/pdf/sys/tenancy/internal/filter/TenancyAwareWebFilter\n*L\n31#1:58,2\n*E\n"})
public class TenancyAwareWebFilter
extends OncePerRequestFilter {
    @NotNull
    private final MutableTenancyService mutableTenancyService;

    public TenancyAwareWebFilter(@NotNull MutableTenancyService mutableTenancyService) {
        Intrinsics.checkNotNullParameter((Object)mutableTenancyService, (String)"mutableTenancyService");
        this.mutableTenancyService = mutableTenancyService;
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
        try {
            this.logger.error((Object)"=== TenancyAwareWebFilter Debug Headers ===");
            this.logger.error((Object)("Request URL: " + request.getRequestURL()));
            this.logger.error((Object)("Server Name: " + request.getServerName()));
            this.logger.error((Object)("Server Port: " + request.getServerPort()));
            this.logger.error((Object)("Remote Addr: " + request.getRemoteAddr()));
            this.logger.error((Object)("Remote Host: " + request.getRemoteHost()));
            this.logger.error((Object)"All Headers:");
            Iterator iterator2 = request.getHeaderNames().asIterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"asIterator(...)");
            Iterator $this$forEach$iv = iterator2;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv;
            while (iterator3.hasNext()) {
                Object element$iv = iterator3.next();
                String headerName = (String)element$iv;
                boolean bl = false;
                Enumeration enumeration = request.getHeaders(headerName);
                Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getHeaders(...)");
                ArrayList arrayList = Collections.list(enumeration);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                List headerValues = arrayList;
                this.logger.error((Object)("  " + headerName + ": " + CollectionsKt.joinToString$default((Iterable)headerValues, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)));
            }
            this.logger.error((Object)"=== End Debug Headers ===");
            String string = request.getHeader("Host");
            if (string == null) {
                string = request.getServerName();
            }
            String host = string;
            this.logger.error((Object)("Final host value being used: " + host));
            Intrinsics.checkNotNull((Object)host);
            if (!this.mutableTenancyService.isValidTenantHost(host)) {
                this.mutableTenancyService.removeTenantHost();
                response.sendError(404);
                return;
            }
            this.mutableTenancyService.setTenantHost(host);
        }
        catch (Throwable t) {
            this.mutableTenancyService.removeTenantHost();
            this.logger.error((Object)t.getMessage(), t);
            response.sendError(404);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

