/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.flatten.internal;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.StampingProperties;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.flatten.internal.FlattenResponse;
import org.kuali.research.pdf.flatten.internal.FlattenService;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkService;
import org.kuali.research.pdf.sys.model.Message;
import org.kuali.research.pdf.sys.model.PdfException;
import org.kuali.research.pdf.sys.model.RequestMetaData;
import org.kuali.research.pdf.sys.model.Status;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J \u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0012J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/kuali/research/pdf/flatten/internal/FlattenServiceImpl;", "Lorg/kuali/research/pdf/flatten/internal/FlattenService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "linkService", "Lorg/kuali/research/pdf/link/LinkService;", "<init>", "(Lorg/kuali/research/pdf/link/LinkService;)V", "getLinkService", "()Lorg/kuali/research/pdf/link/LinkService;", "flatten", "Lorg/kuali/research/pdf/flatten/internal/FlattenResponse;", "source", "Lorg/kuali/research/pdf/link/Link;", "destination", "flattenResponse", "form", "Lcom/itextpdf/forms/PdfAcroForm;", "getDocumentProperties", "Lcom/itextpdf/kernel/pdf/StampingProperties;", "pdf"})
@SourceDebugExtension(value={"SMAP\nFlattenServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlattenServiceImpl.kt\norg/kuali/research/pdf/flatten/internal/FlattenServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public class FlattenServiceImpl
implements FlattenService,
Logging {
    @NotNull
    private final LinkService linkService;

    public FlattenServiceImpl(@Autowired @NotNull LinkService linkService) {
        Intrinsics.checkNotNullParameter((Object)linkService, (String)"linkService");
        this.linkService = linkService;
    }

    @NotNull
    public LinkService getLinkService() {
        return this.linkService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FlattenResponse flatten(@NotNull Link source, @NotNull Link destination) {
        Closeable closeable;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        try {
            FlattenResponse flattenResponse;
            closeable = (Closeable)new PdfReader(this.getLinkService().input(source));
            Throwable throwable = null;
            try {
                FlattenResponse flattenResponse2;
                PdfReader reader = (PdfReader)closeable;
                boolean bl = false;
                Closeable closeable2 = (Closeable)new PdfWriter(this.getLinkService().output(destination));
                Throwable throwable2 = null;
                try {
                    FlattenResponse flattenResponse3;
                    PdfWriter writer = (PdfWriter)closeable2;
                    boolean bl2 = false;
                    Closeable closeable3 = (Closeable)new PdfDocument(reader, writer, this.getDocumentProperties());
                    Throwable throwable3 = null;
                    try {
                        PdfDocument document = (PdfDocument)closeable3;
                        boolean bl3 = false;
                        PdfAcroForm pdfAcroForm = PdfAcroForm.getAcroForm((PdfDocument)document, (boolean)true);
                        Intrinsics.checkNotNullExpressionValue((Object)pdfAcroForm, (String)"getAcroForm(...)");
                        flattenResponse3 = this.flattenResponse(pdfAcroForm, source, destination);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    flattenResponse2 = flattenResponse3;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                flattenResponse = flattenResponse2;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = flattenResponse;
        }
        catch (PdfException e) {
            this.getLogger().error((CharSequence)"flattening failed", (Throwable)e);
            String string = e.getMessage();
            if (string == null) {
                string = "unknown";
            }
            closeable = new FlattenResponse(source, destination, Status.FAIL, CollectionsKt.listOf((Object)Message.Companion.fatal(string, e.getMessageKey(), e.getProps())));
        }
        catch (Exception e) {
            this.getLogger().error((CharSequence)"flattening failed", (Throwable)e);
            String string = e.getMessage();
            if (string == null) {
                string = "unknown";
            }
            closeable = new FlattenResponse(source, destination, Status.FAIL, CollectionsKt.listOf((Object)Message.Companion.fatal$default((Message.Companion)Message.Companion, (String)string, (String)"unknown.error", null, (int)4, null)));
        }
        return closeable;
    }

    private FlattenResponse flattenResponse(PdfAcroForm form, Link source, Link destination) {
        if (form.hasXfaForm()) {
            v0 = new FlattenResponse(source, destination, Status.FAIL, CollectionsKt.listOf((Object)Message.Companion.fatal$default((Message.Companion)Message.Companion, (String)"This pdf uses xfa forms.  Flattening is currently not supported.", (String)"xfa.flattening.not.supported", null, (int)4, null)));
        } else {
            form.flattenFields();
            v0 = Unit.INSTANCE;
        }
        return new FlattenResponse(source, destination, Status.SUCCESS, null, 8, null);
    }

    @NotNull
    public StampingProperties getDocumentProperties() {
        StampingProperties stampingProperties;
        StampingProperties $this$getDocumentProperties_u24lambda_u243 = stampingProperties = new StampingProperties();
        boolean bl = false;
        $this$getDocumentProperties_u24lambda_u243.setEventCountingMetaInfo((IMetaInfo)new RequestMetaData(null, null, MapsKt.emptyMap(), 3, null));
        return stampingProperties;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

