/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.authnintegration.internal.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.authnintegration.internal.filter.ResAuthnFilter;
import org.kuali.research.pdf.authnintegration.platform.ResPlatformAuthnFilterService;
import org.kuali.research.pdf.authnintegration.sp.ResSpAuthnFilterService;
import org.kuali.research.pdf.sys.tenancy.TenancyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@Order(value=2)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB5\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0001\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/kuali/research/pdf/authnintegration/internal/filter/ResAuthnFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "Lorg/apache/logging/log4j/kotlin/Logging;", "resSpAuthnFilterService", "Lorg/kuali/research/pdf/authnintegration/sp/ResSpAuthnFilterService;", "resPlatformAuthnFilterService", "Lorg/kuali/research/pdf/authnintegration/platform/ResPlatformAuthnFilterService;", "tenancyService", "Lorg/kuali/research/pdf/sys/tenancy/TenancyService;", "excludedPathPatterns", "", "", "<init>", "(Lorg/kuali/research/pdf/authnintegration/sp/ResSpAuthnFilterService;Lorg/kuali/research/pdf/authnintegration/platform/ResPlatformAuthnFilterService;Lorg/kuali/research/pdf/sys/tenancy/TenancyService;Ljava/util/Set;)V", "shouldNotFilter", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "doFilterInternal", "", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "isAuthnRequestWithRedirect", "getAuthnRequestWithRedirect", "Companion", "pdf"})
@SourceDebugExtension(value={"SMAP\nResAuthnFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResAuthnFilter.kt\norg/kuali/research/pdf/authnintegration/internal/filter/ResAuthnFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1761#2,3:87\n*S KotlinDebug\n*F\n+ 1 ResAuthnFilter.kt\norg/kuali/research/pdf/authnintegration/internal/filter/ResAuthnFilter\n*L\n32#1:87,3\n*E\n"})
public class ResAuthnFilter
extends OncePerRequestFilter
implements Logging {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResSpAuthnFilterService resSpAuthnFilterService;
    @NotNull
    private final ResPlatformAuthnFilterService resPlatformAuthnFilterService;
    @NotNull
    private final TenancyService tenancyService;
    @NotNull
    private final Set<String> excludedPathPatterns;
    @NotNull
    public static final String AUTH_PATH = "/ordain";
    @NotNull
    public static final String AUTH_RETURN_TO_PARAM = "hearth";
    @NotNull
    public static final String AUTH_RETURN_TO_ATTR = "returnUrl";

    public ResAuthnFilter(@Autowired @NotNull ResSpAuthnFilterService resSpAuthnFilterService, @Autowired @NotNull ResPlatformAuthnFilterService resPlatformAuthnFilterService, @Autowired @NotNull TenancyService tenancyService, @Value(value="${kuali.authn.excluded.path-patterns}") @NotNull Set<String> excludedPathPatterns) {
        Intrinsics.checkNotNullParameter((Object)resSpAuthnFilterService, (String)"resSpAuthnFilterService");
        Intrinsics.checkNotNullParameter((Object)resPlatformAuthnFilterService, (String)"resPlatformAuthnFilterService");
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        Intrinsics.checkNotNullParameter(excludedPathPatterns, (String)"excludedPathPatterns");
        this.resSpAuthnFilterService = resSpAuthnFilterService;
        this.resPlatformAuthnFilterService = resPlatformAuthnFilterService;
        this.tenancyService = tenancyService;
        this.excludedPathPatterns = excludedPathPatterns;
    }

    protected boolean shouldNotFilter(@NotNull HttpServletRequest request) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Iterable $this$any$iv = this.excludedPathPatterns;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = request.getRequestURI();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
                    CharSequence charSequence = string;
                    if (!new Regex(it).matches(charSequence)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
        String string = (this.isAuthnRequestWithRedirect(request) ? UriComponentsBuilder.fromPath((String)this.getAuthnRequestWithRedirect(request)) : UriComponentsBuilder.fromPath((String)request.getRequestURI()).query(request.getQueryString())).build().toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        String returnUrl = string;
        request.setAttribute(AUTH_RETURN_TO_ATTR, (Object)returnUrl);
        switch (WhenMappings.$EnumSwitchMapping$0[this.tenancyService.getExternalSystemType().ordinal()]) {
            case 1: {
                this.resSpAuthnFilterService.doFilterInternal(request, response, filterChain);
                break;
            }
            case 2: {
                this.resPlatformAuthnFilterService.doFilterInternal(request, response, filterChain);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public boolean isAuthnRequestWithRedirect(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = request.getRequestURI();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
        return StringsKt.endsWith$default((String)string, (String)AUTH_PATH, (boolean)false, (int)2, null) && request.getParameter(AUTH_RETURN_TO_PARAM) != null;
    }

    @NotNull
    public String getAuthnRequestWithRedirect(@NotNull HttpServletRequest request) {
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String redirectString = request.getParameter(AUTH_RETURN_TO_PARAM);
        try {
            URI redirect = new URI(redirectString);
            if (redirect.isAbsolute()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Redirect to absolute url is not allowed.");
            }
            string = redirect.toASCIIString();
            Intrinsics.checkNotNull((Object)string);
        }
        catch (URISyntaxException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Malformed uri", (Throwable)e);
        }
        return string;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

