/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.proposal.internal.service;

import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.grants.proposal.internal.entity.Proposal;
import org.kuali.research.grants.proposal.internal.model.ProposalUpsertDto;
import org.kuali.research.grants.proposal.internal.repository.ProposalRepository;
import org.kuali.research.grants.proposal.internal.service.ProposalService;
import org.kuali.research.grants.proposal.internal.util.Error;
import org.kuali.research.grants.sys.util.Level;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0019\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J$\u0010\u0012\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\b0\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J+\u0010\u0017\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\b0\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kuali/research/grants/proposal/internal/service/ProposalServiceImpl;", "Lorg/kuali/research/grants/proposal/internal/service/ProposalService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "repository", "Lorg/kuali/research/grants/proposal/internal/repository/ProposalRepository;", "<init>", "(Lorg/kuali/research/grants/proposal/internal/repository/ProposalRepository;)V", "getAllProposals", "", "Lorg/kuali/research/grants/proposal/internal/entity/Proposal;", "Lorg/springframework/data/domain/Page;", "pageable", "Lorg/springframework/data/domain/Pageable;", "getProposalById", "id", "Lorg/kuali/research/grants/proposal/internal/util/ProposalId;", "getProposalById-8G5Oh5Q", "(J)Lorg/kuali/research/grants/proposal/internal/entity/Proposal;", "createOrUpdateProposal", "Lkotlin/Pair;", "Lorg/kuali/research/grants/proposal/internal/util/Error;", "proposalUpsertDto", "Lorg/kuali/research/grants/proposal/internal/model/ProposalUpsertDto;", "deleteProposal", "deleteProposal-8G5Oh5Q", "(J)Lkotlin/Pair;", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nProposalServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProposalServiceImpl.kt\norg/kuali/research/grants/proposal/internal/service/ProposalServiceImpl\n+ 2 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,67:1\n30#2:68\n30#2:69\n30#2:70\n*S KotlinDebug\n*F\n+ 1 ProposalServiceImpl.kt\norg/kuali/research/grants/proposal/internal/service/ProposalServiceImpl\n*L\n43#1:68\n53#1:69\n62#1:70\n*E\n"})
public final class ProposalServiceImpl
implements ProposalService,
Logging {
    @NotNull
    private final ProposalRepository repository;

    public ProposalServiceImpl(@NotNull ProposalRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.repository = repository;
    }

    @NotNull
    public List<Proposal> getAllProposals() {
        List list = this.repository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAll(...)");
        return list;
    }

    @NotNull
    public Page<Proposal> getAllProposals(@NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.repository.findAll(pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAll(...)");
        return page;
    }

    @Nullable
    public Proposal getProposalById-8G5Oh5Q(long id) {
        Optional optional = this.repository.findById((Object)id);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findById(...)");
        return (Proposal)OptionalsKt.getOrNull((Optional)optional);
    }

    @NotNull
    public Pair<Proposal, List<Error>> createOrUpdateProposal(@NotNull ProposalUpsertDto proposalUpsertDto) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)proposalUpsertDto, (String)"proposalUpsertDto");
        Proposal proposal = new Proposal(proposalUpsertDto.getId(), proposalUpsertDto.getPrincipalInvestigator(), proposalUpsertDto.getProposalNumber(), proposalUpsertDto.getSponsorName(), proposalUpsertDto.getTitle(), null, null, null, 224, null);
        try {
            pair = TuplesKt.to((Object)this.repository.save((Object)proposal), (Object)CollectionsKt.emptyList());
        }
        catch (Exception e) {
            String message = "Failed to save proposal " + proposal + ".";
            ProposalServiceImpl $this$logger$iv = this;
            boolean $i$f$logger = false;
            LoggingFactoryKt.loggerOf(ProposalServiceImpl.class).error((CharSequence)(message + " " + e.getMessage()), (Throwable)e);
            pair = TuplesKt.to(null, (Object)CollectionsKt.listOf((Object)new Error(message, Level.SEVERE)));
        }
        return pair;
    }

    @NotNull
    public Pair<Proposal, List<Error>> deleteProposal-8G5Oh5Q(long id) {
        Pair pair;
        Optional optional = this.repository.findById((Object)id);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findById(...)");
        Proposal proposal = (Proposal)OptionalsKt.getOrNull((Optional)optional);
        if (proposal == null) {
            String message = "Failed to delete proposal with id " + id + ".";
            ProposalServiceImpl $this$logger$iv = this;
            boolean $i$f$logger = false;
            LoggingFactoryKt.loggerOf(ProposalServiceImpl.class).error((CharSequence)message);
            return TuplesKt.to(null, (Object)CollectionsKt.listOf((Object)new Error(message, Level.SEVERE)));
        }
        try {
            this.repository.delete((Object)proposal);
            pair = TuplesKt.to((Object)proposal, (Object)CollectionsKt.emptyList());
        }
        catch (Exception e) {
            String message = "Failed to delete proposal with id " + id + ".";
            ProposalServiceImpl $this$logger$iv = this;
            boolean $i$f$logger = false;
            LoggingFactoryKt.loggerOf(ProposalServiceImpl.class).error((CharSequence)(message + " " + e.getMessage()), (Throwable)e);
            pair = TuplesKt.to(null, (Object)CollectionsKt.listOf((Object)new Error(message, Level.SEVERE)));
        }
        return pair;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

