/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.ssl.internal.service;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.property.Property;
import org.kuali.research.grants.sys.property.PropertyService;
import org.kuali.research.grants.sys.ssl.TenancyAwareSslBundleLookupService;
import org.kuali.research.grants.sys.ssl.internal.service.TenancyAwareSslBundleLookupServiceImpl;
import org.kuali.research.grants.sys.tenancy.TenancyService;
import org.springframework.boot.autoconfigure.ssl.SslProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0003\u0012\u0013\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/kuali/research/grants/sys/ssl/internal/service/TenancyAwareSslBundleLookupServiceImpl;", "Lorg/kuali/research/grants/sys/ssl/TenancyAwareSslBundleLookupService;", "tenancyService", "Lorg/kuali/research/grants/sys/tenancy/TenancyService;", "propertiesService", "Lorg/kuali/research/grants/sys/property/PropertyService;", "<init>", "(Lorg/kuali/research/grants/sys/tenancy/TenancyService;Lorg/kuali/research/grants/sys/property/PropertyService;)V", "getBundle", "Lorg/springframework/boot/ssl/SslBundle;", "name", "", "sslBundles", "Lorg/springframework/boot/ssl/SslBundles;", "propValue", "property", "Lorg/kuali/research/grants/sys/property/Property;", "tenantName", "NonUpdatableBundle", "TenantSslBundles", "Companion", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nTenancyAwareSslBundleLookupServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenancyAwareSslBundleLookupServiceImpl.kt\norg/kuali/research/grants/sys/ssl/internal/service/TenancyAwareSslBundleLookupServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1193#2,2:89\n1267#2,4:91\n*S KotlinDebug\n*F\n+ 1 TenancyAwareSslBundleLookupServiceImpl.kt\norg/kuali/research/grants/sys/ssl/internal/service/TenancyAwareSslBundleLookupServiceImpl\n*L\n28#1:89,2\n28#1:91,4\n*E\n"})
public final class TenancyAwareSslBundleLookupServiceImpl
implements TenancyAwareSslBundleLookupService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TenancyService tenancyService;
    @NotNull
    private final PropertyService propertiesService;
    @NotNull
    private static final NonUpdatableBundle EMPTY = (NonUpdatableBundle)new /* Unavailable Anonymous Inner Class!! */;

    public TenancyAwareSslBundleLookupServiceImpl(@NotNull TenancyService tenancyService, @NotNull PropertyService propertiesService) {
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        Intrinsics.checkNotNullParameter((Object)propertiesService, (String)"propertiesService");
        this.tenancyService = tenancyService;
        this.propertiesService = propertiesService;
    }

    @NotNull
    public SslBundle getBundle(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        SslBundle sslBundle = this.sslBundles().getBundle(this.tenantName(name));
        Intrinsics.checkNotNullExpressionValue((Object)sslBundle, (String)"getBundle(...)");
        return sslBundle;
    }

    /*
     * WARNING - void declaration
     */
    private final SslBundles sslBundles() {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = this.propertiesService.findAll();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Property it = (Property)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getKey(), (Object)this.propValue(it));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map props = destination$iv$iv;
        ConfigurationPropertySource[] configurationPropertySourceArray = new ConfigurationPropertySource[]{new MapConfigurationPropertySource(props)};
        BindResult result = new Binder(configurationPropertySourceArray).bind("spring.ssl", SslProperties.class);
        if (!result.isBound()) {
            return (SslBundles)EMPTY;
        }
        Object object = result.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (SslBundles)new TenantSslBundles((SslProperties)object);
    }

    private final String propValue(Property property) {
        String string;
        if (property.isFile()) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            String string2 = null;
            Path path = Files.createTempFile(string2, null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
            Path file = path;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Files.write(file, property.getValue(), Arrays.copyOf(openOptionArray, openOptionArray.length));
            String string3 = file.toUri().getPath();
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        } else {
            string = StringsKt.decodeToString((byte[])property.getValue());
        }
        return string;
    }

    private final String tenantName(String name) {
        return this.tenancyService.getTenantHost() + "-" + name;
    }

    public static final /* synthetic */ NonUpdatableBundle access$getEMPTY$cp() {
        return EMPTY;
    }
}

