/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.db.internal.tenant;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.hibernate.engine.jdbc.connections.spi.AbstractDataSourceBasedMultiTenantConnectionProviderImpl;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.boot.jdbc.DataSourceBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0014J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0002H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/kuali/research/grants/sys/db/internal/tenant/SchemaMultiTenantConnectionProvider;", "Lorg/hibernate/engine/jdbc/connections/spi/AbstractDataSourceBasedMultiTenantConnectionProviderImpl;", "", "Lorg/springframework/boot/autoconfigure/orm/jpa/HibernatePropertiesCustomizer;", "anyDataSource", "Ljavax/sql/DataSource;", "dataSourceProperties", "Lorg/springframework/boot/autoconfigure/jdbc/DataSourceProperties;", "<init>", "(Ljavax/sql/DataSource;Lorg/springframework/boot/autoconfigure/jdbc/DataSourceProperties;)V", "dataSourceMap", "Ljava/util/concurrent/ConcurrentHashMap;", "getDataSourceMap", "()Ljava/util/concurrent/ConcurrentHashMap;", "customize", "", "hibernateProperties", "", "", "selectAnyDataSource", "selectDataSource", "tenantIdentifier", "research-grants-backend"})
public final class SchemaMultiTenantConnectionProvider
extends AbstractDataSourceBasedMultiTenantConnectionProviderImpl<String>
implements HibernatePropertiesCustomizer {
    @NotNull
    private final DataSource anyDataSource;
    @NotNull
    private final DataSourceProperties dataSourceProperties;
    @NotNull
    private final ConcurrentHashMap<String, DataSource> dataSourceMap;

    public SchemaMultiTenantConnectionProvider(@NotNull DataSource anyDataSource, @NotNull DataSourceProperties dataSourceProperties) {
        Intrinsics.checkNotNullParameter((Object)anyDataSource, (String)"anyDataSource");
        Intrinsics.checkNotNullParameter((Object)dataSourceProperties, (String)"dataSourceProperties");
        this.anyDataSource = anyDataSource;
        this.dataSourceProperties = dataSourceProperties;
        this.dataSourceMap = new ConcurrentHashMap();
    }

    @NotNull
    public final ConcurrentHashMap<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public void customize(@NotNull Map<String, Object> hibernateProperties) {
        Intrinsics.checkNotNullParameter(hibernateProperties, (String)"hibernateProperties");
        hibernateProperties.put("hibernate.multi_tenant_connection_provider", this);
    }

    @NotNull
    protected DataSource selectAnyDataSource() {
        return this.anyDataSource;
    }

    @NotNull
    protected DataSource selectDataSource(@NotNull String tenantIdentifier) {
        Intrinsics.checkNotNullParameter((Object)tenantIdentifier, (String)"tenantIdentifier");
        DataSource dataSource = this.dataSourceMap.computeIfAbsent(tenantIdentifier, arg_0 -> SchemaMultiTenantConnectionProvider.selectDataSource$lambda$1(arg_0 -> SchemaMultiTenantConnectionProvider.selectDataSource$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dataSource, (String)"computeIfAbsent(...)");
        return dataSource;
    }

    private static final DataSource selectDataSource$lambda$0(SchemaMultiTenantConnectionProvider this$0, String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this$0.dataSourceProperties.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        String dbUrl = StringsKt.contains$default((CharSequence)string, (CharSequence)"?", (boolean)false, (int)2, null) ? this$0.dataSourceProperties.getUrl() + "&currentSchema=" + key : this$0.dataSourceProperties.getUrl() + "?currentSchema=" + key;
        return DataSourceBuilder.create().username(this$0.dataSourceProperties.getUsername()).password(this$0.dataSourceProperties.getPassword()).url(dbUrl).build();
    }

    private static final DataSource selectDataSource$lambda$1(Function1 $tmp0, Object p0) {
        return (DataSource)$tmp0.invoke(p0);
    }
}

