/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.opportunity.internal.service;

import gov.grants.apply.system.applicantcommonelements_v1.OpportunityDetails;
import gov.nih.era.sads.types.FOAInfoType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScopeKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.grants.ggintegration.ApplicationWebServicesClient;
import org.kuali.research.grants.ggintegration.GgOpportunityPackageDetails;
import org.kuali.research.grants.ggintegration.OpportunityPackagesRestClient;
import org.kuali.research.grants.nihintegration.SubmissionAgencyDataServiceClient;
import org.kuali.research.grants.opportunity.OpportunityPackageDetailsService;
import org.kuali.research.grants.opportunity.internal.assembler.InterimOpportunityPackageDetails;
import org.kuali.research.grants.opportunity.internal.model.DataAvailability;
import org.kuali.research.grants.opportunity.internal.model.OpportunityPackageDetailsModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012JT\u0010\u0013\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u0012\u0006\u0012\u0004\u0018\u0001H\u00170\u0014\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u0001H\u00170\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u001cH\u0012JX\u0010\u001d\u001a\u0004\u0018\u00010\f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2 \u0010 \u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u0012\u0006\u0012\u0004\u0018\u00010!0\u00142 \u0010\"\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u0012\u0006\u0012\u0004\u0018\u00010#0\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/kuali/research/grants/opportunity/internal/service/OpportunityPackageDetailsServiceImpl;", "Lorg/kuali/research/grants/opportunity/OpportunityPackageDetailsService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "opportunityPackagesRestClient", "Lorg/kuali/research/grants/ggintegration/OpportunityPackagesRestClient;", "applicationWebServicesClient", "Lorg/kuali/research/grants/ggintegration/ApplicationWebServicesClient;", "submissionAgencyDataServiceClient", "Lorg/kuali/research/grants/nihintegration/SubmissionAgencyDataServiceClient;", "assembler", "Lorg/springframework/hateoas/server/RepresentationModelAssembler;", "Lorg/kuali/research/grants/opportunity/internal/assembler/InterimOpportunityPackageDetails;", "Lorg/kuali/research/grants/opportunity/internal/model/OpportunityPackageDetailsModel;", "<init>", "(Lorg/kuali/research/grants/ggintegration/OpportunityPackagesRestClient;Lorg/kuali/research/grants/ggintegration/ApplicationWebServicesClient;Lorg/kuali/research/grants/nihintegration/SubmissionAgencyDataServiceClient;Lorg/springframework/hateoas/server/RepresentationModelAssembler;)V", "getPackageDetails", "id", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchData", "Lkotlin/Pair;", "", "Lorg/kuali/research/grants/opportunity/internal/model/DataAvailability;", "T", "packageId", "dataFetcher", "Lkotlin/Function1;", "idFetcher", "Lkotlin/Function0;", "toOpportunityPackage", "ggOpportunityPackage", "Lorg/kuali/research/grants/ggintegration/GgOpportunityPackageDetails;", "detailsAndStatus", "Lgov/grants/apply/system/applicantcommonelements_v1/OpportunityDetails;", "nihDetailsAndStatus", "Lgov/nih/era/sads/types/FOAInfoType;", "research-grants-backend"})
public class OpportunityPackageDetailsServiceImpl
implements OpportunityPackageDetailsService,
Logging {
    @NotNull
    private final OpportunityPackagesRestClient opportunityPackagesRestClient;
    @NotNull
    private final ApplicationWebServicesClient applicationWebServicesClient;
    @NotNull
    private final SubmissionAgencyDataServiceClient submissionAgencyDataServiceClient;
    @NotNull
    private final RepresentationModelAssembler<InterimOpportunityPackageDetails, OpportunityPackageDetailsModel> assembler;

    public OpportunityPackageDetailsServiceImpl(@NotNull OpportunityPackagesRestClient opportunityPackagesRestClient, @NotNull ApplicationWebServicesClient applicationWebServicesClient, @NotNull SubmissionAgencyDataServiceClient submissionAgencyDataServiceClient, @NotNull RepresentationModelAssembler<InterimOpportunityPackageDetails, OpportunityPackageDetailsModel> assembler) {
        Intrinsics.checkNotNullParameter((Object)opportunityPackagesRestClient, (String)"opportunityPackagesRestClient");
        Intrinsics.checkNotNullParameter((Object)applicationWebServicesClient, (String)"applicationWebServicesClient");
        Intrinsics.checkNotNullParameter((Object)submissionAgencyDataServiceClient, (String)"submissionAgencyDataServiceClient");
        Intrinsics.checkNotNullParameter(assembler, (String)"assembler");
        this.opportunityPackagesRestClient = opportunityPackagesRestClient;
        this.applicationWebServicesClient = applicationWebServicesClient;
        this.submissionAgencyDataServiceClient = submissionAgencyDataServiceClient;
        this.assembler = assembler;
    }

    @Nullable
    public Object getPackageDetails(int id, @NotNull Continuation<? super OpportunityPackageDetailsModel> $completion) {
        return OpportunityPackageDetailsServiceImpl.getPackageDetails$suspendImpl((OpportunityPackageDetailsServiceImpl)this, (int)id, $completion);
    }

    static /* synthetic */ Object getPackageDetails$suspendImpl(OpportunityPackageDetailsServiceImpl $this, int id, Continuation<? super OpportunityPackageDetailsModel> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), $completion);
    }

    private <T> Pair<Pair<String, DataAvailability>, T> fetchData(String packageId, Function1<? super String, ? extends T> dataFetcher, Function0<String> idFetcher) {
        Pair pair;
        try {
            Object data = dataFetcher.invoke((Object)packageId);
            pair = TuplesKt.to((Object)TuplesKt.to((Object)idFetcher.invoke(), (Object)(data != null ? DataAvailability.AVAILABLE : DataAvailability.UNAVAILABLE)), (Object)data);
        }
        catch (Throwable e) {
            this.getLogger().error((CharSequence)("Error getting data for package " + packageId), e);
            pair = TuplesKt.to((Object)TuplesKt.to((Object)idFetcher.invoke(), (Object)DataAvailability.UNKNOWN), null);
        }
        return pair;
    }

    @Nullable
    public OpportunityPackageDetailsModel toOpportunityPackage(@Nullable GgOpportunityPackageDetails ggOpportunityPackage, @NotNull Pair<? extends Pair<String, ? extends DataAvailability>, ? extends OpportunityDetails> detailsAndStatus, @NotNull Pair<? extends Pair<String, ? extends DataAvailability>, ? extends FOAInfoType> nihDetailsAndStatus) {
        Intrinsics.checkNotNullParameter(detailsAndStatus, (String)"detailsAndStatus");
        Intrinsics.checkNotNullParameter(nihDetailsAndStatus, (String)"nihDetailsAndStatus");
        return ggOpportunityPackage == null ? null : (OpportunityPackageDetailsModel)this.assembler.toModel((Object)new InterimOpportunityPackageDetails(ggOpportunityPackage, detailsAndStatus, nihDetailsAndStatus));
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }

    public static final /* synthetic */ OpportunityPackagesRestClient access$getOpportunityPackagesRestClient$p(OpportunityPackageDetailsServiceImpl $this) {
        return $this.opportunityPackagesRestClient;
    }

    public static final /* synthetic */ Pair access$fetchData(OpportunityPackageDetailsServiceImpl $this, String packageId, Function1 dataFetcher, Function0 idFetcher) {
        return $this.fetchData(packageId, dataFetcher, idFetcher);
    }

    public static final /* synthetic */ ApplicationWebServicesClient access$getApplicationWebServicesClient$p(OpportunityPackageDetailsServiceImpl $this) {
        return $this.applicationWebServicesClient;
    }

    public static final /* synthetic */ SubmissionAgencyDataServiceClient access$getSubmissionAgencyDataServiceClient$p(OpportunityPackageDetailsServiceImpl $this) {
        return $this.submissionAgencyDataServiceClient;
    }
}

