-- xml_file_id represents the xml for the opportunity package
CREATE TABLE PROP_OPP_PKG_SUBM_PACKAGE (
  id BIGSERIAL PRIMARY KEY,
  provider VARCHAR(255) NOT NULL,
  schema_url VARCHAR(255) NOT NULL,
  xml_file_id BIGINT NOT NULL UNIQUE,
  inserted_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT FK_SUBM_PACKAGE_XML_FILE FOREIGN KEY (xml_file_id) REFERENCES FILE (id)
);

CREATE TABLE PROP_OPP_PKG_SUBM_PKG_ATTACHMENT (
  id BIGSERIAL PRIMARY KEY,
  file_content_id VARCHAR(255) NOT NULL,
  attachment_file_id BIGINT NOT NULL UNIQUE,
  prop_opp_pkg_subm_package_id BIGINT NOT NULL,
  inserted_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT FK_PKG_ATTACHMENT_PACKAGE FOREIGN KEY (prop_opp_pkg_subm_package_id) REFERENCES PROP_OPP_PKG_SUBM_PACKAGE (id) ON DELETE CASCADE,
  CONSTRAINT FK_PKG_ATTACHMENT_FILE FOREIGN KEY (attachment_file_id) REFERENCES FILE (id)
);

CREATE INDEX IDX_PROP_OPP_PKG_SUBM_PKG_ATTACHMENT_PACKAGE_ID ON PROP_OPP_PKG_SUBM_PKG_ATTACHMENT (prop_opp_pkg_subm_package_id);

-- this table will contain all schemas needed for the opportunity, forms, and submission xml (header)
CREATE TABLE PROP_OPP_PKG_SUBM_PKG_SCHEMA (
  id BIGSERIAL PRIMARY KEY,
  namespace VARCHAR(255) NOT NULL,
  schema_file_id BIGINT NOT NULL UNIQUE,
  prop_opp_pkg_subm_package_id BIGINT NOT NULL,
  inserted_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT FK_PKG_SCHEMA_PACKAGE FOREIGN KEY (prop_opp_pkg_subm_package_id) REFERENCES PROP_OPP_PKG_SUBM_PACKAGE (id) ON DELETE CASCADE,
  CONSTRAINT FK_PKG_SCHEMA_FILE FOREIGN KEY (schema_file_id) REFERENCES FILE (id)
);

CREATE INDEX IDX_PROP_OPP_PKG_SUBM_PKG_SCHEMA_PACKAGE_ID ON PROP_OPP_PKG_SUBM_PKG_SCHEMA (prop_opp_pkg_subm_package_id);

CREATE TABLE INTEGRATION_ERROR (
  id BIGSERIAL PRIMARY KEY,
  call VARCHAR(255) NOT NULL,
  error_message VARCHAR(500) NOT NULL,
  inserted_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE PROP_OPP_PKG_SUBM_GG_SUBMIT_DETAILS (
  id BIGSERIAL PRIMARY KEY,
  status_detail VARCHAR(5),
  agency_notes VARCHAR(2048),
  agency_tracking_number VARCHAR(255),
  grants_gov_application_status VARCHAR(50),
  received_date_time TIMESTAMP,
  status_date_time TIMESTAMP,
  submission_title VARCHAR(500),
  gg_application_zip_id BIGINT UNIQUE,
  inserted_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT FK_OVRD_ATTACHMENT_FILE FOREIGN KEY (gg_application_zip_id) REFERENCES FILE (id)
);

CREATE TABLE PROP_OPP_PKG_SUBM_GG_SUBMIT_DETAILS_TO_INTEGRATION_ERROR (
  prop_opp_pkg_subm_gg_submit_detail_id BIGINT NOT NULL,
  integration_error_id BIGINT NOT NULL,
  CONSTRAINT PK_GG_SUBMIT_DETAIL_INTEGRATION_ERROR PRIMARY KEY (
    prop_opp_pkg_subm_gg_submit_detail_id,
    integration_error_id
  ),
  CONSTRAINT FK_GG_SUBMIT_DETAILS_SUBMISSION FOREIGN KEY (prop_opp_pkg_subm_gg_submit_detail_id) REFERENCES PROP_OPP_PKG_SUBM_GG_SUBMIT_DETAILS (id) ON DELETE CASCADE,
  CONSTRAINT FK_GG_SUBMIT_DETAILS_INTEGRATION_ERROR FOREIGN KEY (integration_error_id) REFERENCES INTEGRATION_ERROR (id) ON DELETE CASCADE
);

CREATE TABLE PROP_OPP_PKG_SUBM_NIH_SUBMIT_DETAILS (
  id BIGSERIAL PRIMARY KEY,
  esubmission_status_date TIMESTAMP,
  sra_contact VARCHAR(20),
  grant_status VARCHAR(50),
  tracking_number VARCHAR(50),
  po_contact VARCHAR(20),
  grant_status_date TIMESTAMP,
  irg_assignment VARCHAR(500),
  project_title VARCHAR(500),
  advisory_council_meeting_date TIMESTAMP,
  advisory_council_meeting_location VARCHAR(500),
  study_section_meeting_date TIMESTAMP,
  study_section_meeting_location VARCHAR(500),
  proposal_receipt_date TIMESTAMP,
  esubmission_status VARCHAR(50),
  accession_number VARCHAR(50),
  grant_number_activity_code VARCHAR(50),
  grant_number_phs_org_code VARCHAR(50),
  grant_number_suffix_code VARCHAR(50),
  grant_number_support_year INTEGER,
  grant_number_application_type_code VARCHAR(50),
  grant_number_serial_number INTEGER,
  grant_number_phs_org_id BIGINT,
  appl_id INTEGER,
  gms_contact VARCHAR(20),
  inserted_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE PROP_OPP_PKG_SUBM_NIH_SUBMIT_DETAILS_TO_INTEGRATION_ERROR (
  prop_opp_pkg_subm_nih_submit_detail_id BIGINT NOT NULL,
  integration_error_id BIGINT NOT NULL,
  CONSTRAINT PK_NIH_SUBMIT_DETAIL_INTEGRATION_ERROR PRIMARY KEY (
    prop_opp_pkg_subm_nih_submit_detail_id,
    integration_error_id
  ),
  CONSTRAINT FK_NIH_SUBMIT_DETAILS_SUBMISSION FOREIGN KEY (prop_opp_pkg_subm_nih_submit_detail_id) REFERENCES PROP_OPP_PKG_SUBM_NIH_SUBMIT_DETAILS (id) ON DELETE CASCADE,
  CONSTRAINT FK_NIH_SUBMIT_DETAILS_INTEGRATION_ERROR FOREIGN KEY (integration_error_id) REFERENCES INTEGRATION_ERROR (id) ON DELETE CASCADE
);

CREATE TABLE PROP_OPP_PKG_SUBMISSION (
  id BIGSERIAL PRIMARY KEY,
  prop_opp_package_id BIGINT NOT NULL UNIQUE,
  is_nih BOOLEAN NOT NULL,
  submission_status VARCHAR(50) NOT NULL,
  submitted_by VARCHAR(100) NOT NULL,
  submission_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  prop_opp_pkg_subm_package_id BIGINT NOT NULL UNIQUE,
  inserted_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT FK_SUBMISSION_PKG FOREIGN KEY (prop_opp_package_id) REFERENCES PROP_OPP_PACKAGE (id) ON DELETE CASCADE,
  CONSTRAINT FK_SUBMISSION_SUBM_PACKAGE FOREIGN KEY (prop_opp_pkg_subm_package_id) REFERENCES PROP_OPP_PKG_SUBM_PACKAGE (id)
);

CREATE TABLE PROP_OPP_PKG_SUBM_GG_SUBMIT (
  id BIGSERIAL PRIMARY KEY,
  grants_gov_tracking_number VARCHAR(20) UNIQUE,
  received_date_time TIMESTAMP,
  integration_error_id BIGINT UNIQUE,
  prop_opp_pkg_submission_id BIGINT NOT NULL UNIQUE,
  prop_opp_pkg_subm_gg_submit_detail_id BIGINT UNIQUE,
  prop_opp_pkg_subm_nih_submit_detail_id BIGINT UNIQUE,
  inserted_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT FK_GG_SUBMIT_SUBMISSION FOREIGN KEY (prop_opp_pkg_submission_id) REFERENCES PROP_OPP_PKG_SUBMISSION (id) ON DELETE CASCADE,
  CONSTRAINT FK_GG_SUBMIT_SUBMIT_DETAIL FOREIGN KEY (prop_opp_pkg_subm_gg_submit_detail_id) REFERENCES PROP_OPP_PKG_SUBM_GG_SUBMIT_DETAILS (id),
  CONSTRAINT FK_NIH_SUBMIT_SUBMIT_DETAIL FOREIGN KEY (prop_opp_pkg_subm_nih_submit_detail_id) REFERENCES PROP_OPP_PKG_SUBM_NIH_SUBMIT_DETAILS (id),
  CONSTRAINT FK_GG_SUBMIT_INTEGRATION_ERROR FOREIGN KEY (integration_error_id) REFERENCES INTEGRATION_ERROR (id)
);

CREATE TABLE PROP_OPP_PKG_SUBM_FORM (
  ID BIGSERIAL PRIMARY KEY,
  name VARCHAR(255) NOT NULL,
  form_version VARCHAR(10) NOT NULL,
  schema_url VARCHAR(255) NOT NULL,
  prop_opp_pkg_submission_id BIGINT NOT NULL,
  pdf_file_id BIGINT NOT NULL UNIQUE,
  nih_pdf_file_id BIGINT UNIQUE,
  xml_file_id BIGINT NOT NULL UNIQUE,
  inserted_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT FK_SUBM_FORM_SUBMISSION FOREIGN KEY (prop_opp_pkg_submission_id) REFERENCES PROP_OPP_PKG_SUBMISSION (id) ON DELETE CASCADE,
  CONSTRAINT FK_SUBM_FORM_PDF FOREIGN KEY (pdf_file_id) REFERENCES FILE (id),
  CONSTRAINT FK_SUBM_FORM_NIH_PDF FOREIGN KEY (nih_pdf_file_id) REFERENCES FILE (id),
  CONSTRAINT FK_SUBM_FORM_XML FOREIGN KEY (xml_file_id) REFERENCES FILE (id)
);

CREATE INDEX IDX_PROP_OPP_PKG_SUBM_FORM_SUBMISSION_ID ON PROP_OPP_PKG_SUBM_FORM (prop_opp_pkg_submission_id);
