/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.tenancy.internal.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.tenancy.internal.service.MutableTenancyService;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=1)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/kuali/research/grants/sys/tenancy/internal/filter/TenancyAwareWebFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "mutableTenancyService", "Lorg/kuali/research/grants/sys/tenancy/internal/service/MutableTenancyService;", "<init>", "(Lorg/kuali/research/grants/sys/tenancy/internal/service/MutableTenancyService;)V", "doFilterInternal", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "getHost", "", "research-grants-backend"})
public class TenancyAwareWebFilter
extends OncePerRequestFilter {
    @NotNull
    private final MutableTenancyService mutableTenancyService;

    public TenancyAwareWebFilter(@NotNull MutableTenancyService mutableTenancyService) {
        Intrinsics.checkNotNullParameter((Object)mutableTenancyService, (String)"mutableTenancyService");
        this.mutableTenancyService = mutableTenancyService;
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response2, @NotNull FilterChain filterChain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
        try {
            String host = this.getHost(request);
            if (!this.mutableTenancyService.isValidTenantHost(host)) {
                this.mutableTenancyService.removeTenantHost();
                response2.sendError(404);
                return;
            }
            this.mutableTenancyService.setTenantHost(host);
        }
        catch (Throwable t) {
            this.mutableTenancyService.removeTenantHost();
            this.logger.error((Object)t.getMessage(), t);
            response2.sendError(404);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response2);
    }

    private String getHost(HttpServletRequest request) {
        Object object;
        String forwardedHost = request.getHeader("X-Forwarded-Host");
        Object object2 = forwardedHost;
        if (!(object2 == null || StringsKt.isBlank((CharSequence)object2))) {
            object2 = new char[1];
            object2[0] = 44;
            object = ((Object)StringsKt.trim((CharSequence)((String)StringsKt.split$default((CharSequence)forwardedHost, (char[])object2, (boolean)false, (int)0, (int)6, null).get(0)))).toString();
        } else {
            object2 = request.getServerName();
            Intrinsics.checkNotNull((Object)object2);
            object = object2;
        }
        return object;
    }
}

