/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.opportunity.internal.controller;

import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty0;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.grants.ggintegration.GgAgency;
import org.kuali.research.grants.ggintegration.GgOppSearchParams;
import org.kuali.research.grants.ggintegration.GgOppSearchResults;
import org.kuali.research.grants.ggintegration.GgOpportunity;
import org.kuali.research.grants.ggintegration.GgValueLabelCount;
import org.kuali.research.grants.ggintegration.OpportunitySearchRestClient;
import org.kuali.research.grants.opportunity.Agency;
import org.kuali.research.grants.opportunity.Opportunity;
import org.kuali.research.grants.opportunity.ValueLabelCount;
import org.kuali.research.grants.opportunity.internal.controller.SearchController;
import org.kuali.research.grants.opportunity.internal.controller.util.OpportunityLinkInjector;
import org.kuali.research.grants.opportunity.internal.controller.util.OpportunitySearchSortBuilder;
import org.kuali.research.grants.sys.conversion.SafeConversionService;
import org.kuali.research.grants.sys.hateoas.ProblemBuilder;
import org.kuali.research.grants.sys.util.Level;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.mediatype.problem.Problem;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/opportunities/search"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u00002\u00020\u0001:\u000278B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u00c0\u0001\u0010\b\u001a\u00020\t2\u0010\b\u0001\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\f2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0010\b\u0001\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0010\b\u0001\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0010\b\u0001\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\f2\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0010\b\u0001\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0003\u0010\u0018\u001a\u00020\u000f2\b\b\u0003\u0010\u0019\u001a\u00020\f2\b\b\u0003\u0010\u001a\u001a\u00020\u000fH\u0097@\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0012J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020 H\u0012J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0012J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u000bH\u0012J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u000b2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u000bH\u0012J\u0010\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020+H\u0012J\u0010\u00102\u001a\u00020-2\u0006\u00103\u001a\u00020/H\u0012J\u0016\u00104\u001a\u00020\f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0012J\u0016\u00106\u001a\u00020\f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/kuali/research/grants/opportunity/internal/controller/SearchController;", "Lorg/apache/logging/log4j/kotlin/Logging;", "opportunitySearchRestClient", "Lorg/kuali/research/grants/ggintegration/OpportunitySearchRestClient;", "safeConversionService", "Lorg/kuali/research/grants/sys/conversion/SafeConversionService;", "<init>", "(Lorg/kuali/research/grants/ggintegration/OpportunitySearchRestClient;Lorg/kuali/research/grants/sys/conversion/SafeConversionService;)V", "search", "Lorg/kuali/research/grants/opportunity/internal/controller/SearchController$PagedOpportunityResults;", "agency", "", "", "cfdaNumber", "daysPosted", "", "eligibility", "fundingCategory", "fundingInstrument", "keywords", "opportunityNumber", "opportunityStatus", "pageable", "Lorg/springframework/data/domain/Pageable;", "size", "sort", "page", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/Integer;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lorg/springframework/data/domain/Pageable;ILjava/lang/String;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "searchParams", "Lorg/kuali/research/grants/opportunity/internal/controller/SearchController$SearchParams;", "toPagedOpportunityResults", "ggSearchResults", "Lorg/kuali/research/grants/ggintegration/GgOppSearchResults;", "toPagedOpportunity", "Lorg/springframework/hateoas/PagedModel;", "Lorg/kuali/research/grants/opportunity/Opportunity;", "results", "toOpportunity", "ggOpportunity", "Lorg/kuali/research/grants/ggintegration/GgOpportunity;", "toAgencies", "Lorg/kuali/research/grants/opportunity/Agency;", "ggAgencies", "Lorg/kuali/research/grants/ggintegration/GgAgency;", "toValueLabelCounts", "Lorg/kuali/research/grants/opportunity/ValueLabelCount;", "ggValueLabelCounts", "Lorg/kuali/research/grants/ggintegration/GgValueLabelCount;", "toAgency", "ggAgency", "toValueLabelCount", "ggValueLabelCount", "fromAgency", "strings", "fromStringsToSearch", "SearchParams", "PagedOpportunityResults", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nSearchController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchController.kt\norg/kuali/research/grants/opportunity/internal/controller/SearchController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,246:1\n1563#2:247\n1634#2,3:248\n1563#2:251\n1634#2,3:252\n1563#2:255\n1634#2,3:256\n1563#2:259\n1634#2,3:260\n1374#2:263\n1460#2,5:264\n774#2:269\n865#2,2:270\n1563#2:272\n1634#2,3:273\n774#2:276\n865#2,2:277\n*S KotlinDebug\n*F\n+ 1 SearchController.kt\norg/kuali/research/grants/opportunity/internal/controller/SearchController\n*L\n127#1:247\n127#1:248,3\n178#1:251\n178#1:252,3\n201#1:255\n201#1:256,3\n205#1:259\n205#1:260,3\n225#1:263\n225#1:264,5\n229#1:269\n229#1:270,2\n238#1:272\n238#1:273,3\n238#1:276\n238#1:277,2\n*E\n"})
public class SearchController
implements Logging {
    @NotNull
    private final OpportunitySearchRestClient opportunitySearchRestClient;
    @NotNull
    private final SafeConversionService safeConversionService;

    public SearchController(@NotNull OpportunitySearchRestClient opportunitySearchRestClient, @NotNull SafeConversionService safeConversionService) {
        Intrinsics.checkNotNullParameter((Object)opportunitySearchRestClient, (String)"opportunitySearchRestClient");
        Intrinsics.checkNotNullParameter((Object)safeConversionService, (String)"safeConversionService");
        this.opportunitySearchRestClient = opportunitySearchRestClient;
        this.safeConversionService = safeConversionService;
    }

    @GetMapping(value={"/"}, produces={"application/hal+json"})
    @Nullable
    public Object search(@RequestParam(name="agency", required=false) @Nullable List<String> agency, @RequestParam(name="cfdaNumber", required=false) @Nullable String cfdaNumber, @RequestParam(name="daysPosted", required=false) @Valid @Positive @Nullable Integer daysPosted, @RequestParam(name="eligibility", required=false) @Nullable List<String> eligibility, @RequestParam(name="fundingCategory", required=false) @Nullable List<String> fundingCategory, @RequestParam(name="fundingInstrument", required=false) @Nullable List<String> fundingInstrument, @RequestParam(name="keywords", required=false) @Nullable String keywords, @RequestParam(name="opportunityNumber", required=false) @Nullable String opportunityNumber, @RequestParam(name="opportunityStatus", required=false) @Nullable List<String> opportunityStatus, @PageableDefault(size=2000, page=0) @SortDefault.SortDefaults(value={@SortDefault(sort={"postedDate"}, direction=Sort.Direction.DESC)}) @NotNull Pageable pageable, @RequestParam(name="size", required=false) int size, @RequestParam(name="sort", required=false) @NotNull String sort, @RequestParam(name="page", required=false) int page, @NotNull Continuation<? super PagedOpportunityResults> $completion) {
        return SearchController.search$suspendImpl((SearchController)this, agency, (String)cfdaNumber, (Integer)daysPosted, eligibility, fundingCategory, fundingInstrument, (String)keywords, (String)opportunityNumber, opportunityStatus, (Pageable)pageable, (int)size, (String)sort, (int)page, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @GetMapping(value={"/"}, produces={"application/hal+json"})
    static /* synthetic */ Object search$suspendImpl(SearchController $this, @RequestParam(name="agency", required=false) List<String> agency, @RequestParam(name="cfdaNumber", required=false) String cfdaNumber, @RequestParam(name="daysPosted", required=false) @Valid @Positive Integer daysPosted, @RequestParam(name="eligibility", required=false) List<String> eligibility, @RequestParam(name="fundingCategory", required=false) List<String> fundingCategory, @RequestParam(name="fundingInstrument", required=false) List<String> fundingInstrument, @RequestParam(name="keywords", required=false) String keywords, @RequestParam(name="opportunityNumber", required=false) String opportunityNumber, @RequestParam(name="opportunityStatus", required=false) List<String> opportunityStatus, @PageableDefault(size=2000, page=0) @SortDefault.SortDefaults(value={@SortDefault(sort={"postedDate"}, direction=Sort.Direction.DESC)}) Pageable pageable, @RequestParam(name="size", required=false) int size, @RequestParam(name="sort", required=false) String sort, @RequestParam(name="page", required=false) int page, Continuation<? super PagedOpportunityResults> $completion) {
        if (!($completion instanceof search.1)) ** GOTO lbl-1000
        var18_15 = $completion;
        if ((var18_15.label & -2147483648) != 0) {
            var18_15.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new /* Unavailable Anonymous Inner Class!! */;
        }
        $result = $continuation.result;
        var19_17 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = agency;
                if (v0 == null) {
                    v0 = CollectionsKt.emptyList();
                }
                if ((v1 = eligibility) == null) {
                    v1 = CollectionsKt.emptyList();
                }
                if ((v2 = fundingCategory) == null) {
                    v2 = CollectionsKt.emptyList();
                }
                if ((v3 = fundingInstrument) == null) {
                    v3 = CollectionsKt.emptyList();
                }
                if ((v4 = opportunityStatus) == null) {
                    v4 = CollectionsKt.emptyList();
                }
                searchParams = new SearchParams(v0, cfdaNumber, daysPosted, v1, v2, v3, keywords, opportunityNumber, v4, pageable, size, sort, page);
                res = $this.search(searchParams);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)agency);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)cfdaNumber);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)daysPosted);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)eligibility);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)fundingCategory);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)fundingInstrument);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)keywords);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)opportunityNumber);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)opportunityStatus);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)pageable);
                $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)sort);
                $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)searchParams);
                $continuation.L$13 = res;
                $continuation.I$0 = size;
                $continuation.I$1 = page;
                $continuation.label = 1;
                v5 = OpportunityLinkInjector.INSTANCE.inject(res, searchParams, (Continuation)$continuation);
                if (v5 == var19_17) {
                    return var19_17;
                }
                ** GOTO lbl65
            }
            case 1: {
                page = $continuation.I$1;
                size = $continuation.I$0;
                res = (PagedOpportunityResults)$continuation.L$13;
                searchParams = (SearchParams)$continuation.L$12;
                sort = (String)$continuation.L$11;
                pageable = (Pageable)$continuation.L$10;
                opportunityStatus = (List)$continuation.L$9;
                opportunityNumber = (String)$continuation.L$8;
                keywords = (String)$continuation.L$7;
                fundingInstrument = (List)$continuation.L$6;
                fundingCategory = (List)$continuation.L$5;
                eligibility = (List)$continuation.L$4;
                daysPosted = (Integer)$continuation.L$3;
                cfdaNumber = (String)$continuation.L$2;
                agency = (List)$continuation.L$1;
                $this = (SearchController)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl65:
                // 2 sources

                return res;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object search$default(SearchController searchController, List list, String string, Integer n, List list2, List list3, List list4, String string2, String string3, List list5, Pageable pageable, int n2, String string4, int n3, Continuation continuation, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: search");
        }
        if ((n4 & 0x400) != 0) {
            n2 = 2000;
        }
        if ((n4 & 0x800) != 0) {
            string4 = "postedDate,desc";
        }
        if ((n4 & 0x1000) != 0) {
            n3 = 0;
        }
        return searchController.search(list, string, n, list2, list3, list4, string2, string3, list5, pageable, n2, string4, n3, continuation);
    }

    private PagedOpportunityResults search(SearchParams searchParams) {
        if (searchParams.getOpportunityStatus().isEmpty()) {
            return PagedOpportunityResults.Companion.empty(searchParams);
        }
        String string = this.fromAgency(searchParams.getAgency());
        String string2 = searchParams.getCfdaNumber();
        Object object = searchParams.getDaysPosted();
        if (object == null || (object = ((Integer)object).toString()) == null) {
            object = "";
        }
        Object object2 = object;
        String string3 = this.fromStringsToSearch(searchParams.getEligibility());
        String string4 = this.fromStringsToSearch(searchParams.getFundingCategory());
        String string5 = this.fromStringsToSearch(searchParams.getFundingInstrument());
        String string6 = searchParams.getKeywords();
        String string7 = searchParams.getOpportunityNumber();
        String string8 = this.fromStringsToSearch(searchParams.getOpportunityStatus());
        int n = (searchParams.getPageable().getPageNumber() + 1) * searchParams.getPageable().getPageSize() - searchParams.getPageable().getPageSize();
        int n2 = searchParams.getPageable().getPageSize();
        Sort sort = searchParams.getPageable().getSort();
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"getSort(...)");
        String string9 = OpportunitySearchSortBuilder.INSTANCE.fromSort(sort);
        GgOppSearchParams ggSearchParams = new GgOppSearchParams(null, false, string6, false, string7, string2, string, string9, n, n2, string3, string4, string5, (String)object2, string8, 11, null);
        GgOppSearchResults ggSearchResults = this.opportunitySearchRestClient.opportunitySearch(ggSearchParams);
        return ggSearchResults == null || ggSearchResults.getOppHits().isEmpty() ? PagedOpportunityResults.Companion.empty(searchParams) : this.toPagedOpportunityResults(ggSearchResults, searchParams);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PagedOpportunityResults toPagedOpportunityResults(@NotNull GgOppSearchResults ggSearchResults, @NotNull SearchParams searchParams) {
        Collection<Problem> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)ggSearchResults, (String)"ggSearchResults");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        Iterable iterable = ggSearchResults.getErrorMsgs();
        List list = this.toValueLabelCounts(ggSearchResults.getOppStatusOptions());
        List list2 = this.toValueLabelCounts(ggSearchResults.getDateRangeOptions());
        List list3 = this.toValueLabelCounts(ggSearchResults.getEligibilities());
        List list4 = this.toValueLabelCounts(ggSearchResults.getFundingCategories());
        List list5 = this.toValueLabelCounts(ggSearchResults.getFundingInstruments());
        List list6 = this.toAgencies(ggSearchResults.getAgencies());
        PagedModel pagedModel = this.toPagedOpportunity(ggSearchResults);
        boolean $i$f$map = false;
        void var5_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ProblemBuilder.Companion.build((String)it, Level.SEVERE));
        }
        Collection<Problem> collection2 = collection = (List)destination$iv$iv;
        List list7 = list;
        List list8 = list2;
        List list9 = list3;
        List list10 = list4;
        List list11 = list5;
        List list12 = list6;
        PagedModel pagedModel2 = pagedModel;
        return new PagedOpportunityResults(pagedModel2, list12, list11, list10, list9, list8, list7, collection2);
    }

    /*
     * WARNING - void declaration
     */
    private PagedModel<Opportunity> toPagedOpportunity(GgOppSearchResults results) {
        void $this$mapTo$iv$iv;
        int pageNumber = results.getSearchParams().getRows() >= results.getHitCount() ? 0 : (results.getStartRecord() + 1) / results.getSearchParams().getRows();
        Iterable $this$map$iv = results.getOppHits();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GgOpportunity ggOpportunity = (GgOpportunity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toOpportunity((GgOpportunity)it));
        }
        PagedModel pagedModel = PagedModel.of((Collection)((List)destination$iv$iv), (PagedModel.PageMetadata)new PagedModel.PageMetadata((long)results.getSearchParams().getRows(), (long)pageNumber, (long)results.getHitCount()));
        Intrinsics.checkNotNullExpressionValue((Object)pagedModel, (String)"of(...)");
        return pagedModel;
    }

    private Opportunity toOpportunity(GgOpportunity ggOpportunity) {
        int n = Integer.parseInt(ggOpportunity.getId());
        String string = ggOpportunity.getNumber();
        String string2 = ggOpportunity.getTitle();
        String string3 = ggOpportunity.getAgencyCode();
        String string4 = ggOpportunity.getAgency();
        LocalDate localDate = (LocalDate)this.safeConversionService.convert((KProperty0)new /* Unavailable Anonymous Inner Class!! */, (KProperty1)toOpportunity.2.INSTANCE);
        LocalDate localDate2 = (LocalDate)this.safeConversionService.convert((KProperty0)new /* Unavailable Anonymous Inner Class!! */, (KProperty1)toOpportunity.4.INSTANCE);
        String string5 = ggOpportunity.getOppStatus();
        String string6 = ggOpportunity.getDocType();
        List list = ggOpportunity.getCfdaList();
        return new Opportunity(n, string, string2, string5, string3, string4, localDate, localDate2, string6, list);
    }

    /*
     * WARNING - void declaration
     */
    private List<Agency> toAgencies(List<GgAgency> ggAgencies) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ggAgencies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GgAgency ggAgency = (GgAgency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toAgency((GgAgency)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<ValueLabelCount> toValueLabelCounts(List<GgValueLabelCount> ggValueLabelCounts) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ggValueLabelCounts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GgValueLabelCount ggValueLabelCount = (GgValueLabelCount)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toValueLabelCount((GgValueLabelCount)it));
        }
        return (List)destination$iv$iv;
    }

    private Agency toAgency(GgAgency ggAgency) {
        return new Agency(ggAgency.getValue(), ggAgency.getLabel(), ggAgency.getCount(), this.toValueLabelCounts(ggAgency.getSubAgencyOptions()));
    }

    private ValueLabelCount toValueLabelCount(GgValueLabelCount ggValueLabelCount) {
        return new ValueLabelCount(ggValueLabelCount.getValue(), ggValueLabelCount.getLabel(), ggValueLabelCount.getCount());
    }

    /*
     * WARNING - void declaration
     */
    private String fromAgency(List<String> strings) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = strings;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            String trimmed = ((Object)StringsKt.trim((CharSequence)it)).toString();
            Object[] objectArray = new String[]{trimmed, trimmed + "-*"};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cleanedStrings = (List)destination$iv$iv;
        return cleanedStrings.isEmpty() ? "" : CollectionsKt.joinToString$default((Iterable)cleanedStrings, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private String fromStringsToSearch(List<String> strings) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = strings;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cleanedStrings = (List)destination$iv$iv;
        return cleanedStrings.isEmpty() ? "" : CollectionsKt.joinToString$default((Iterable)cleanedStrings, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

