/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.resintegration.platform.auth.internal.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.resintegration.platform.auth.ResPlatformAuthFilterService;
import org.kuali.research.grants.resintegration.platform.auth.ResPlatformAuthUser;
import org.kuali.research.grants.resintegration.platform.auth.internal.client.ResPlatformAuthRestClient;
import org.kuali.research.grants.resintegration.platform.auth.internal.filter.ResPlatformAuthFilterServiceImpl;
import org.kuali.research.grants.resintegration.platform.auth.internal.service.ResPlatformMutableAuthService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u0000 #2\u00020\u0001:\u0001#B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016Jn\u0010\u0010\u001a\u00020\t2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122#\u0010\u0014\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0013\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u00152!\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\t0\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0012J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000bH\u0012J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0012J\u0012\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0012J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/kuali/research/grants/resintegration/platform/auth/internal/filter/ResPlatformAuthFilterServiceImpl;", "Lorg/kuali/research/grants/resintegration/platform/auth/ResPlatformAuthFilterService;", "resPlatformAuthRestClient", "Lorg/kuali/research/grants/resintegration/platform/auth/internal/client/ResPlatformAuthRestClient;", "resPlatformMutableAuthService", "Lorg/kuali/research/grants/resintegration/platform/auth/internal/service/ResPlatformMutableAuthService;", "<init>", "(Lorg/kuali/research/grants/resintegration/platform/auth/internal/client/ResPlatformAuthRestClient;Lorg/kuali/research/grants/resintegration/platform/auth/internal/service/ResPlatformMutableAuthService;)V", "doFilterInternal", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "doAuthorize", "tokenFetch", "Lkotlin/Function0;", "", "verificaton", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "token", "", "successResponse", "Lorg/kuali/research/grants/resintegration/platform/auth/ResPlatformAuthUser;", "resSpAuthUser", "failureResponse", "isApiCall", "getBearerToken", "getCookieToken", "redirectToLoginUrl", "returnUrl", "Companion", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nResPlatformAuthFilterServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResPlatformAuthFilterServiceImpl.kt\norg/kuali/research/grants/resintegration/platform/auth/internal/filter/ResPlatformAuthFilterServiceImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,135:1\n1310#2,2:136\n*S KotlinDebug\n*F\n+ 1 ResPlatformAuthFilterServiceImpl.kt\norg/kuali/research/grants/resintegration/platform/auth/internal/filter/ResPlatformAuthFilterServiceImpl\n*L\n119#1:136,2\n*E\n"})
public class ResPlatformAuthFilterServiceImpl
implements ResPlatformAuthFilterService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResPlatformAuthRestClient resPlatformAuthRestClient;
    @NotNull
    private final ResPlatformMutableAuthService resPlatformMutableAuthService;
    @NotNull
    public static final String RETURN_TO = "return_to";
    @NotNull
    public static final String VERIFICATION_TOKEN = "verificationToken";

    public ResPlatformAuthFilterServiceImpl(@Autowired @NotNull ResPlatformAuthRestClient resPlatformAuthRestClient, @Autowired @NotNull ResPlatformMutableAuthService resPlatformMutableAuthService) {
        Intrinsics.checkNotNullParameter((Object)resPlatformAuthRestClient, (String)"resPlatformAuthRestClient");
        Intrinsics.checkNotNullParameter((Object)resPlatformMutableAuthService, (String)"resPlatformMutableAuthService");
        this.resPlatformAuthRestClient = resPlatformAuthRestClient;
        this.resPlatformMutableAuthService = resPlatformMutableAuthService;
    }

    public void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response2, @NotNull FilterChain filterChain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
        Function1 verification = ResPlatformAuthFilterServiceImpl::doFilterInternal$lambda$0;
        Function1 successResponse = arg_0 -> ResPlatformAuthFilterServiceImpl.doFilterInternal$lambda$1(this, filterChain, request, response2, arg_0);
        Function0 failureResponse = () -> ResPlatformAuthFilterServiceImpl.doFilterInternal$lambda$2(this, response2);
        if (this.isApiCall(request)) {
            this.doAuthorize(() -> ResPlatformAuthFilterServiceImpl.doFilterInternal$lambda$3(this, request), verification, successResponse, failureResponse);
        } else {
            this.doAuthorize(() -> ResPlatformAuthFilterServiceImpl.doFilterInternal$lambda$4(this, request), arg_0 -> ResPlatformAuthFilterServiceImpl.doFilterInternal$lambda$5(request, verification, arg_0), successResponse, () -> ResPlatformAuthFilterServiceImpl.doFilterInternal$lambda$6(this, request, failureResponse, response2));
        }
    }

    private void doAuthorize(Function0<String> tokenFetch, Function1<? super String, Boolean> verificaton, Function1<? super ResPlatformAuthUser, Unit> successResponse, Function0<Unit> failureResponse) {
        String token = (String)tokenFetch.invoke();
        if (!((Boolean)verificaton.invoke((Object)token)).booleanValue()) {
            failureResponse.invoke();
        } else {
            String string = token;
            Intrinsics.checkNotNull((Object)string);
            ResPlatformAuthUser authUser = this.resPlatformAuthRestClient.current(string);
            if (authUser == null) {
                failureResponse.invoke();
            } else {
                successResponse.invoke((Object)authUser);
            }
        }
    }

    private boolean isApiCall(HttpServletRequest request) {
        String string = request.getRequestURI();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
        return StringsKt.startsWith$default((String)string, (String)"/api/", (boolean)false, (int)2, null);
    }

    private String getBearerToken(HttpServletRequest request) {
        String string = request.getHeader("Authorization");
        return string != null ? StringsKt.substringAfter$default((String)string, (String)"Bearer ", null, (int)2, null) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getCookieToken(HttpServletRequest request) {
        Cookie element$iv;
        Cookie[] cookieArray;
        block2: {
            Cookie[] cookieArray2 = request.getCookies();
            cookieArray = cookieArray2;
            if (cookieArray2 == null) return null;
            Cookie[] $this$firstOrNull$iv = cookieArray;
            boolean $i$f$firstOrNull = false;
            int n = 0;
            int n2 = $this$firstOrNull$iv.length;
            while (n < n2) {
                Cookie it = element$iv = $this$firstOrNull$iv[n];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"authToken")) {
                    ++n;
                    continue;
                }
                break block2;
            }
            return null;
        }
        Cookie cookie = element$iv;
        cookieArray = cookie;
        if (cookie == null) return null;
        String string = cookieArray.getValue();
        return string;
    }

    @NotNull
    public String redirectToLoginUrl(@NotNull String returnUrl) {
        Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)this.resPlatformAuthRestClient.serviceUri()).path("/authn/kuali/");
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder, (String)"path(...)");
        UriComponentsBuilder loginUrlBuilder = uriComponentsBuilder;
        Object[] objectArray = new Object[]{returnUrl};
        loginUrlBuilder.queryParam(RETURN_TO, objectArray);
        String string = loginUrlBuilder.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        return string;
    }

    private static final boolean doFilterInternal$lambda$0(String token) {
        CharSequence charSequence = token;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    private static final Unit doFilterInternal$lambda$1(ResPlatformAuthFilterServiceImpl this$0, FilterChain $filterChain, HttpServletRequest $request, HttpServletResponse $response, ResPlatformAuthUser authUser) {
        Intrinsics.checkNotNullParameter((Object)authUser, (String)"authUser");
        this$0.resPlatformMutableAuthService.setAuthUser(authUser);
        $filterChain.doFilter((ServletRequest)$request, (ServletResponse)$response);
        return Unit.INSTANCE;
    }

    private static final Unit doFilterInternal$lambda$2(ResPlatformAuthFilterServiceImpl this$0, HttpServletResponse $response) {
        this$0.resPlatformMutableAuthService.removeAuthUser();
        $response.sendError(401);
        return Unit.INSTANCE;
    }

    private static final String doFilterInternal$lambda$3(ResPlatformAuthFilterServiceImpl this$0, HttpServletRequest $request) {
        return this$0.getBearerToken($request);
    }

    private static final String doFilterInternal$lambda$4(ResPlatformAuthFilterServiceImpl this$0, HttpServletRequest $request) {
        return this$0.getCookieToken($request);
    }

    private static final boolean doFilterInternal$lambda$5(HttpServletRequest $request, Function1 $verification, String token) {
        String verificationToken = $request.getParameter(VERIFICATION_TOKEN);
        return (Boolean)$verification.invoke((Object)token) != false && (verificationToken == null || Intrinsics.areEqual((Object)verificationToken, (Object)$request.getSession().getAttribute(VERIFICATION_TOKEN)));
    }

    private static final Unit doFilterInternal$lambda$6(ResPlatformAuthFilterServiceImpl this$0, HttpServletRequest $request, Function0 $failureResponse, HttpServletResponse $response) {
        this$0.resPlatformMutableAuthService.removeAuthUser();
        if ($request.getParameter(VERIFICATION_TOKEN) != null) {
            $failureResponse.invoke();
        } else {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String verificationToken = string;
            $request.getSession().setAttribute(VERIFICATION_TOKEN, (Object)verificationToken);
            Object[] objectArray = new Object[]{verificationToken};
            String string2 = UriComponentsBuilder.fromPath((String)$request.getRequestURI()).query($request.getQueryString()).queryParam(VERIFICATION_TOKEN, objectArray).build().toUriString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUriString(...)");
            String returnUrl = string2;
            $response.sendRedirect(this$0.redirectToLoginUrl(returnUrl));
        }
        return Unit.INSTANCE;
    }
}

