/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.form.internal.controller;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.form.internal.model.FormDetailsModel;
import org.kuali.research.grants.form.internal.service.FormDetailsService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/forms/details"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kuali/research/grants/form/internal/controller/FormDetailsController;", "Lorg/apache/logging/log4j/kotlin/Logging;", "formDetailsService", "Lorg/kuali/research/grants/form/internal/service/FormDetailsService;", "<init>", "(Lorg/kuali/research/grants/form/internal/service/FormDetailsService;)V", "details", "Lorg/springframework/http/ResponseEntity;", "Lorg/kuali/research/grants/form/internal/model/FormDetailsModel;", "id", "", "detailsByNameAndVersion", "name", "", "version", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nFormDetailsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormDetailsController.kt\norg/kuali/research/grants/form/internal/controller/FormDetailsController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n1#2:35\n*E\n"})
public class FormDetailsController
implements Logging {
    @NotNull
    private final FormDetailsService formDetailsService;

    public FormDetailsController(@NotNull FormDetailsService formDetailsService) {
        Intrinsics.checkNotNullParameter((Object)formDetailsService, (String)"formDetailsService");
        this.formDetailsService = formDetailsService;
    }

    @GetMapping(value={"/{id:\\d+}"}, produces={"application/hal+json"})
    @NotNull
    public ResponseEntity<FormDetailsModel> details(@PathVariable(name="id", required=true) int id) {
        FormDetailsModel formDetailsModel;
        block3: {
            block2: {
                formDetailsModel = this.formDetailsService.getFormDetails(id);
                if (formDetailsModel == null) break block2;
                FormDetailsModel it = formDetailsModel;
                boolean bl = false;
                ResponseEntity responseEntity = ResponseEntity.ok((Object)it);
                formDetailsModel = responseEntity;
                if (responseEntity != null) break block3;
            }
            ResponseEntity responseEntity = ResponseEntity.notFound().build();
            formDetailsModel = responseEntity;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
        }
        return formDetailsModel;
    }

    @GetMapping(value={"/"}, produces={"application/hal+json"})
    @NotNull
    public ResponseEntity<FormDetailsModel> detailsByNameAndVersion(@RequestParam(name="name") @NotNull String name, @RequestParam(name="version") @NotNull String version) {
        ResponseEntity responseEntity;
        block3: {
            block4: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                    if (!StringsKt.isBlank((CharSequence)name) && !StringsKt.isBlank((CharSequence)version)) break block2;
                    responseEntity = ResponseEntity.notFound().build();
                    break block3;
                }
                responseEntity = this.formDetailsService.getFormDetails(name, version);
                if (responseEntity == null) break block4;
                ResponseEntity it = responseEntity;
                boolean bl = false;
                ResponseEntity responseEntity2 = ResponseEntity.ok((Object)it);
                responseEntity = responseEntity2;
                if (responseEntity2 != null) break block3;
            }
            responseEntity = ResponseEntity.notFound().build();
        }
        ResponseEntity responseEntity3 = responseEntity;
        Intrinsics.checkNotNull((Object)responseEntity3);
        return responseEntity3;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

