/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.logging;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.logging.LoggingRequestInterceptor;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0014B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/kuali/research/grants/sys/logging/LoggingRequestInterceptor;", "Lorg/springframework/http/client/ClientHttpRequestInterceptor;", "Lorg/apache/logging/log4j/kotlin/Logging;", "ignoredContentTypes", "", "Lorg/springframework/http/MediaType;", "<init>", "(Ljava/util/Set;)V", "intercept", "Lorg/springframework/http/client/ClientHttpResponse;", "request", "Lorg/springframework/http/HttpRequest;", "body", "", "execution", "Lorg/springframework/http/client/ClientHttpRequestExecution;", "traceRequest", "Lkotlin/Pair;", "traceResponse", "response", "LoggingClientHttpResponse", "research-grants-backend"})
public final class LoggingRequestInterceptor
implements ClientHttpRequestInterceptor,
Logging {
    @NotNull
    private final Set<MediaType> ignoredContentTypes;

    public LoggingRequestInterceptor(@NotNull Set<? extends MediaType> ignoredContentTypes) {
        Intrinsics.checkNotNullParameter(ignoredContentTypes, (String)"ignoredContentTypes");
        this.ignoredContentTypes = ignoredContentTypes;
    }

    @NotNull
    public ClientHttpResponse intercept(@NotNull HttpRequest request, @NotNull byte[] body, @NotNull ClientHttpRequestExecution execution) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        Pair pair = this.traceRequest(request, body);
        HttpRequest tracedRequest = (HttpRequest)pair.component1();
        byte[] tracedBody = (byte[])pair.component2();
        ClientHttpResponse clientHttpResponse = execution.execute(tracedRequest, tracedBody);
        Intrinsics.checkNotNullExpressionValue((Object)clientHttpResponse, (String)"execute(...)");
        return this.traceResponse(clientHttpResponse);
    }

    private final Pair<HttpRequest, byte[]> traceRequest(HttpRequest request, byte[] body) {
        if (this.getLogger().getDelegate().isDebugEnabled()) {
            this.getLogger().debug((CharSequence)"===========================request begin================================================");
            this.getLogger().debug((CharSequence)("URI         : " + request.getURI()));
            this.getLogger().debug((CharSequence)("Method      : " + request.getMethod()));
            this.getLogger().debug((CharSequence)("Headers     : " + request.getHeaders()));
            KotlinLogger kotlinLogger = this.getLogger();
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            kotlinLogger.debug((CharSequence)("Request body: " + new String(body, charset2)));
            this.getLogger().debug((CharSequence)"===========================request end==================================================");
        }
        return TuplesKt.to((Object)request, (Object)body);
    }

    private final ClientHttpResponse traceResponse(ClientHttpResponse response2) {
        if (this.getLogger().getDelegate().isDebugEnabled()) {
            return (ClientHttpResponse)new LoggingClientHttpResponse(response2, this.getLogger(), this.ignoredContentTypes);
        }
        return response2;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

