/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.tenancy.internal.service;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.tenancy.TenancyService;
import org.kuali.research.grants.sys.tenancy.internal.service.MutableTenancyService;
import org.kuali.research.grants.sys.tenancy.internal.service.TenancyServiceImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001aB5\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J)\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/kuali/research/grants/sys/tenancy/internal/service/TenancyServiceImpl;", "Lorg/kuali/research/grants/sys/tenancy/internal/service/MutableTenancyService;", "kualiEnvironments", "", "", "kualiSpEnvironmentSystem", "kualiPlatformEnvironmentSystem", "kualiLocalEnvironmentSystem", "<init>", "(Ljava/util/Set;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "isValidTenantHost", "", "host", "isSet", "setTenantHost", "", "removeTenantHost", "getTenantHost", "doInInternal", "R", "tenantType", "Lorg/kuali/research/grants/sys/tenancy/TenancyService$ExternalSystem;", "task", "Lkotlin/Function0;", "(Lorg/kuali/research/grants/sys/tenancy/TenancyService$ExternalSystem;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "setSystemTenantHost", "TenancyHostState", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nTenancyServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenancyServiceImpl.kt\norg/kuali/research/grants/sys/tenancy/internal/service/TenancyServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1761#2,3:69\n*S KotlinDebug\n*F\n+ 1 TenancyServiceImpl.kt\norg/kuali/research/grants/sys/tenancy/internal/service/TenancyServiceImpl\n*L\n18#1:69,3\n*E\n"})
public class TenancyServiceImpl
implements MutableTenancyService {
    @NotNull
    private final Set<String> kualiEnvironments;
    @NotNull
    private final String kualiSpEnvironmentSystem;
    @NotNull
    private final String kualiPlatformEnvironmentSystem;
    @NotNull
    private final String kualiLocalEnvironmentSystem;

    public TenancyServiceImpl(@Value(value="${kuali.environments}") @NotNull Set<String> kualiEnvironments, @Value(value="${kuali.sp.environment.system}") @NotNull String kualiSpEnvironmentSystem, @Value(value="${kuali.platform.environment.system}") @NotNull String kualiPlatformEnvironmentSystem, @Value(value="${kuali.local.environment.system}") @NotNull String kualiLocalEnvironmentSystem) {
        Intrinsics.checkNotNullParameter(kualiEnvironments, (String)"kualiEnvironments");
        Intrinsics.checkNotNullParameter((Object)kualiSpEnvironmentSystem, (String)"kualiSpEnvironmentSystem");
        Intrinsics.checkNotNullParameter((Object)kualiPlatformEnvironmentSystem, (String)"kualiPlatformEnvironmentSystem");
        Intrinsics.checkNotNullParameter((Object)kualiLocalEnvironmentSystem, (String)"kualiLocalEnvironmentSystem");
        this.kualiEnvironments = kualiEnvironments;
        this.kualiSpEnvironmentSystem = kualiSpEnvironmentSystem;
        this.kualiPlatformEnvironmentSystem = kualiPlatformEnvironmentSystem;
        this.kualiLocalEnvironmentSystem = kualiLocalEnvironmentSystem;
    }

    public boolean isValidTenantHost(@NotNull String host) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Iterable $this$any$iv = TenancyService.Companion.getDOMAIN_TO_SYSTEM().keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)host, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl && this.kualiEnvironments.contains(host);
    }

    public boolean isSet() {
        return TenancyHostState.INSTANCE.getHosts().get() != null;
    }

    public void setTenantHost(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (!this.isValidTenantHost(host)) {
            throw new IllegalArgumentException("Invalid tenant host: " + host);
        }
        TenancyHostState.INSTANCE.getHosts().set(host);
    }

    public void removeTenantHost() {
        TenancyHostState.INSTANCE.getHosts().remove();
    }

    @NotNull
    public String getTenantHost() {
        String string = (String)TenancyHostState.INSTANCE.getHosts().get();
        if (string == null) {
            throw new IllegalStateException("tenant host not set");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R doInInternal(@NotNull TenancyService.ExternalSystem tenantType, @NotNull Function0<? extends R> task) {
        Intrinsics.checkNotNullParameter((Object)tenantType, (String)"tenantType");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        if (this.isSet()) {
            String previousHost = this.getTenantHost();
            try {
                this.setSystemTenantHost(tenantType);
                Object object = task.invoke();
                return (R)object;
            }
            finally {
                this.setTenantHost(previousHost);
            }
        }
        try {
            this.setSystemTenantHost(tenantType);
            Object object = task.invoke();
            return (R)object;
        }
        finally {
            this.removeTenantHost();
        }
    }

    public void setSystemTenantHost(@NotNull TenancyService.ExternalSystem tenantType) {
        Intrinsics.checkNotNullParameter((Object)tenantType, (String)"tenantType");
        String host = switch (WhenMappings.$EnumSwitchMapping$0[tenantType.ordinal()]) {
            case 1 -> this.kualiSpEnvironmentSystem;
            case 2 -> this.kualiPlatformEnvironmentSystem;
            case 3 -> this.kualiLocalEnvironmentSystem;
            default -> throw new NoWhenBranchMatchedException();
        };
        this.setTenantHost(host);
    }
}

