/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.proposal.internal.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.proposal.internal.assembler.PropOppPackageModelAssembler;
import org.kuali.research.grants.proposal.internal.dto.PropOppPackageUpsertDto;
import org.kuali.research.grants.proposal.internal.entity.File;
import org.kuali.research.grants.proposal.internal.entity.PropOppPackage;
import org.kuali.research.grants.proposal.internal.model.PropOppPackageModel;
import org.kuali.research.grants.proposal.internal.service.PropOppPackageService;
import org.kuali.research.grants.proposal.internal.util.Error;
import org.kuali.research.grants.proposal.internal.util.PropOppPackageId;
import org.kuali.research.grants.proposal.internal.util.PropOppPackageSchemaFileId;
import org.kuali.research.grants.proposal.internal.util.PropOppPackageSchemaId;
import org.kuali.research.grants.proposal.internal.util.PropOpportunityId;
import org.kuali.research.grants.proposal.internal.util.ProposalId;
import org.kuali.research.grants.sys.hateoas.ProblemBuilder;
import org.kuali.research.grants.sys.hateoas.ProblemModel;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/proposals"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J.\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n0\t2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000eH\u0017J2\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\n0\t2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0011\u001a\u00020\u000eH\u0017J@\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\t2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0014\u001a\u00020\u000e2\b\b\u0001\u0010\u0015\u001a\u00020\u000e2\b\b\u0001\u0010\u0011\u001a\u00020\u000eH\u0017J2\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\n0\t2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0017\u001a\u00020\u0018H\u0017J2\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\n0\t2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0011\u001a\u00020\u000eH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kuali/research/grants/proposal/internal/controller/PropOppPackageController;", "", "assembler", "Lorg/kuali/research/grants/proposal/internal/assembler/PropOppPackageModelAssembler;", "propOppPackageService", "Lorg/kuali/research/grants/proposal/internal/service/PropOppPackageService;", "<init>", "(Lorg/kuali/research/grants/proposal/internal/assembler/PropOppPackageModelAssembler;Lorg/kuali/research/grants/proposal/internal/service/PropOppPackageService;)V", "getAllPropOppPackages", "Lorg/springframework/http/ResponseEntity;", "Lorg/kuali/research/grants/sys/hateoas/ProblemModel;", "Lorg/springframework/hateoas/CollectionModel;", "Lorg/kuali/research/grants/proposal/internal/model/PropOppPackageModel;", "proposalId", "", "propOpportunityId", "getPropOppPackageById", "id", "getPropOppPkgSchemaById", "", "packageId", "schemaId", "createOrUpdatePropOppPackage", "propOppPackageUpsertDto", "Lorg/kuali/research/grants/proposal/internal/dto/PropOppPackageUpsertDto;", "deletePropOppPackage", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nPropOppPackageController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropOppPackageController.kt\norg/kuali/research/grants/proposal/internal/controller/PropOppPackageController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1563#2:129\n1634#2,3:130\n1563#2:134\n1634#2,3:135\n1#3:133\n*S KotlinDebug\n*F\n+ 1 PropOppPackageController.kt\norg/kuali/research/grants/proposal/internal/controller/PropOppPackageController\n*L\n38#1:129\n38#1:130,3\n122#1:134\n122#1:135,3\n*E\n"})
public class PropOppPackageController {
    @NotNull
    private final PropOppPackageModelAssembler assembler;
    @NotNull
    private final PropOppPackageService propOppPackageService;

    public PropOppPackageController(@NotNull PropOppPackageModelAssembler assembler, @NotNull PropOppPackageService propOppPackageService) {
        Intrinsics.checkNotNullParameter((Object)assembler, (String)"assembler");
        Intrinsics.checkNotNullParameter((Object)propOppPackageService, (String)"propOppPackageService");
        this.assembler = assembler;
        this.propOppPackageService = propOppPackageService;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages"})
    @NotNull
    public ResponseEntity<ProblemModel<CollectionModel<PropOppPackageModel>>> getAllPropOppPackages(@PathVariable long proposalId, @PathVariable long propOpportunityId) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.propOppPackageService.getAllByProposalIdAndPropOpportunityId-ED88gEo(ProposalId.constructor-impl((long)proposalId), PropOpportunityId.constructor-impl((long)propOpportunityId));
        PropOppPackageModelAssembler propOppPackageModelAssembler = this.assembler;
        ProblemModel.Companion companion = ProblemModel.Companion;
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PropOppPackage propOppPackage = (PropOppPackage)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)proposalId, (Object)it));
        }
        collection = (List)destination$iv$iv;
        RepresentationModel representationModel = propOppPackageModelAssembler.toCollectionModel((Iterable)collection).add(WebMvcLinkBuilder.linkTo((Object)((PropOppPackageController)WebMvcLinkBuilder.methodOn(PropOppPackageController.class, (Object[])new Object[0])).getAllPropOppPackages(proposalId, propOpportunityId)).withSelfRel());
        Intrinsics.checkNotNullExpressionValue((Object)representationModel, (String)"add(...)");
        ResponseEntity responseEntity = ResponseEntity.ok((Object)ProblemModel.Companion.victory$default((ProblemModel.Companion)companion, (RepresentationModel)representationModel, null, (int)2, null));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @GetMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages/{id}"})
    @NotNull
    public ResponseEntity<ProblemModel<PropOppPackageModel>> getPropOppPackageById(@PathVariable long proposalId, @PathVariable long propOpportunityId, @PathVariable long id) {
        PropOppPackage propOppPackage;
        block3: {
            block2: {
                PropOppPackage propOppPackage2 = this.propOppPackageService.getPropOppPackageById-MZ9uceU(ProposalId.constructor-impl((long)proposalId), PropOpportunityId.constructor-impl((long)propOpportunityId), PropOppPackageId.constructor-impl((long)id));
                propOppPackage = propOppPackage2;
                if (propOppPackage == null) break block2;
                PropOppPackage it = propOppPackage;
                boolean bl = false;
                ResponseEntity responseEntity = ResponseEntity.ok((Object)ProblemModel.Companion.victory$default((ProblemModel.Companion)ProblemModel.Companion, (RepresentationModel)((RepresentationModel)this.assembler.toModel(TuplesKt.to((Object)proposalId, (Object)propOppPackage2))), null, (int)2, null));
                propOppPackage = responseEntity;
                if (responseEntity != null) break block3;
            }
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND)).body((Object)ProblemModel.Companion.empty());
            propOppPackage = responseEntity;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        }
        return propOppPackage;
    }

    @GetMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages/{packageId}/schemas/{schemaId}/schema-files/{id}/download"}, produces={"application/xml"})
    @NotNull
    public ResponseEntity<byte[]> getPropOppPkgSchemaById(@PathVariable long proposalId, @PathVariable long propOpportunityId, @PathVariable long packageId, @PathVariable long schemaId, @PathVariable long id) {
        File file;
        block3: {
            block2: {
                File schema = (File)this.propOppPackageService.getPropOppPkgSchemaById-KCyDLa4(ProposalId.constructor-impl((long)proposalId), PropOpportunityId.constructor-impl((long)propOpportunityId), PropOppPackageId.constructor-impl((long)packageId), PropOppPackageSchemaId.constructor-impl((long)schemaId), PropOppPackageSchemaFileId.constructor-impl((long)id)).component1();
                file = schema;
                if (file == null) break block2;
                File it = file;
                boolean bl = false;
                ResponseEntity responseEntity = ResponseEntity.ok((Object)it.getData());
                file = responseEntity;
                if (responseEntity != null) break block3;
            }
            ResponseEntity responseEntity = ResponseEntity.notFound().build();
            file = responseEntity;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
        }
        return file;
    }

    @PostMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages"})
    @NotNull
    public ResponseEntity<ProblemModel<PropOppPackageModel>> createOrUpdatePropOppPackage(@PathVariable long proposalId, @PathVariable long propOpportunityId, @RequestBody @NotNull PropOppPackageUpsertDto propOppPackageUpsertDto) {
        Intrinsics.checkNotNullParameter((Object)propOppPackageUpsertDto, (String)"propOppPackageUpsertDto");
        PropOppPackage savedPropOppPackage = this.propOppPackageService.createOrUpdatePropOppPackage-Zfh2DEQ(ProposalId.constructor-impl((long)proposalId), PropOpportunityId.constructor-impl((long)propOpportunityId), propOppPackageUpsertDto);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)ProblemModel.Companion.victory$default((ProblemModel.Companion)ProblemModel.Companion, (RepresentationModel)((RepresentationModel)this.assembler.toModel(TuplesKt.to((Object)proposalId, (Object)savedPropOppPackage))), null, (int)2, null));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages/{id}"})
    @NotNull
    public ResponseEntity<ProblemModel<PropOppPackageModel>> deletePropOppPackage(@PathVariable long proposalId, @PathVariable long propOpportunityId, @PathVariable long id) {
        PropOppPackage propOppPackage;
        block4: {
            List problems;
            block3: {
                void $this$mapTo$iv$iv;
                Pair pair = this.propOppPackageService.deletePropOppPackage-MZ9uceU(ProposalId.constructor-impl((long)proposalId), PropOpportunityId.constructor-impl((long)propOpportunityId), PropOppPackageId.constructor-impl((long)id));
                PropOppPackage deletedPackage = (PropOppPackage)pair.component1();
                List errors = (List)pair.component2();
                Iterable $this$map$iv = errors;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Error error = (Error)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(ProblemBuilder.Companion.build(it.getMessage(), it.getLevel()));
                }
                problems = (List)destination$iv$iv;
                propOppPackage = deletedPackage;
                if (propOppPackage == null) break block3;
                PropOppPackage it = propOppPackage;
                boolean bl = false;
                ResponseEntity responseEntity = ResponseEntity.ok((Object)ProblemModel.Companion.emptyVictory(problems));
                propOppPackage = responseEntity;
                if (responseEntity != null) break block4;
            }
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY)).body((Object)ProblemModel.Companion.defeat(problems));
            propOppPackage = responseEntity;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        }
        return propOppPackage;
    }
}

