/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.resintegration.platform.auth.internal.client;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.grants.resintegration.platform.auth.ResPlatformAuthUser;
import org.kuali.research.grants.resintegration.platform.auth.internal.client.ResPlatformAuthRestClient;
import org.kuali.research.grants.resintegration.platform.auth.internal.client.ResPlatformAuthRestClientImpl;
import org.kuali.research.grants.sys.Open;
import org.kuali.research.grants.sys.service.ServiceCategory;
import org.kuali.research.grants.sys.service.ServiceInfo;
import org.kuali.research.grants.sys.tenancy.TenancyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Open
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/kuali/research/grants/resintegration/platform/auth/internal/client/ResPlatformAuthRestClientImpl;", "Lorg/kuali/research/grants/resintegration/platform/auth/internal/client/ResPlatformAuthRestClient;", "Lorg/apache/logging/log4j/kotlin/Logging;", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "tenancyService", "Lorg/kuali/research/grants/sys/tenancy/TenancyService;", "<init>", "(Lorg/springframework/web/client/RestClient$Builder;Lorg/kuali/research/grants/sys/tenancy/TenancyService;)V", "getRestClientBuilder", "()Lorg/springframework/web/client/RestClient$Builder;", "current", "Lorg/kuali/research/grants/resintegration/platform/auth/ResPlatformAuthUser;", "token", "Lorg/kuali/research/grants/resintegration/platform/auth/PlatformAuthBearerToken;", "current-OKfYvj8", "(Ljava/lang/String;)Lorg/kuali/research/grants/resintegration/platform/auth/ResPlatformAuthUser;", "serviceUri", "", "isConnectedThrowing", "", "serviceInfo", "Lorg/kuali/research/grants/sys/service/ServiceInfo;", "serviceId", "research-grants-backend"})
public class ResPlatformAuthRestClientImpl
implements ResPlatformAuthRestClient,
Logging {
    @NotNull
    private final RestClient.Builder restClientBuilder;
    @NotNull
    private final TenancyService tenancyService;

    public ResPlatformAuthRestClientImpl(@Autowired @NotNull RestClient.Builder restClientBuilder, @Autowired @NotNull TenancyService tenancyService) {
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        this.restClientBuilder = restClientBuilder;
        this.tenancyService = tenancyService;
    }

    @NotNull
    public RestClient.Builder getRestClientBuilder() {
        return this.restClientBuilder;
    }

    @Cacheable(cacheNames={"platformAuthUser"}, key="#token", sync=true)
    @Nullable
    public ResPlatformAuthUser current-OKfYvj8(@NotNull String token) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        String string = UriComponentsBuilder.fromUriString((String)this.serviceUri()).path("/api/v1/users/current").build().toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        String currentUrl = string;
        try {
            stringArray = new String[]{"Bearer " + token};
            stringArray = (String[])this.getRestClientBuilder().build().get().uri(currentUrl, new Object[0]).header("Authorization", stringArray).retrieve().body(ResPlatformAuthUser.class);
        }
        catch (HttpClientErrorException.Unauthorized ex) {
            this.getLogger().debug((CharSequence)"Unauthorized request to Core Auth", (Throwable)ex);
            stringArray = null;
        }
        return stringArray;
    }

    @NotNull
    public String serviceUri() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.tenancyService.getExternalSystemType().ordinal()]) {
            case 1 -> throw new IllegalStateException(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + " is not supported in " + this.tenancyService.getExternalSystemType());
            case 2 -> this.tenancyService.getTenantHost();
            case 3 -> this.tenancyService.getTenantHost();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public boolean isConnectedThrowing() {
        String string = UriComponentsBuilder.fromUriString((String)this.serviceUri()).path("/api/v1/auth/health").build().toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        String healthUrl = string;
        return this.getRestClientBuilder().build().get().uri(healthUrl, new Object[0]).retrieve().toBodilessEntity().getStatusCode().is2xxSuccessful();
    }

    @NotNull
    public ServiceInfo serviceInfo() {
        return new ServiceInfo(this.serviceId(), "Platform Core Auth", this.isConnected(), "This is the Kuali Platform Core Auth Service.", this.serviceUri(), ServiceCategory.KUALI);
    }

    @NotNull
    public String serviceId() {
        return "PLTCOREAUTH";
    }

    @NotNull
    public KotlinLogger getLogger() {
        return ResPlatformAuthRestClient.DefaultImpls.getLogger((ResPlatformAuthRestClient)this);
    }
}

