/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.health;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.health.HealthConstants;
import org.kuali.research.grants.sys.service.StandardExternalServiceClient;
import org.kuali.research.grants.sys.tenancy.TenancyService;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/kuali/research/grants/sys/health/AbstractExternalServiceHealthCheck;", "Lorg/springframework/boot/actuate/health/AbstractHealthIndicator;", "standardExternalServiceClient", "Lorg/kuali/research/grants/sys/service/StandardExternalServiceClient;", "tenancyService", "Lorg/kuali/research/grants/sys/tenancy/TenancyService;", "<init>", "(Lorg/kuali/research/grants/sys/service/StandardExternalServiceClient;Lorg/kuali/research/grants/sys/tenancy/TenancyService;)V", "tenantType", "Lorg/kuali/research/grants/sys/tenancy/TenancyService$ExternalSystem;", "getTenantType", "()Lorg/kuali/research/grants/sys/tenancy/TenancyService$ExternalSystem;", "doHealthCheck", "", "builder", "Lorg/springframework/boot/actuate/health/Health$Builder;", "research-grants-backend"})
public abstract class AbstractExternalServiceHealthCheck
extends AbstractHealthIndicator {
    @NotNull
    private final StandardExternalServiceClient standardExternalServiceClient;
    @NotNull
    private final TenancyService tenancyService;

    public AbstractExternalServiceHealthCheck(@NotNull StandardExternalServiceClient standardExternalServiceClient, @NotNull TenancyService tenancyService) {
        Intrinsics.checkNotNullParameter((Object)standardExternalServiceClient, (String)"standardExternalServiceClient");
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        this.standardExternalServiceClient = standardExternalServiceClient;
        this.tenancyService = tenancyService;
    }

    @NotNull
    public abstract TenancyService.ExternalSystem getTenantType();

    protected void doHealthCheck(@NotNull Health.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        try {
            boolean connected = this.tenancyService.isSet() ? this.standardExternalServiceClient.isConnectedThrowing() : ((Boolean)this.tenancyService.doInInternal(this.getTenantType(), () -> AbstractExternalServiceHealthCheck.doHealthCheck$lambda$0(this))).booleanValue();
            builder.status(connected ? Status.UP : HealthConstants.INSTANCE.getDOWN_NON_FATAL());
        }
        catch (Exception e) {
            builder.withException((Throwable)e);
            builder.status(HealthConstants.INSTANCE.getDOWN_NON_FATAL());
        }
    }

    private static final boolean doHealthCheck$lambda$0(AbstractExternalServiceHealthCheck this$0) {
        return this$0.standardExternalServiceClient.isConnectedThrowing();
    }
}

