/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.jwt.internal.service;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.jwt.JwtService;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0012\u00a8\u0006\u000b"}, d2={"Lorg/kuali/research/grants/sys/jwt/internal/service/JwtServiceImpl;", "Lorg/kuali/research/grants/sys/jwt/JwtService;", "<init>", "()V", "createToken", "", "secret", "expirationSeconds", "", "createClaims", "Lcom/nimbusds/jwt/JWTClaimsSet;", "research-grants-backend"})
public class JwtServiceImpl
implements JwtService {
    @NotNull
    public String createToken(@NotNull String secret, long expirationSeconds) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        JWSHeader header = new JWSHeader(JWSAlgorithm.HS256);
        Payload payload = this.createClaims(expirationSeconds).toPayload();
        JWSSigner signer = (JWSSigner)new MACSigner(secret);
        JWSObject jwsObject = new JWSObject(header, payload);
        jwsObject.sign(signer);
        String string = jwsObject.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize(...)");
        return string;
    }

    private JWTClaimsSet createClaims(long expirationSeconds) {
        Instant now = Instant.now();
        JWTClaimsSet jWTClaimsSet = new JWTClaimsSet.Builder().expirationTime(Date.from(Instant.now().plusSeconds(expirationSeconds))).issueTime(Date.from(now)).claim("uuid", (Object)UUID.randomUUID().toString()).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"build(...)");
        return jWTClaimsSet;
    }
}

