/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2019 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.core.impl.parameter;


import org.kuali.rice.core.api.parameter.ParameterEvaluator;

/**
 * This implementation of ParameterEvaluator is returned by ParameterServiceImpl when evaluation involves a constraining value and
 * neither the allow nor deny parameter have restrictions for that value.
 */
public class AlwaysSucceedParameterEvaluatorImpl implements ParameterEvaluator {
    private static final AlwaysSucceedParameterEvaluatorImpl instance = new AlwaysSucceedParameterEvaluatorImpl();

    public static ParameterEvaluator getInstance() {
        return instance;
    }

    private AlwaysSucceedParameterEvaluatorImpl() {
    }

    public boolean constraintIsAllow() {
        return Boolean.TRUE;
    }


    public boolean evaluateAndAddError(Class businessObjectOrDocumentClass, String constrainedPropertyName, String userEditablePropertyName) {
        return evaluationSucceeds();
    }

    public boolean evaluateAndAddError(Class businessObjectOrDocumentClass, String constrainedPropertyName) {
        return evaluationSucceeds();
    }

    public boolean evaluationSucceeds() {
        return Boolean.TRUE;
    }

    public String getName() {
        return AlwaysSucceedParameterEvaluatorImpl.class.getName();
    }

    public String getParameterValuesForMessage() {
        return AlwaysSucceedParameterEvaluatorImpl.class.getName();
    }

    public String getValue() {
        return AlwaysSucceedParameterEvaluatorImpl.class.getName();
    }

    public void setConstrainedValue(String constrainedValue) {
    }
}
