/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2019 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.core.util.jaxb;

import java.io.Serializable;

/**
 * Helper interface for use with the RiceXmlStreamingList class.
 * 
 * <p>If "streaming" of child elements is desired during JAXB unmarshalling, then the parent element
 * assigns an instance of RiceXmlStreamingList to the appropriate list field/property, and gives the
 * list an implementation of this interface for the list to invoke whenever it receives a 
 * newly-unmarshalled child element. This allows the implementation to process the new element and then
 * discard it.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface RiceXmlListAdditionListener<T> extends Serializable {
    /**
     * This method is invoked whenever the associated RiceXmlStreamingList instance receives
     * a newly-unmarshalled child element.
     * 
     * @param item The unmarshalled element (or adapter-generated object) to be processed.
     */
    public void newItemAdded(T item);
}
