/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2019 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.util;

import java.util.Properties;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCachePerBrokerImpl;

public class KualiObjectCachePerBrokerImpl extends ObjectCachePerBrokerImpl {
    private static final Logger LOG = LogManager.getLogger(KualiObjectCachePerBrokerImpl.class);


    private final String brokerId;

    public KualiObjectCachePerBrokerImpl(PersistenceBroker broker, Properties prop) {
        super(broker, prop);
        brokerId = broker.getClass().getName() + "@" + broker.hashCode();

        LOG.debug("created objectCache for broker " + brokerId);
    }

    /**
     * Clear ObjectCache. I.e. remove all entries for classes and objects.
     */
    public void clear() {
        super.clear();

        LOG.debug("cleared objectCache for broker " + brokerId);
    }

    /**
     * @see org.apache.ojb.broker.cache.ObjectCachePerBrokerImpl#cache(org.apache.ojb.broker.Identity, java.lang.Object)
     */
    public void cache(Identity oid, Object obj) {
        super.cache(oid, obj);

        boolean cached = (super.lookup(oid) != null);
        LOG.debug((cached ? "cached oid " : "unable to cache oid ") + oid + " in objectCache for broker " + brokerId);
    }

    /**
     * @see org.apache.ojb.broker.cache.ObjectCachePerBrokerImpl#cacheIfNew(org.apache.ojb.broker.Identity, java.lang.Object)
     */
    public boolean cacheIfNew(Identity oid, Object obj) {
        boolean cachedIfNew = super.cacheIfNew(oid, obj);

        boolean cached = (super.lookup(oid) != null);
        LOG.debug((cached ? "cached new oid " : "unable to cache new oid ") + oid + " in objectCache for broker " + brokerId);

        return cachedIfNew;
    }

    /**
     * @see org.apache.ojb.broker.cache.ObjectCachePerBrokerImpl#lookup(org.apache.ojb.broker.Identity)
     */
    public Object lookup(Identity oid) {
        Object o = super.lookup(oid);

        LOG.debug((o != null ? "found oid " : "cannot find oid ") + oid + " in objectCache for broker " + brokerId);

        return o;
    }
}
