/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2019 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.util;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.TransactionAbortedException;
import org.apache.ojb.broker.TransactionInProgressException;
import org.apache.ojb.broker.TransactionNotInProgressException;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryIF;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;

public class KualiPersistenceBrokerImpl extends PersistenceBrokerImpl {
    private static final Logger LOG = LogManager.getLogger(KualiPersistenceBrokerImpl.class);


    private boolean fresh = true;

    public KualiPersistenceBrokerImpl(PBKey key, PersistenceBrokerFactoryIF pbf) {
        super(key, pbf);
    }

    public boolean isFresh() {
        return fresh;
    }


    /**
     * @see org.apache.ojb.broker.core.PersistenceBrokerImpl#beginTransaction()
     */
    public synchronized void beginTransaction() throws TransactionInProgressException, TransactionAbortedException {
        LOG.debug("beginning transaction for persistenceBroker " + getClass().getName() + "@" + hashCode());

        super.beginTransaction();
    }

    /**
     * @see org.apache.ojb.broker.core.PersistenceBrokerImpl#abortTransaction()
     */
    public synchronized void abortTransaction() throws TransactionNotInProgressException {
        LOG.debug("aborting transaction for persistenceBroker " + getClass().getName() + "@" + hashCode());

        super.abortTransaction();
    }

    /**
     * @see org.apache.ojb.broker.core.PersistenceBrokerImpl#commitTransaction()
     */
    public synchronized void commitTransaction() throws TransactionNotInProgressException, TransactionAbortedException {
        LOG.debug("committing transaction for persistenceBroker " + getClass().getName() + "@" + hashCode());

        super.commitTransaction();
    }

    /**
     * @see org.apache.ojb.broker.core.PersistenceBrokerImpl#close()
     */
    public boolean close() {
        LOG.debug("closing persistenceBroker " + getClass().getName() + "@" + hashCode());
        fresh = false;

        return super.close();
    }
}
