/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.parameter;

import java.util.List;
import org.kuali.rice.core.api.parameter.ParameterEvaluator;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class ParameterEvaluatorImpl
implements ParameterEvaluator {
    private static final long serialVersionUID = -758645169354452022L;
    private Parameter parameter;
    private boolean constraintIsAllow;
    private String constrainedValue;
    private List<String> values;
    private static DataDictionaryService dataDictionaryService;

    @Override
    public boolean evaluationSucceeds() {
        if (this.constraintIsAllow()) {
            return this.values.contains(this.constrainedValue);
        }
        return !this.values.contains(this.constrainedValue);
    }

    @Override
    public boolean evaluateAndAddError(Class<? extends Object> businessObjectOrDocumentClass, String constrainedPropertyName) {
        return this.evaluateAndAddError(businessObjectOrDocumentClass, constrainedPropertyName, constrainedPropertyName);
    }

    @Override
    public boolean evaluateAndAddError(Class<? extends Object> businessObjectOrDocumentClass, String constrainedPropertyName, String userEditablePropertyName) {
        if (!this.evaluationSucceeds()) {
            GlobalVariables.getMessageMap().putError(userEditablePropertyName, this.constraintIsAllow() ? "error.document.invalid.value.allowedValuesParameter" : "error.document.invalid.value.deniedValuesParameter", new String[]{this.getDataDictionaryService().getAttributeLabel(businessObjectOrDocumentClass, constrainedPropertyName), this.constrainedValue, this.toStringForMessage(), this.getParameterValuesForMessage(), this.getDataDictionaryService().getAttributeLabel(businessObjectOrDocumentClass, userEditablePropertyName)});
            return false;
        }
        return true;
    }

    @Override
    public boolean constraintIsAllow() {
        return this.constraintIsAllow;
    }

    @Override
    public String getParameterValuesForMessage() {
        return this.values.toString().replace("[", "").replace("]", "");
    }

    @Override
    public String getValue() {
        return this.parameter.getValue();
    }

    public String toString() {
        return new StringBuffer("ParameterEvaluator").append("\n\tParameter: ").append("module=").append(this.parameter.getNamespaceCode()).append(", component=").append(this.parameter.getComponentCode()).append(", name=").append(this.parameter.getName()).append(", value=").append(this.parameter.getValue()).append("\n\tConstraint Is Allow: ").append(this.constraintIsAllow).append("\n\tConstrained Value: ").append(this.constrainedValue).append("\n\tValues: ").append(this.values.toString()).toString();
    }

    private String toStringForMessage() {
        return new StringBuffer("parameter: ").append(this.parameter.getName()).append(", module: ").append(this.parameter.getNamespaceCode()).append(", component: ").append(this.parameter.getComponentCode()).toString();
    }

    public String getModuleAndComponent() {
        return this.parameter.getNamespaceCode() + ": " + this.parameter.getComponentCode();
    }

    public void setConstrainedValue(String constrainedValue) {
        this.constrainedValue = constrainedValue;
    }

    public void setConstraintIsAllow(boolean constraintIsAllow) {
        this.constraintIsAllow = constraintIsAllow;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (dataDictionaryService == null) {
            dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return dataDictionaryService;
    }
}

