/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.jaxb;

import javax.xml.bind.MarshalException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.util.jaxb.NameAndNamespacePair;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;

public class NameAndNamespacePairToKimTypeIdAdapter
extends XmlAdapter<NameAndNamespacePair, String> {
    public String unmarshal(NameAndNamespacePair v) throws Exception {
        if (v != null) {
            KimType kimType = KimApiServiceLocator.getKimTypeInfoService().findKimTypeByNameAndNamespace(v.getNamespaceCode(), new NormalizedStringAdapter().unmarshal(v.getName()));
            if (kimType == null) {
                throw new UnmarshalException("Cannot find KIM Type with namespace \"" + v.getNamespaceCode() + "\" and name \"" + v.getName() + "\"");
            }
            return kimType.getId();
        }
        return null;
    }

    public NameAndNamespacePair marshal(String v) throws Exception {
        if (v != null) {
            KimType kimType = KimApiServiceLocator.getKimTypeInfoService().getKimType(StringUtils.trim((String)v));
            if (kimType == null) {
                throw new MarshalException("Cannot find KIM Type with ID \"" + v + "\"");
            }
            return new NameAndNamespacePair(kimType.getNamespaceCode(), kimType.getName());
        }
        return null;
    }
}

