/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.jaxb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.util.jaxb.RiceXmlExportList;
import org.kuali.rice.core.util.jaxb.RiceXmlImportList;
import org.kuali.rice.core.util.jaxb.RiceXmlListAdditionListener;
import org.kuali.rice.core.util.jaxb.RiceXmlListGetterListener;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.role.RoleMemberContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.jaxb.RoleMemberXmlDTO;
import org.kuali.rice.kim.impl.jaxb.RoleXmlDTO;
import org.kuali.rice.kim.impl.jaxb.RoleXmlUtil;

@XmlTransient
public abstract class RoleMembersXmlDTO<T extends RoleMemberXmlDTO>
implements RiceXmlListAdditionListener<T>,
Serializable {
    private static final long serialVersionUID = 1L;

    public abstract List<T> getRoleMembers();

    public abstract void setRoleMembers(List<T> var1);

    void beforeUnmarshal(Unmarshaller unmarshaller, Object parent) throws UnmarshalException {
        this.setRoleMembers(new RiceXmlImportList(this));
    }

    void afterUnmarshal(Unmarshaller unmarshaller, Object parent) throws UnmarshalException {
        this.setRoleMembers(null);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="RoleMembersType", propOrder={"roleMembers"})
    public static class WithinRole
    extends RoleMembersXmlDTO<RoleMemberXmlDTO.WithinRole>
    implements RiceXmlListGetterListener<RoleMemberXmlDTO.WithinRole, String> {
        private static final long serialVersionUID = 1L;
        @XmlElement(name="roleMember")
        private List<RoleMemberXmlDTO.WithinRole> roleMembers;
        @XmlTransient
        private String roleId;
        @XmlTransient
        private Set<String> existingRoleMemberIds;

        public WithinRole() {
        }

        public WithinRole(String roleId) {
            this.roleId = roleId;
        }

        @Override
        public List<RoleMemberXmlDTO.WithinRole> getRoleMembers() {
            return this.roleMembers;
        }

        @Override
        public void setRoleMembers(List<RoleMemberXmlDTO.WithinRole> roleMembers) {
            this.roleMembers = roleMembers;
        }

        public String getRoleId() {
            return this.roleId;
        }

        @Override
        void beforeUnmarshal(Unmarshaller unmarshaller, Object parent) throws UnmarshalException {
            if (parent instanceof RoleXmlDTO) {
                RoleXmlDTO parentRole = (RoleXmlDTO)parent;
                if (!parentRole.isAlreadyPersisted()) {
                    RoleXmlUtil.validateAndPersistNewRole(parentRole);
                }
                this.roleId = parentRole.getRoleId();
            }
            this.existingRoleMemberIds = new HashSet<String>();
            super.beforeUnmarshal(unmarshaller, parent);
        }

        @Override
        void afterUnmarshal(Unmarshaller unmarshaller, Object parent) throws UnmarshalException {
            super.afterUnmarshal(unmarshaller, parent);
            if (parent instanceof RoleXmlDTO) {
                ((RoleXmlDTO)parent).setExistingRoleMemberIds(this.existingRoleMemberIds);
            }
            this.existingRoleMemberIds = null;
        }

        @Override
        public void newItemAdded(RoleMemberXmlDTO.WithinRole item) {
            try {
                this.existingRoleMemberIds.add(RoleXmlUtil.validateAndPersistNewRoleMember(item));
            }
            catch (UnmarshalException e) {
                throw new RuntimeException(e);
            }
        }

        void beforeMarshal(Marshaller marshaller) {
            List tempMembers = KimApiServiceLocator.getRoleService().findRoleMembers(QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"roleId", (Object)this.roleId)})).getResults();
            if (tempMembers != null && !tempMembers.isEmpty()) {
                ArrayList<String> roleMemberIds = new ArrayList<String>();
                for (RoleMemberContract tempMember : tempMembers) {
                    if (!tempMember.isActive(null)) continue;
                    roleMemberIds.add(tempMember.getId());
                }
                if (!roleMemberIds.isEmpty()) {
                    this.setRoleMembers((List<RoleMemberXmlDTO.WithinRole>)new RiceXmlExportList<RoleMemberXmlDTO.WithinRole, String>(roleMemberIds, this));
                }
            }
        }

        void afterMarshal(Marshaller marshaller) {
            this.setRoleMembers((List<RoleMemberXmlDTO.WithinRole>)null);
        }

        @Override
        public RoleMemberXmlDTO.WithinRole gettingNextItem(String nextItem, int index) {
            return new RoleMemberXmlDTO.WithinRole((RoleMember)KimApiServiceLocator.getRoleService().findRoleMembers(QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"roleMemberId", (Object)nextItem)})).getResults().get(0), false);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="StandaloneRoleMembersType", propOrder={"roleMembers"})
    public static class OutsideOfRole
    extends RoleMembersXmlDTO<RoleMemberXmlDTO.OutsideOfRole> {
        private static final long serialVersionUID = 1L;
        @XmlElement(name="roleMember")
        private List<RoleMemberXmlDTO.OutsideOfRole> roleMembers;

        @Override
        public List<RoleMemberXmlDTO.OutsideOfRole> getRoleMembers() {
            return this.roleMembers;
        }

        @Override
        public void setRoleMembers(List<RoleMemberXmlDTO.OutsideOfRole> roleMembers) {
            this.roleMembers = roleMembers;
        }

        @Override
        public void newItemAdded(RoleMemberXmlDTO.OutsideOfRole item) {
            try {
                RoleXmlUtil.validateAndPersistNewRoleMember(item);
            }
            catch (UnmarshalException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

