/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCachePerBrokerImpl;

public class KualiObjectCachePerBrokerImpl
extends ObjectCachePerBrokerImpl {
    private static final Logger LOG = LogManager.getLogger(KualiObjectCachePerBrokerImpl.class);
    private final String brokerId;

    public KualiObjectCachePerBrokerImpl(PersistenceBroker broker, Properties prop) {
        super(broker, prop);
        this.brokerId = broker.getClass().getName() + "@" + broker.hashCode();
        LOG.debug("created objectCache for broker " + this.brokerId);
    }

    public void clear() {
        super.clear();
        LOG.debug("cleared objectCache for broker " + this.brokerId);
    }

    public void cache(Identity oid, Object obj) {
        super.cache(oid, obj);
        boolean cached = super.lookup(oid) != null;
        LOG.debug((cached ? "cached oid " : "unable to cache oid ") + oid + " in objectCache for broker " + this.brokerId);
    }

    public boolean cacheIfNew(Identity oid, Object obj) {
        boolean cachedIfNew = super.cacheIfNew(oid, obj);
        boolean cached = super.lookup(oid) != null;
        LOG.debug((cached ? "cached new oid " : "unable to cache new oid ") + oid + " in objectCache for broker " + this.brokerId);
        return cachedIfNew;
    }

    public Object lookup(Identity oid) {
        Object o = super.lookup(oid);
        LOG.debug((o != null ? "found oid " : "cannot find oid ") + oid + " in objectCache for broker " + this.brokerId);
        return o;
    }
}

