/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser;

import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.VariableDeclarator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class ParserUtil {
    private ParserUtil() {
        throw new UnsupportedOperationException("do not call");
    }

    public static void deconstructMultiDeclarations(Collection<FieldDeclaration> fields) {
        for (FieldDeclaration field : fields) {
            ClassOrInterfaceDeclaration parent = (ClassOrInterfaceDeclaration)field.getParentNode();
            if (field.getVariables().size() <= 1) continue;
            int index = parent.getMembers().indexOf(field);
            parent.getMembers().remove(index);
            ArrayList<FieldDeclaration> deconstructed = new ArrayList<FieldDeclaration>();
            for (VariableDeclarator v : field.getVariables()) {
                FieldDeclaration f = new FieldDeclaration(field.getModifiers(), field.getAnnotations(), field.getType(), Collections.singletonList(v));
                f.setJavaDoc(field.getJavaDoc());
                f.setComment(field.getComment());
                f.setParentNode(field.getParentNode());
                deconstructed.add(f);
            }
            parent.getMembers().addAll(index, deconstructed);
        }
    }

    public static List<FieldDeclaration> getFieldMembers(List<BodyDeclaration> members) {
        if (members != null) {
            ArrayList<FieldDeclaration> fields = new ArrayList<FieldDeclaration>();
            for (BodyDeclaration member : members) {
                if (!(member instanceof FieldDeclaration)) continue;
                fields.add((FieldDeclaration)member);
            }
            return fields;
        }
        return Collections.emptyList();
    }

    public static String getFieldName(FieldDeclaration field) {
        if (field.getVariables().size() > 1) {
            throw new IllegalArgumentException("cannot handle multiple variable declarations on a single line.  This should have been cleaned up earlier.");
        }
        return ((VariableDeclarator)field.getVariables().get(0)).getId().getName();
    }

    public static void sortImports(List<ImportDeclaration> imports) {
        Collections.sort(imports, new Comparator<ImportDeclaration>(){

            @Override
            public int compare(ImportDeclaration o1, ImportDeclaration o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
    }
}

