/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.comments.BlockComment;
import japa.parser.ast.comments.Comment;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.AbstractMappedFieldResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;

public class EnumeratedResolver
extends AbstractMappedFieldResolver {
    private static final Log LOG = LogFactory.getLog(EnumeratedResolver.class);
    public static final String PACKAGE = "javax.persistence";
    public static final String SIMPLE_NAME = "Enumerated";

    public EnumeratedResolver(Collection<DescriptorRepository> descriptorRepositories) {
        super(descriptorRepositories);
    }

    @Override
    public String getFullyQualifiedName() {
        return "javax.persistence.Enumerated";
    }

    @Override
    protected NodeData getAnnotationNodes(String enclosingClass, String fieldName, String mappedClass) {
        Class<?> fc;
        FieldDescriptor fd = OjbUtil.findFieldDescriptor(mappedClass, fieldName, this.descriptorRepositories);
        if (fd != null && this.isEnum(fc = ResolverUtil.getType(enclosingClass, fieldName))) {
            BlockComment fixme = new BlockComment("\nFIXME:\nEnums must be annotated with the @Enumerated annotation.\n The @Enumerated annotation should set the EnumType.\nIf the EnumType is not set, then the Enumerated annotation is defaulted to EnumType.ORDINAL.\nThis conversion program cannot tell whether EnumType.ORDINAL is the appropriate EnumType.");
            NormalAnnotationExpr enumerated = new NormalAnnotationExpr(new NameExpr(SIMPLE_NAME), Collections.singletonList(new MemberValuePair("value", (Expression)new NameExpr("EnumType."))));
            enumerated.setComment((Comment)fixme);
            return new NodeData((AnnotationExpr)enumerated, new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false), Collections.singletonList(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), "TemporalType"), false, false)));
        }
        return null;
    }

    private boolean isEnum(Class<?> fc) {
        if (fc != null) {
            return fc.isEnum();
        }
        return false;
    }
}

