/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.comments.BlockComment;
import japa.parser.ast.comments.Comment;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.ArrayInitializerExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.SingleMemberAnnotationExpr;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.AbstractPrimaryKeyJoinColumnResolver;

public class PrimaryKeyJoinColumnsResolver
extends AbstractPrimaryKeyJoinColumnResolver {
    private static final Log LOG = LogFactory.getLog(PrimaryKeyJoinColumnsResolver.class);
    public static final String PACKAGE = "javax.persistence";
    public static final String SIMPLE_NAME = "PrimaryKeyJoinColumns";

    public PrimaryKeyJoinColumnsResolver(Collection<DescriptorRepository> descriptorRepositories) {
        super(descriptorRepositories);
    }

    @Override
    public String getFullyQualifiedName() {
        return "javax.persistence.PrimaryKeyJoinColumns";
    }

    @Override
    protected NodeData getAnnotationNodes(String enclosingClass, String fieldName, String mappedClass) {
        List<Expression> joinColumns = this.getJoinColumns(enclosingClass, fieldName, mappedClass);
        if (joinColumns != null && joinColumns.size() > 1) {
            BlockComment fixme = new BlockComment("\nFIXME: JPA_CONVERSION\nFor compound primary keys, make sure the join columns are in the correct order.\n");
            SingleMemberAnnotationExpr annotation = new SingleMemberAnnotationExpr(new NameExpr(SIMPLE_NAME), (Expression)new ArrayInitializerExpr(joinColumns));
            annotation.setComment((Comment)fixme);
            return new NodeData((AnnotationExpr)annotation, new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false), Collections.singletonList(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), "PrimaryKeyJoinColumn"), false, false)));
        }
        return null;
    }
}

