/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.CompilationUnit;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.ModifierSet;
import japa.parser.ast.body.TypeDeclaration;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ResolverUtil {
    private static final Log LOG = LogFactory.getLog(ResolverUtil.class);

    private ResolverUtil() {
        throw new UnsupportedOperationException("do not call");
    }

    public static boolean canFieldBeAnnotated(FieldDeclaration node) {
        TypeDeclaration dclr = (TypeDeclaration)node.getParentNode();
        return !ModifierSet.isStatic((int)node.getModifiers()) && dclr.getParentNode() instanceof CompilationUnit;
    }

    public static String logMsgForField(String enclosingClass, String fieldName, String mappedClass) {
        return enclosingClass + "." + fieldName + " for the mapped class " + mappedClass;
    }

    public static String logMsgForClass(String enclosingClass, String mappedClass) {
        return enclosingClass + " for the mapped class " + mappedClass;
    }

    public static Class<?> getType(String clazz, String fieldName) {
        try {
            Field field = null;
            for (Class<?> c = Class.forName(clazz); field == null && c != Object.class; c = c.getSuperclass()) {
                Field[] fields = c.getDeclaredFields();
                field = ResolverUtil.getField(fields, fieldName);
            }
            if (field != null) {
                return field.getType();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot get type from " + clazz + "." + fieldName), (Throwable)e);
        }
        return null;
    }

    private static Field getField(Field[] fields, String fieldName) {
        if (fields != null) {
            for (Field field : fields) {
                if (!fieldName.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }
}

