/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.service;

import java.util.Collection;

import org.kuali.rice.ken.bo.NotificationContentTypeBo;

/**
 * Service for accessing {@link org.kuali.rice.ken.bo.NotificationContentTypeBo}s
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface NotificationContentTypeService {
    /**
     * This method retrieves a NotificationContentType by name.
     * @param name The name of the content type
     * @return NotificationContentType
     */
    public NotificationContentTypeBo getNotificationContentType(String name);

    /**
     * This method saves a NotificationContentType object instance to the DB, creating a new, current,
     * version if one already exists.  Note that this means that this API cannot be used to modify
     * the data of an existing content type record.
     * @param contentType The NotificationContentType instance to save.
     */
    public void saveNotificationContentType(NotificationContentTypeBo contentType);

    /**
     * This method returns all current NotificationContentTypes in the system.
     * @return Collection
     */
    public Collection<NotificationContentTypeBo> getAllCurrentContentTypes();

    /**
     * This method returns all versions of all NotificationContentTypes in the system.
     * @return Collection
     */
    public Collection<NotificationContentTypeBo> getAllContentTypes();
}
