/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.document;

import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.document.Document;

/**
 * An implementation/framework interface that extends WorkflowDocument with an initialization
 * method used internally for construction.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface WorkflowDocumentPrototype extends WorkflowDocument {

    /**
     * Initialize the WorkflowDocument
     * @param principalId the interacting/consuming user principal id
     * @param document the DTO of the document this WorkflowDocument represents
     */
    public void init(String principalId, Document document);
}
